/*
 * Decompiled with CFR 0.152.
 */
package jas2.tuple;

import hepjas.analysis.NTupleEventData;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.tuple.TupleColumn;

class Cut {
    private static String[] cutTypes = new String[]{"x < Cut", "x > Cut", "Cut1 < x < Cut2", "x < Cut1 || x> Cut2"};
    double value1;
    double value2;
    private String name;
    private int type;
    private TupleColumn column;

    Cut(String name, TupleColumn column, int type) {
        this.name = name;
        this.column = column;
        this.type = type;
        Rebinnable1DHistogramData source = column.getDataSource();
        double Xmin = source.getMin();
        double Xmax = source.getMax();
        this.value1 = Xmin + 0.25 * (Xmax - Xmin);
        this.value2 = Xmin + 0.75 * (Xmax - Xmin);
    }

    TupleColumn getColumn() {
        return this.column;
    }

    public String toString() {
        return this.name;
    }

    String getName() {
        return this.name;
    }

    int getType() {
        return this.type;
    }

    void setType(int newType) {
        this.type = newType;
    }

    boolean apply(NTupleEventData data) {
        double x = data.getDouble(this.column.getIndex());
        switch (this.type) {
            case 0: {
                return x < this.value1;
            }
            case 1: {
                return x > this.value1;
            }
            case 2: {
                return x > this.value1 && x < this.value2;
            }
            case 3: {
                return x < this.value1 || x > this.value2;
            }
        }
        return false;
    }

    static String[] getTypes() {
        return cutTypes;
    }
}

