/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio.adaptor;

import hepjas.analysis.NamedObject;
import jas2.job.PageAccess;
import jas2.plugin.PageContext;
import jas2.plugin.PageEvent;
import jas2.plugin.PageListener;
import jas2.swingstudio.JASPage;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.TreeAdaptor;
import jas2.util.JASMenuItem;
import jas2.util.OnScreenPopupMenu;
import javax.swing.JPopupMenu;

public class PageTreeAdaptor
extends TreeAdaptor
implements PageListener {
    private static JPopupMenu menu;
    private PageAccess m_page;
    private PageContext pageContext;

    @Override
    public void init() {
        this.m_page = (PageAccess)this.getAssociatedObject();
    }

    @Override
    protected void updateNode(int flags) {
        if ((flags & 0x80000) != 0) {
            this.onShow();
        }
    }

    public void onShow() {
        JASPage jasPage = this.pageContext != null ? (JASPage)this.pageContext.getPage() : new JASPage(this.m_page);
        if (this.pageContext == null) {
            this.pageContext = this.getPluginContext().installPage(this.getName(), jasPage);
            this.pageContext.addPageListener(this);
        } else {
            this.pageContext.requestShow();
        }
    }

    public void onDelete() {
        this.m_page.delete();
    }

    public void onRename() {
        this.startEditing();
    }

    @Override
    public boolean stopEditing(String newName) {
        try {
            this.m_page.rename(newName);
            return true;
        }
        catch (NamedObject.RenameException x) {
            JavaAnalysisStudio.getApp().error("Illegal name", x);
            return false;
        }
    }

    @Override
    protected boolean isEditable() {
        return true;
    }

    public void onDoubleClick() {
        this.onShow();
    }

    @Override
    public void pageChanged(PageEvent e) {
        if (e.getID() == 4001) {
            this.pageContext.removePageListener(this);
            this.pageContext = null;
        }
    }

    @Override
    protected JPopupMenu getPopupMenu() {
        if (menu == null) {
            menu = new OnScreenPopupMenu();
            menu.add(new JASMenuItem("Show", 'S'));
            menu.add(new JASMenuItem("Rename", 'R'));
            menu.add(new JASMenuItem("Delete", 'D'));
        }
        return menu;
    }
}

