/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import hepjas.analysis.NTupleEventData;
import jas2.swingstudio.Cut;
import jas2.swingstudio.CutsManager;
import jas2.swingstudio.JASJob;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.ProgramPage;
import jas2.swingstudio.ProgramTextArea;
import jas2.swingstudio.TreeAdaptorSite;
import jas2.util.FileTypeFileFilter;
import jas2.util.Finishable;
import jas2.util.HasHelpPage;
import jas2.util.HasNextPages;
import jas2.util.JASDialog;
import jas2.util.JASTextField;
import jas2.util.JASWizardPage;
import jas2.util.ReservedWordBin;
import jas2.util.UserProperties;
import jas2.util.WrappingTextArea;
import jas2.util.tree.TreeItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class NewProgramPage
extends JASWizardPage
implements ActionListener,
HasNextPages,
HasHelpPage {
    private EventGeneratorPage m_generatorPage;
    private EventAnalyzerPage m_analyzerPage = null;
    private EventSourceSelectionPage m_selPage = null;
    private Field[] m_fields;
    private JASTextField m_classNameField;
    private String m_className;
    private String m_eventSourceName;
    private JRadioButton m_analyzerButton;
    private JRadioButton m_generatorButton;
    private int m_selected;
    static final int ANALYZER = 0;
    static final int GENERATOR = 1;
    private final String m_opening = "import hep.analysis.*;\nfinal public class ";
    private final JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    private final String m_tab = "\t";
    private final UserProperties m_prop = this.m_app.getUserProperties();
    private final String m_lastEventHandlerClass_Key = "LastEventHandlerClass";
    private ReservedWordBin m_resBin;
    private final String m_optionalMethodComment = "// Enter code here or delete method definition.\n";
    private final CutsManager m_cutsManager = new CutsManager();
    private String m_eventDataClassName = null;

    NewProgramPage() {
        this(-1);
    }

    NewProgramPage(int eventHandlerClass) {
        super(new FlowLayout());
        JPanel namePanel = new JPanel(new BorderLayout());
        namePanel.add("West", new JLabel("Enter the name for your class: "));
        this.m_classNameField = new JASTextField(15);
        this.m_classNameField.addKeyListener(this);
        namePanel.add("South", this.m_classNameField);
        ButtonGroup bg = new ButtonGroup();
        this.m_selected = eventHandlerClass == -1 ? this.m_prop.getInteger("LastEventHandlerClass", 0) : eventHandlerClass;
        this.m_analyzerButton = new JRadioButton("EventAnalyzer (for data analysis)", this.m_selected == 0);
        this.m_analyzerButton.addActionListener(this);
        this.m_analyzerButton.setMnemonic('A');
        bg.add(this.m_analyzerButton);
        this.m_generatorButton = new JRadioButton("EventGenerator (for event simulation)", this.m_selected == 1);
        this.m_generatorButton.addActionListener(this);
        this.m_generatorButton.setMnemonic('G');
        bg.add(this.m_generatorButton);
        JPanel classPanel = new JPanel(new BorderLayout());
        classPanel.add("North", this.m_analyzerButton);
        classPanel.add("South", this.m_generatorButton);
        classPanel.setBorder(BorderFactory.createTitledBorder("Select the class to extend"));
        JPanel p = new JPanel(new BorderLayout());
        p.add("North", namePanel);
        p.add("Center", classPanel);
        WrappingTextArea notes = new WrappingTextArea("This wizard will create a new program page suited to you task.  It will create a class with the name that you specify below and will offer to save the file under that name once you have finished selecting the style you want to have.  You must supply a legal java identifier for the class name.  The 'Next' button will not enable unless text is entered.", false, this.getBackground(), new Dimension(400, 100));
        JPanel notesPanel = new JPanel();
        notesPanel.add(notes);
        JPanel contents = new JPanel(new BorderLayout());
        contents.add("North", notesPanel);
        contents.add("Center", p);
        this.add(contents);
    }

    @Override
    public void beforeShowing() {
        this.m_classNameField.requestFocus();
    }

    @Override
    public JASWizardPage getNext() {
        this.m_className = this.m_classNameField.getText();
        if (!this.isLegalIdentifier(this.m_className)) {
            JOptionPane.showMessageDialog(this, this.m_className.concat(" is not a legal identifier."), "Error...", 0);
            return null;
        }
        this.m_prop.setInteger("LastEventHandlerClass", this.m_selected);
        if (this.m_selected == 0) {
            if (this.m_analyzerPage != null) {
                return this.m_analyzerPage;
            }
            return this.m_selPage;
        }
        return this.m_generatorPage;
    }

    @Override
    protected boolean getNextEnabled() {
        this.m_className = this.m_classNameField.getText();
        return this.m_className != null && this.m_className.length() > 0;
    }

    @Override
    public String getHelpTopic() {
        return "userInterface.programPageWizard.openingPage";
    }

    private boolean isLegalIdentifier(String s) {
        if (s == null) {
            return false;
        }
        if (this.m_resBin == null) {
            this.m_resBin = new ReservedWordBin();
        }
        if (this.m_resBin.isReservedWord(s)) {
            return false;
        }
        int length = s.length();
        for (int i = 1; i < length; ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return length > 0 && Character.isJavaIdentifierStart(s.charAt(0));
    }

    @Override
    public JASWizardPage[] getNextWizardPages() {
        JASWizardPage[] result = new JASWizardPage[2];
        this.m_generatorPage = new EventGeneratorPage();
        result[0] = this.m_generatorPage;
        JASJob job = this.m_app.getJob();
        if (job != null) {
            ComboBoxModel model = job.getComboModel();
            if (model.getSize() > 1) {
                this.m_selPage = new EventSourceSelectionPage(model, job.getListRenderer());
                result[1] = this.m_selPage;
                return result;
            }
            this.m_fields = this.getFields(model, 0);
            this.m_analyzerPage = new EventAnalyzerPage(this.m_fields != null && this.m_fields.length > 0);
        } else {
            this.m_analyzerPage = new EventAnalyzerPage(false);
        }
        result[1] = this.m_analyzerPage;
        return result;
    }

    private Field[] getFields(ComboBoxModel model, int index) {
        try {
            TreeAdaptorSite site = (TreeAdaptorSite)model.getElementAt(index);
            this.m_eventSourceName = site.getName();
            Class eventDataClass = this.m_app.getJob().getJob().getEventDataClass(site.getTreeItem());
            if (!NTupleEventData.class.isAssignableFrom(eventDataClass)) {
                this.m_eventDataClassName = eventDataClass.getName();
                return null;
            }
            Enumeration items = site.children();
            Field[] result = new Field[site.getChildCount()];
            for (int i = 0; i < result.length; ++i) {
                TreeItem item = ((TreeAdaptorSite)items.nextElement()).getTreeItem();
                result[i] = new Field(item.path[item.path.length - 1], item.type);
            }
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JRadioButton b = (JRadioButton)e.getSource();
        this.m_selected = b == this.m_analyzerButton ? 0 : 1;
    }

    private void finish(String s) {
        ProgramPage pp = new ProgramPage();
        pp.setText(s);
        pp.setClassName(this.m_className);
        this.m_app.getWindowManager().newWindow(this.m_className + "     ", pp);
        this.dispose();
        JFileChooser dlg = new JFileChooser(this.m_app.getUserProperties().getString("LastProgramPath", System.getProperty("user.home")));
        dlg.setSelectedFile(new File(this.m_className.concat(".java")));
        dlg.setFileFilter(new FileTypeFileFilter("java", "Java File (*.java)"));
        dlg.setDialogTitle("Save Source File As...");
        if (dlg.showSaveDialog(this) == 0) {
            try {
                File file = dlg.getSelectedFile();
                if (!file.getName().endsWith(".java")) {
                    file = new File(file.getAbsolutePath().concat(".java"));
                }
                this.m_app.getWindowManager().setCurrentTitle(file.getName());
                this.m_app.getUserProperties().setString("LastProgramPath", file.getParent());
                FileWriter w = new FileWriter(file);
                pp.getText().write(w);
                w.close();
                pp.setFile(file);
                this.m_app.updateRecentFiles(file);
                if (this.m_resBin != null) {
                    this.m_resBin.dispose();
                }
            }
            catch (IOException ioe) {
                this.m_app.error("Could not save job", ioe);
            }
        }
    }

    private boolean declareDataViews(StringBuffer b, HistogramsPanel p, IdentifierMonitor mon) throws IdentifierException {
        String s;
        StringTokenizer st = p.getHistograms();
        boolean areHistograms = st.hasMoreTokens();
        while (st.hasMoreTokens()) {
            s = st.nextToken();
            mon.registerUserIdentifier(s);
            b.append("\tfinal private Histogram " + s + " = new Histogram(\"" + s + "\");\n");
        }
        st = p.getScatterPlots();
        boolean areScatterPlots = st.hasMoreTokens();
        while (st.hasMoreTokens()) {
            s = st.nextToken();
            mon.registerUserIdentifier(s);
            b.append("\tfinal private ScatterPlot " + s + " = new ScatterPlot(\"" + s + "\");\n");
        }
        if (areHistograms || areScatterPlots) {
            b.append("\t// To group these ");
            if (areHistograms) {
                b.append("histograms");
                if (areScatterPlots) {
                    b.append(" and ");
                }
            }
            if (areScatterPlots) {
                b.append("plots");
            }
            b.append(" into folders,\n\t// declare some variables of type HistogramFolder,\n\t// initialize those folders in the consructor, and\n\t// pass the appropriate folder to the Histogram and\n\t// ScatterPlot constructors.\n\n");
            return true;
        }
        return false;
    }

    private void fillDataViews(StringBuffer b, HistogramsPanel p) {
        StringTokenizer st = p.getHistograms();
        boolean areHistograms = st.hasMoreTokens();
        while (st.hasMoreTokens()) {
            b.append("\t\t" + st.nextToken() + ".fill(  ); // Enter calculation for this histogram here.\n");
        }
        st = p.getScatterPlots();
        boolean areScatterPlots = st.hasMoreTokens();
        while (st.hasMoreTokens()) {
            b.append("\t\t" + st.nextToken() + ".fill( , ); // Enter calculation for this scatter plot here.\n");
        }
        if (!areHistograms && !areScatterPlots) {
            b.append("\t\t// Fill histograms and/or scatter plots here.\n");
        }
    }

    @Override
    public void onCancel() {
        if (this.m_resBin != null) {
            this.m_resBin.dispose();
        }
    }

    private void declareCuts(StringBuffer b, IdentifierMonitor mon) throws IdentifierException {
        Enumeration e = this.m_cutsManager.elements();
        boolean areElements = e.hasMoreElements();
        while (e.hasMoreElements()) {
            Cut c = (Cut)e.nextElement();
            mon.registerUserIdentifier(c.m_name);
            b.append("\tfinal private " + c.m_type + " " + c.m_name + " = new " + c.m_constructor + ";\n");
        }
        if (areElements) {
            b.append('\n');
        }
    }

    private void addOpening(StringBuffer result) {
        result.append("// This file has been automatically generated by\n");
        result.append("// the Java Analysis Studio program page wizard\n");
        if (this.m_eventSourceName != null) {
            result.append("// for the event source named\n");
            result.append("// " + this.m_eventSourceName + '\n');
        }
        result.append("// " + new Date().toString() + '\n');
    }

    static /* synthetic */ Field[] access$1702(NewProgramPage x0, Field[] x1) {
        x0.m_fields = x1;
        return x1;
    }

    private final class PreviewButton
    extends JButton {
        Previewable m_previewable;
        Frame m_frame;
        Component m_component;

        PreviewButton(Previewable p, Container c) {
            super("Show preview of selected option");
            this.setMnemonic('S');
            this.m_previewable = p;
            this.m_component = c;
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            JASDialog dialog = JASDialog.create(this, "Example output", false, 1);
            dialog.setOKLabel("Close");
            dialog.setOKMnemonic('C');
            JScrollPane scroll = new JScrollPane();
            String s = this.m_previewable.generateText();
            if (s == null) {
                return;
            }
            ProgramTextArea ta = new ProgramTextArea(false);
            ta.setText(s);
            scroll.setViewportView(ta);
            scroll.setPreferredSize(new Dimension(800, 600));
            dialog.setContentPane(scroll);
            dialog.pack();
            dialog.show();
        }
    }

    private static interface Previewable {
        public String generateText();
    }

    private final class HistogramsPanel
    extends JPanel {
        private final JASTextField m_histograms;
        private final JASTextField m_scatterPlots;

        HistogramsPanel() {
            super(new GridBagLayout());
            this.m_histograms = new JASTextField(15);
            this.m_scatterPlots = new JASTextField(15);
            GridBagConstraints c = new GridBagConstraints();
            c.insets.bottom = 2;
            c.insets.top = 2;
            c.insets.left = 2;
            c.insets.right = 2;
            c.anchor = 17;
            c.gridx = 0;
            c.gridy = 0;
            this.add((Component)new JLabel("Enter names for histograms to create:"), c);
            c.gridy = 1;
            this.add((Component)new JLabel("Enter names for scatter plots to create:"), c);
            c.fill = 2;
            c.gridx = 1;
            c.gridy = 0;
            this.add((Component)this.m_histograms, c);
            c.gridy = 1;
            this.add((Component)this.m_scatterPlots, c);
            c.gridwidth = 2;
            c.gridx = 0;
            c.gridy = 2;
            c.fill = 0;
            c.anchor = 13;
            this.add((Component)new JLabel("* Enter legal Java identifiers separated with spaces."), c);
            this.setBorder(new EtchedBorder());
        }

        StringTokenizer getHistograms() {
            return new StringTokenizer(this.m_histograms.getText());
        }

        StringTokenizer getScatterPlots() {
            return new StringTokenizer(this.m_scatterPlots.getText());
        }
    }

    private final class EventAnalyzerPage
    extends JASWizardPage
    implements ActionListener,
    Finishable,
    Previewable,
    HasHelpPage {
        private JPanel m_variableAccessPanel;
        private final char m_replacementChar = '_';
        private JRadioButton m_memberButton;
        private JRadioButton m_wrapperButton;
        private JRadioButton m_defaultButton;
        private JButton m_selectAll;
        private JButton m_selectNone;
        private final byte m_member = 0;
        private final byte m_wrapper = 1;
        private final byte m_default = 2;
        private byte m_selected;
        private HistogramsPanel m_histPanel;
        private SelectableList m_variables;
        private boolean m_dataSetOpen;
        private boolean m_optionsShowing;
        private final String m_lastDataAccessStyle_Key = "LastDataAccessStyle";

        EventAnalyzerPage(boolean areDataSets) {
            super(new BorderLayout());
            this.m_replacementChar = (char)95;
            this.m_member = 0;
            this.m_wrapper = 1;
            this.m_default = (byte)2;
            this.m_selected = 1;
            this.m_dataSetOpen = true;
            this.m_lastDataAccessStyle_Key = "LastDataAccessStyle";
            this.m_histPanel = new HistogramsPanel();
            this.add("North", this.m_histPanel);
            this.m_variableAccessPanel = new JPanel(new BorderLayout());
            this.m_optionsShowing = areDataSets;
            if (areDataSets) {
                this.makeVariableAccessPanelShowOptions();
            } else {
                this.makeVariableAccessPanelShowNoOptions();
                this.m_dataSetOpen = false;
            }
            this.m_variableAccessPanel.setBorder(BorderFactory.createTitledBorder("Select how to access the job's event data"));
            JPanel buttonPanel = new JPanel();
            JButton cuts = new JButton("Edit list of Cuts");
            cuts.addActionListener(NewProgramPage.this.m_cutsManager);
            cuts.setEnabled(false);
            buttonPanel.add(cuts);
            buttonPanel.add(new PreviewButton(this, this));
            this.add("South", buttonPanel);
            this.add("Center", this.m_variableAccessPanel);
        }

        private void makeVariableAccessPanelShowNoOptions() {
            this.m_variableAccessPanel.removeAll();
            this.m_variableAccessPanel.add("Center", new WrappingTextArea("Because no data set is currently open, or the selected data set does not specify column names, you cannot specify a wizard-generated data access style.  A default definition for processEvent() will be included in the output source file.", false, this.getBackground(), new Dimension()));
            this.validate();
        }

        private void makeVariableAccessPanelShowOptions() {
            ButtonGroup bg = new ButtonGroup();
            JPanel choicesPanel = new JPanel(new BorderLayout());
            JPanel memberVariablesPanel = new JPanel(new BorderLayout());
            this.m_selected = (byte)NewProgramPage.this.m_prop.getInteger("LastDataAccessStyle", 2);
            this.m_memberButton = new JRadioButton("Have member variables set to values of selected variables for each event.", this.m_selected == 0);
            bg.add(this.m_memberButton);
            this.m_memberButton.addActionListener(this);
            this.m_memberButton.setMnemonic('m');
            memberVariablesPanel.add("West", this.m_memberButton);
            this.m_variables = new SelectableList();
            JPanel selectButtons = new JPanel(new GridBagLayout());
            this.m_selectAll = new JButton("Select all");
            this.m_selectAll.setMnemonic('l');
            this.m_selectAll.addActionListener(this.m_variables);
            this.m_selectAll.setEnabled(this.m_selected == 0);
            this.m_selectNone = new JButton("Select none");
            this.m_selectNone.setMnemonic('e');
            this.m_selectNone.addActionListener(this.m_variables);
            this.m_selectNone.setEnabled(this.m_selected == 0);
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            selectButtons.add((Component)this.m_selectAll, c);
            c.gridx = 0;
            selectButtons.add((Component)this.m_selectNone, c);
            JPanel bottom = new JPanel(new BorderLayout());
            bottom.add("Center", this.m_variables);
            bottom.add("East", selectButtons);
            bottom.setBorder(BorderFactory.createEtchedBorder());
            memberVariablesPanel.add("South", bottom);
            choicesPanel.add("North", memberVariablesPanel);
            this.m_wrapperButton = new JRadioButton("Use a wrapper class that makes all variables accessible through convenience methods.", this.m_selected == 1);
            this.m_wrapperButton.setMnemonic('w');
            choicesPanel.add("Center", this.m_wrapperButton);
            bg.add(this.m_wrapperButton);
            this.m_wrapperButton.addActionListener(this);
            this.m_defaultButton = new JRadioButton("Use normal event data access.", this.m_selected == 2);
            this.m_defaultButton.setMnemonic('o');
            this.m_defaultButton.addActionListener(this);
            choicesPanel.add("South", this.m_defaultButton);
            bg.add(this.m_defaultButton);
            this.m_variableAccessPanel.add("North", choicesPanel);
        }

        @Override
        public void beforeShowing() {
            if (NewProgramPage.this.m_fields == null) {
                this.makeVariableAccessPanelShowNoOptions();
                this.m_optionsShowing = false;
            } else {
                if (!this.m_optionsShowing) {
                    this.m_optionsShowing = true;
                    this.makeVariableAccessPanelShowOptions();
                }
                if (this.m_variables != null) {
                    this.m_variables.init(NewProgramPage.this.m_fields);
                    this.m_variables.setEnabled(this.m_selected == 0);
                }
            }
        }

        @Override
        public String getHelpTopic() {
            return "userInterface.programPageWizard.eventAnalyzerPage";
        }

        @Override
        public void onFinish() {
            NewProgramPage.this.m_prop.setInteger("LastDataAccessStyle", this.m_selected);
            String s = this.generateText();
            if (s == null) {
                return;
            }
            NewProgramPage.this.finish(s);
        }

        @Override
        public String generateText() {
            IdentifierMonitor mon = new IdentifierMonitor();
            try {
                StringBuffer result = new StringBuffer(400);
                NewProgramPage.this.addOpening(result);
                result.append("import hep.analysis.*;\nfinal public class " + NewProgramPage.this.m_className + " extends EventAnalyzer\n{\n");
                boolean areDataViews = NewProgramPage.this.declareDataViews(result, this.m_histPanel, mon);
                NewProgramPage.this.declareCuts(result, mon);
                if (this.m_dataSetOpen && this.m_selected == 0 && this.m_variables.someSelected()) {
                    int[] indexes = this.m_variables.selectedIndexes();
                    for (int i = 0; i < indexes.length; ++i) {
                        mon.registerWizardIdentifier(((NewProgramPage)NewProgramPage.this).m_fields[indexes[i]].name);
                        mon.registerWizardIdentifier(((NewProgramPage)NewProgramPage.this).m_fields[indexes[i]].name.concat("_columnIndex"));
                        result.append("\tprivate " + this.toJavaType(((NewProgramPage)NewProgramPage.this).m_fields[indexes[i]].type) + " " + ((NewProgramPage)NewProgramPage.this).m_fields[indexes[i]].name + ";\n" + "\t" + "private int " + ((NewProgramPage)NewProgramPage.this).m_fields[indexes[i]].name + "_columnIndex = -1;\n");
                    }
                    mon.registerWizardIdentifier("columnsInitialized");
                    result.append("\tprivate boolean columnsInitialized = false;\n\n");
                } else if (this.m_dataSetOpen && this.m_selected == 1) {
                    mon.registerWizardIdentifier("data");
                    mon.registerClass("DataWrapper");
                    result.append("\tfinal private DataWrapper data = new DataWrapper();\n\n");
                }
                result.append("\tpublic " + NewProgramPage.this.m_className + "()\n" + "\t" + "{\n");
                StringTokenizer st = this.m_histPanel.getHistograms();
                String comment = "// Enter constructor code here.\n";
                result.append("\t\t" + comment + "\t" + "}\n" + "\t" + "public void beforeFirstEvent()\n" + "\t" + "{\n");
                result.append("\t\t// Enter code here or delete method definition.\n");
                result.append("\t}\n\tpublic void afterLastEvent()\n\t{\n\t\t// Enter code here or delete method definition.\n\t}\n\tpublic void processEvent(final EventData d)\n\t{\n");
                if (this.m_dataSetOpen && this.m_selected == 0 && this.m_variables.someSelected()) {
                    String name;
                    int i;
                    int[] indexes = this.m_variables.selectedIndexes();
                    result.append("\t\tfinal NTupleEventData nTupleData = (NTupleEventData) d;\n\t\tif (!columnsInitialized)\n\t\t{\n");
                    for (i = 0; i < indexes.length; ++i) {
                        name = ((NewProgramPage)NewProgramPage.this).m_fields[indexes[i]].name;
                        result.append("\t\t\t" + this.convertToLegalJava(name).concat("_columnIndex") + " = nTupleData.findColumn(\"" + name + "\");\n");
                    }
                    result.append("\t\t\tcolumnsInitialized = true;\n\t\t}\n\n");
                    for (i = 0; i < indexes.length; ++i) {
                        name = this.convertToLegalJava(((NewProgramPage)NewProgramPage.this).m_fields[indexes[i]].name);
                        result.append("\t\t" + name + " =" + this.toCast(((NewProgramPage)NewProgramPage.this).m_fields[indexes[i]].type) + "nTupleData." + this.getMethodName(((NewProgramPage)NewProgramPage.this).m_fields[indexes[i]].type) + "(" + name.concat("_columnIndex") + ");\n");
                    }
                    result.append("\n");
                } else if (this.m_dataSetOpen && this.m_selected == 1) {
                    result.append("\t\tdata.eventData = (NTupleEventData) d;\n\t\tprocessEvent();\n\t}\n\tprivate void processEvent()\n\t{\n\t\t// Use convenience methods in object data\n\t\t// to access event data.\n\n");
                } else if (NewProgramPage.this.m_eventDataClassName != null) {
                    result.append("\t\tfinal " + NewProgramPage.this.m_eventDataClassName + " data = " + '(' + NewProgramPage.this.m_eventDataClassName + ") d;\n\n");
                }
                NewProgramPage.this.fillDataViews(result, this.m_histPanel);
                result.append("\t}\n");
                if (this.m_dataSetOpen && this.m_selected == 1) {
                    result.append("\tfinal private class DataWrapper\n\t{\n\t\tNTupleEventData eventData;\n");
                    for (int i = 0; i < NewProgramPage.this.m_fields.length; ++i) {
                        String name = ((NewProgramPage)NewProgramPage.this).m_fields[i].name;
                        String legalName = this.convertToLegalJava(name);
                        String indexIdentifier = legalName.concat("_columnIndex");
                        mon.registerWizardIdentifier(indexIdentifier);
                        result.append("\n\t\tprivate int " + indexIdentifier + " = -1;\n" + "\t" + "\t" + this.toJavaType(((NewProgramPage)NewProgramPage.this).m_fields[i].type) + " get" + legalName + "()\n" + "\t" + "\t" + "{\n" + "\t" + "\t" + "\t" + "if (" + indexIdentifier + " < 0)\n" + "\t" + "\t" + "\t" + "\t" + indexIdentifier + " = eventData.findColumn(\"" + name + "\");\n" + "\t" + "\t" + "\t" + "return" + this.toCast(((NewProgramPage)NewProgramPage.this).m_fields[i].type) + "eventData." + this.getMethodName(((NewProgramPage)NewProgramPage.this).m_fields[i].type) + '(' + indexIdentifier + ");\n" + "\t" + "\t" + "}\n");
                    }
                    result.append("\t}\n");
                }
                result.append("}");
                return result.toString();
            }
            catch (IdentifierException e) {
                return null;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButton b = (JRadioButton)e.getSource();
            this.m_selected = b == this.m_defaultButton ? (byte)2 : (b == this.m_memberButton ? (byte)0 : 1);
            boolean isMember = this.m_selected == 0;
            this.m_variables.setEnabled(isMember);
            this.m_selectAll.setEnabled(isMember);
            this.m_selectNone.setEnabled(isMember);
        }

        private String toJavaType(String jasType) {
            if (jasType.equals("integer")) {
                return "int";
            }
            if (jasType.equals("float")) {
                return "double";
            }
            if (jasType.equals("string")) {
                return "String";
            }
            if (jasType.equals("boolean")) {
                return "boolean";
            }
            if (jasType.equals("date")) {
                return "java.util.Date";
            }
            if (jasType.equals("time")) {
                return "java.util.Date";
            }
            if (jasType.indexOf(46) >= 0) {
                return jasType;
            }
            return "Object";
        }

        private String toCast(String jasType) {
            if (jasType.indexOf(46) >= 0) {
                return " (" + jasType + ") ";
            }
            return " ";
        }

        private String getMethodName(String jasType) {
            if (jasType.equals("integer")) {
                return "getInt";
            }
            if (jasType.equals("float")) {
                return "getDouble";
            }
            if (jasType.equals("string")) {
                return "getString";
            }
            if (jasType.equals("boolean")) {
                return "getBoolean";
            }
            if (jasType.equals("date")) {
                return "getDate";
            }
            if (jasType.equals("time")) {
                return "getDate";
            }
            if (jasType.indexOf(46) >= 0) {
                return "getObject";
            }
            return "getObject";
        }

        private String convertToLegalJava(String s) {
            if (NewProgramPage.this.m_resBin == null) {
                NewProgramPage.this.m_resBin = new ReservedWordBin();
            }
            if (NewProgramPage.this.m_resBin.isReservedWord(s)) {
                return s.concat("_field");
            }
            char[] c = new char[s.length()];
            s.getChars(0, c.length, c, 0);
            boolean changed = false;
            if (!Character.isJavaIdentifierStart(c[0])) {
                c[0] = 95;
                changed = true;
            }
            for (int i = 1; i < c.length; ++i) {
                if (Character.isJavaIdentifierPart(c[i])) continue;
                c[i] = 95;
                changed = true;
            }
            if (changed) {
                s = new String(c);
            }
            return s;
        }

        private final class SelectableList
        extends JScrollPane
        implements ActionListener {
            private JCheckBox[] m_boxes;
            private int m_nSelected;

            SelectableList() {
                this.setPreferredSize(new Dimension(300, 120));
                this.setColumnHeaderView(new JLabel("Select the data set(s) you wish to access:"));
            }

            void init(Field[] items) {
                JPanel p = new JPanel(new GridLayout(items.length, 1, 0, 0));
                this.setViewportView(p);
                this.m_nSelected = items.length;
                this.m_boxes = new JCheckBox[this.m_nSelected];
                for (int i = 0; i < items.length; ++i) {
                    this.m_boxes[i] = new JCheckBox(items[i].name, true);
                    this.m_boxes[i].addActionListener(this);
                    p.add(this.m_boxes[i]);
                }
            }

            @Override
            public void setBorder(Border b) {
            }

            @Override
            public void setEnabled(boolean b) {
                for (int i = 0; i < this.m_boxes.length; ++i) {
                    this.m_boxes[i].setEnabled(b);
                }
            }

            boolean someSelected() {
                return this.m_nSelected > 0;
            }

            int[] selectedIndexes() {
                int[] result = new int[this.m_nSelected];
                int j = 0;
                for (int i = 0; i < this.m_boxes.length; ++i) {
                    if (!this.m_boxes[i].isSelected()) continue;
                    result[j++] = i;
                }
                return result;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object source = e.getSource();
                if (source == EventAnalyzerPage.this.m_selectAll) {
                    for (int i = 0; i < this.m_boxes.length; ++i) {
                        this.m_boxes[i].setSelected(true);
                    }
                    this.m_nSelected = this.m_boxes.length;
                    return;
                }
                if (source == EventAnalyzerPage.this.m_selectNone) {
                    for (int i = 0; i < this.m_boxes.length; ++i) {
                        this.m_boxes[i].setSelected(false);
                    }
                    this.m_nSelected = 0;
                    return;
                }
                this.m_nSelected = ((AbstractButton)source).isSelected() ? ++this.m_nSelected : --this.m_nSelected;
            }
        }

        private final class NoDataSetsException
        extends Exception {
            private NoDataSetsException() {
            }
        }
    }

    private final class EventSourceSelectionPage
    extends JASWizardPage
    implements HasNextPages,
    HasHelpPage {
        private final Object m_initialEventSource;
        final ComboBoxModel m_model;
        private final JComboBox m_choicesBox;
        private EventAnalyzerPage m_nextPage;

        EventSourceSelectionPage(ComboBoxModel model, ListCellRenderer renderer) {
            super(new FlowLayout());
            this.m_model = model;
            this.m_choicesBox = new JComboBox(model);
            this.m_choicesBox.setRenderer(renderer);
            this.add(new JLabel("Select the event source"));
            this.add(this.m_choicesBox);
            this.m_initialEventSource = model.getSelectedItem();
        }

        @Override
        public JASWizardPage[] getNextWizardPages() {
            this.m_nextPage = new EventAnalyzerPage(true);
            JASWizardPage[] result = new JASWizardPage[]{this.m_nextPage};
            return result;
        }

        @Override
        public JASWizardPage getNext() {
            NewProgramPage.access$1702(NewProgramPage.this, NewProgramPage.this.getFields(this.m_model, this.m_choicesBox.getSelectedIndex()));
            return this.m_nextPage;
        }

        @Override
        public String getHelpTopic() {
            return "userInterface.programPageWizard.selectingAnEventSource";
        }

        @Override
        public void onCancel() {
            if (this.m_model.getSelectedItem() != this.m_initialEventSource) {
                this.m_model.setSelectedItem(this.m_initialEventSource);
            }
        }
    }

    private final class EventGeneratorPage
    extends JASWizardPage
    implements Finishable,
    Previewable,
    HasHelpPage,
    ChangeListener {
        private boolean m_isValid;
        private PreviewButton m_previewButton;
        private JASTextField m_nameField;
        private JASTextField m_numberOfEventsField;
        private JASTextField m_fieldsField;
        private JLabel m_numberOfEventsLabel;
        private JCheckBox m_nEventsNotKnownBox;
        private JCheckBox m_haveSimpleEventDataClassBox;
        private JComboBox m_typesBox;
        private HistogramsPanel m_histPanel;
        private final String[] m_types_Descriptions;
        private final String[] m_types_keywords;
        private final String m_nEventsNotKnown_Key = "EventsNotKnown";
        private final String m_nEvents_Key = "nEvents";
        private final String m_haveSimpleClass_Key = "SimpleEventData";
        private final String m_dataType_Key = "DataType";

        EventGeneratorPage() {
            super(null);
            this.m_types_Descriptions = new String[]{"Double", "Int", "Date", "String"};
            this.m_types_keywords = new String[]{"double", "int", "java.util.Date", "String"};
            this.m_nEventsNotKnown_Key = "EventsNotKnown";
            this.m_nEvents_Key = "nEvents";
            this.m_haveSimpleClass_Key = "SimpleEventData";
            this.m_dataType_Key = "DataType";
            this.setLayout(new BoxLayout(this, 1));
            JPanel namePanel = new JPanel(new FlowLayout(0));
            namePanel.add(new JLabel("Enter a name for your event generator: "));
            this.m_nameField = new JASTextField(15);
            this.m_nameField.addKeyListener(this);
            namePanel.add(this.m_nameField);
            JPanel numberOfEventsPanel = new JPanel(new FlowLayout(0));
            this.m_numberOfEventsLabel = new JLabel("Enter number of events: ");
            numberOfEventsPanel.add(this.m_numberOfEventsLabel);
            this.m_numberOfEventsField = new JASTextField(NewProgramPage.this.m_prop.getString("nEvents", null), 5);
            this.m_numberOfEventsField.addKeyListener(this);
            numberOfEventsPanel.add(this.m_numberOfEventsField);
            boolean nEventsNotKnown = NewProgramPage.this.m_prop.getBoolean("EventsNotKnown", false);
            this.m_nEventsNotKnownBox = new JCheckBox("Number of events not known", nEventsNotKnown);
            this.m_nEventsNotKnownBox.setMnemonic('N');
            this.m_nEventsNotKnownBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean numberKnown = !EventGeneratorPage.this.m_nEventsNotKnownBox.isSelected();
                    EventGeneratorPage.this.m_numberOfEventsField.setEnabled(numberKnown);
                    EventGeneratorPage.this.m_numberOfEventsField.repaint();
                    EventGeneratorPage.this.m_numberOfEventsLabel.setEnabled(numberKnown);
                    EventGeneratorPage.this.m_numberOfEventsLabel.repaint();
                    EventGeneratorPage.this.doEnable();
                }
            });
            this.m_numberOfEventsField.setEnabled(!nEventsNotKnown);
            this.m_numberOfEventsLabel.setEnabled(!nEventsNotKnown);
            numberOfEventsPanel.add(this.m_nEventsNotKnownBox);
            JPanel haveSimpleEventDataClassPanel = new JPanel(null);
            haveSimpleEventDataClassPanel.setLayout(new BoxLayout(haveSimpleEventDataClassPanel, 1));
            this.m_haveSimpleEventDataClassBox = new JCheckBox("Create a simple NTupleEventData class", NewProgramPage.this.m_prop.getBoolean("SimpleEventData", true));
            this.m_haveSimpleEventDataClassBox.addChangeListener(this);
            JPanel fieldsPanel = new JPanel(new FlowLayout(0));
            final JLabel fieldsLabel = new JLabel("Enter the fields for each event: ");
            fieldsPanel.add(fieldsLabel);
            this.m_fieldsField = new JASTextField(15);
            this.m_fieldsField.addKeyListener(this);
            fieldsPanel.add(this.m_fieldsField);
            JPanel typesPanel = new JPanel(new FlowLayout(0));
            final JLabel typesLabel = new JLabel("Select the type for your data: ");
            this.m_typesBox = new JComboBox<String>(this.m_types_Descriptions);
            this.m_typesBox.setSelectedIndex(NewProgramPage.this.m_prop.getInteger("DataType", 0));
            this.m_haveSimpleEventDataClassBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean b = EventGeneratorPage.this.m_haveSimpleEventDataClassBox.isSelected();
                    fieldsLabel.setEnabled(b);
                    fieldsLabel.repaint();
                    EventGeneratorPage.this.m_fieldsField.setEnabled(b);
                    EventGeneratorPage.this.m_fieldsField.repaint();
                    typesLabel.setEnabled(b);
                    typesLabel.repaint();
                    EventGeneratorPage.this.m_typesBox.setEnabled(b);
                    EventGeneratorPage.this.m_typesBox.repaint();
                }
            });
            boolean b = this.m_haveSimpleEventDataClassBox.isSelected();
            fieldsLabel.setEnabled(b);
            this.m_fieldsField.setEnabled(b);
            typesLabel.setEnabled(b);
            this.m_typesBox.setEnabled(b);
            typesPanel.add(typesLabel);
            typesPanel.add(this.m_typesBox);
            JPanel comboBoxPanel = new JPanel(new FlowLayout(0));
            comboBoxPanel.add(this.m_haveSimpleEventDataClassBox);
            haveSimpleEventDataClassPanel.add(comboBoxPanel);
            haveSimpleEventDataClassPanel.add(fieldsPanel);
            haveSimpleEventDataClassPanel.add(typesPanel);
            haveSimpleEventDataClassPanel.setBorder(BorderFactory.createEtchedBorder());
            JPanel buttonPanel = new JPanel();
            JButton cuts = new JButton("Edit list of Cuts");
            cuts.addActionListener(NewProgramPage.this.m_cutsManager);
            cuts.setEnabled(false);
            buttonPanel.add(cuts);
            this.m_previewButton = new PreviewButton(this, this);
            buttonPanel.add(this.m_previewButton);
            this.add(namePanel);
            this.add(numberOfEventsPanel);
            this.m_histPanel = new HistogramsPanel();
            this.add(this.m_histPanel);
            this.add(haveSimpleEventDataClassPanel);
            this.add(buttonPanel);
        }

        @Override
        public String getHelpTopic() {
            return "userInterface.programPageWizard.eventGeneratorPage";
        }

        private boolean isCorrectIntegerFormat(String s) {
            try {
                if (Integer.parseInt(s) <= 0) {
                    JOptionPane.showMessageDialog(this, "You must enter a positive number.", "Error", 0);
                    return false;
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, s.concat(" is not an integer."), "Number Format Exception", 0);
                return false;
            }
            return true;
        }

        @Override
        public void onFinish() {
            String s = this.generateText();
            if (s != null) {
                boolean nEventsNotKnown = this.m_nEventsNotKnownBox.isSelected();
                NewProgramPage.this.m_prop.setBoolean("EventsNotKnown", nEventsNotKnown);
                if (!nEventsNotKnown) {
                    NewProgramPage.this.m_prop.setString("nEvents", this.m_numberOfEventsField.getText());
                }
                NewProgramPage.this.m_prop.setBoolean("SimpleEventData", this.m_haveSimpleEventDataClassBox.isSelected());
                NewProgramPage.this.m_prop.setInteger("DataType", this.m_typesBox.getSelectedIndex());
                NewProgramPage.this.finish(s);
            }
        }

        @Override
        public String generateText() {
            IdentifierMonitor mon = new IdentifierMonitor();
            try {
                boolean numberOfEventsKnown = !this.m_nEventsNotKnownBox.isSelected();
                boolean useSimpleEventData = this.m_haveSimpleEventDataClassBox.isSelected();
                String nEvents = this.m_numberOfEventsField.getText();
                if (numberOfEventsKnown && !this.isCorrectIntegerFormat(nEvents)) {
                    return null;
                }
                StringBuffer result = new StringBuffer(400);
                NewProgramPage.this.addOpening(result);
                result.append("import hep.analysis.*;\nfinal public class " + NewProgramPage.this.m_className + " extends EventGenerator\n{\n");
                boolean areDataViews = NewProgramPage.this.declareDataViews(result, this.m_histPanel, mon);
                NewProgramPage.this.declareCuts(result, mon);
                int nFields = 0;
                int dataTypeIndex = this.m_typesBox.getSelectedIndex();
                StringTokenizer st = new StringTokenizer(this.m_fieldsField.getText());
                if (useSimpleEventData) {
                    String s;
                    while (st.hasMoreTokens()) {
                        s = st.nextToken() + "_FieldIndex";
                        mon.registerWizardIdentifier(s);
                        result.append("\tfinal private int " + s + " = " + nFields++ + ";\n");
                    }
                    String nFields_Name = "nFields";
                    String hash_Name = "hash";
                    result.append("\tfinal private int nFields = " + nFields + ";\n" + "\t" + "final private java.util.Hashtable " + "hash" + " = new java.util.Hashtable(nFields, 1f);\n\n");
                    mon.registerWizardIdentifier("nFields");
                    mon.registerWizardIdentifier("hash");
                    st = new StringTokenizer(this.m_fieldsField.getText());
                    s = st.nextToken();
                    mon.registerUserIdentifier(s);
                    result.append("\tprivate " + this.m_types_keywords[dataTypeIndex] + " " + s);
                    while (st.hasMoreElements()) {
                        s = st.nextToken();
                        mon.registerUserIdentifier(s);
                        result.append(", " + s);
                    }
                    result.append(";\n\n");
                }
                String currentEvent_Name = "currentEvent";
                if (numberOfEventsKnown) {
                    String nEvents_Name = "nEvents";
                    result.append("\tfinal private int nEvents = " + nEvents + ";\n" + "\t" + "private int " + "currentEvent" + " = 0;\n\n");
                    mon.registerWizardIdentifier("nEvents");
                    mon.registerWizardIdentifier("currentEvent");
                }
                result.append("\tpublic " + NewProgramPage.this.m_className + "()\n" + "\t" + "{\n");
                st = new StringTokenizer(this.m_fieldsField.getText());
                if (useSimpleEventData) {
                    while (st.hasMoreElements()) {
                        String s = st.nextToken();
                        result.append("\t\thash.put(\"" + s + "\", new Integer(" + s + "_FieldIndex));\n");
                    }
                }
                String comment = "// Enter" + (useSimpleEventData ? " other" : "") + " constructor code here.\n";
                if (useSimpleEventData) {
                    result.append('\n');
                }
                result.append("\t\t" + comment + "\t" + "}\n" + "\t" + "public void beforeFirstEvent()\n" + "\t" + "{\n");
                if (numberOfEventsKnown) {
                    result.append("\t\t" + "currentEvent".concat(" = 0; // reset counter\n"));
                }
                if (!numberOfEventsKnown) {
                    result.append("\t\t// Enter code here or delete method definition.\n");
                }
                result.append("\t}\n\tpublic void afterLastEvent()\n\t{\n\t\t// Enter code here or delete method definition.\n\t}\n\tpublic void close()\n\t{\n\t\t// Enter code here or delete method definition.\n\t}\n\tpublic Class getEventDataClass()\n\t{\n\t\t" + (useSimpleEventData ? "return SimpleEventData.class;" : "// Return a Class object here.") + '\n' + "\t" + "}\n" + "\t" + "public EventData generateEvent() throws EndOfDataException\n" + "\t" + "{\n" + "\t" + "\t");
                if (numberOfEventsKnown) {
                    result.append("if (currentEvent++ >= nEvents) throw new EndOfDataException();\n\n");
                } else {
                    result.append("// Be sure to throw an EndOfDataException when you are done.\n\n");
                }
                st = new StringTokenizer(this.m_fieldsField.getText());
                if (useSimpleEventData) {
                    while (st.hasMoreElements()) {
                        result.append("\t\t" + st.nextElement() + " = ; // Enter calculation for this field here.\n");
                    }
                    result.append('\n');
                }
                NewProgramPage.this.fillDataViews(result, this.m_histPanel);
                if (useSimpleEventData) {
                    String eventData_Name = "eventData";
                    result.append("\n\t\tfinal SimpleEventData eventData = new SimpleEventData();\n");
                    mon.registerWizardIdentifier("eventData");
                    mon.registerClass("SimpleEventData");
                    st = new StringTokenizer(this.m_fieldsField.getText());
                    if (useSimpleEventData) {
                        while (st.hasMoreElements()) {
                            String s = st.nextToken();
                            result.append("\t\teventData.data[" + s + "_FieldIndex] = " + s + ";\n");
                        }
                    }
                    result.append("\t\treturn eventData;\n");
                } else {
                    result.append("\t\t// Create and return EventData object here.\n");
                }
                result.append("\t}\n\tpublic String getName()\n\t{\n\t\treturn \"" + this.m_nameField.getText() + "\";\n" + "\t" + "}\n");
                if (numberOfEventsKnown) {
                    result.append("\tpublic int getTotalNumberOfEvents()\n\t{\n\t\treturn nEvents;\n\t}\n");
                }
                if (useSimpleEventData) {
                    result.append("\tfinal private class SimpleEventData extends AbstractNTupleEventData\n\t{\n\t\tfinal " + this.m_types_keywords[dataTypeIndex] + "[] data = new " + this.m_types_keywords[dataTypeIndex] + "[nFields];\n" + '\n' + "\t" + "\t" + "// Note that this method is deprecated and may\n" + "\t" + "\t" + "// generate a compiler warning.  It is included\n" + "\t" + "\t" + "// for completeness, but is much slower\n" + "\t" + "\t" + "// than get" + this.m_types_Descriptions[dataTypeIndex] + "(int).\n" + "\t" + "\t" + "// The definition may be deleted.\n" + "\t" + "\t" + "public " + this.m_types_keywords[dataTypeIndex] + " get" + this.m_types_Descriptions[dataTypeIndex] + "(final String name)\n" + "\t" + "\t" + "{\n" + "\t" + "\t" + "\t" + "return data[findColumn(name)];\n" + "\t" + "\t" + "}\n" + "\t" + "\t" + "public " + this.m_types_keywords[dataTypeIndex] + " get" + this.m_types_Descriptions[dataTypeIndex] + "(final int column)\n" + "\t" + "\t" + "{\n" + "\t" + "\t" + "\t" + "return data[column];\n" + "\t" + "\t" + "}\n" + "\t" + "\t" + "public int findColumn(final String name)\n" + "\t" + "\t" + "{\n" + "\t" + "\t" + "\t" + "return ((Integer) hash.get(name)).intValue();\n" + "\t" + "\t" + "}\n" + "\t" + "}\n");
                }
                result.append("}");
                return result.toString();
            }
            catch (IdentifierException e) {
                return null;
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.doEnable();
        }

        @Override
        protected void doEnable() {
            String s;
            int length;
            boolean bl = this.m_isValid = (this.m_nEventsNotKnownBox.isSelected() || this.m_numberOfEventsField.getText().length() > 0) && this.m_nameField.getText().length() > 0;
            if (this.m_isValid && this.m_haveSimpleEventDataClassBox.isSelected() && (this.m_isValid &= (length = (s = this.m_fieldsField.getText()).length()) > 0)) {
                int index = 0;
                while (!Character.isJavaIdentifierPart(s.charAt(index))) {
                    if (++index < length) continue;
                    this.m_isValid = false;
                    break;
                }
            }
            this.m_previewButton.setEnabled(this.m_isValid);
            super.doEnable();
        }

        @Override
        protected boolean getFinishEnabled() {
            return this.m_isValid;
        }

        @Override
        public void beforeShowing() {
            this.m_nameField.setText(NewProgramPage.this.m_className);
            this.doEnable();
        }
    }

    private final class IdentifierMonitor {
        private final Vector m_classes = new Vector();
        private final Vector m_wizard = new Vector();
        private final Vector m_user = new Vector();
        private final Vector m_misc = new Vector();

        private IdentifierMonitor() {
        }

        private boolean isClassName(String s) {
            try {
                Class.forName(s);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    Class.forName("java.lang." + s);
                    return true;
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    try {
                        Class.forName("hep.analysis." + s);
                        return true;
                    }
                    catch (ClassNotFoundException classNotFoundException3) {
                        return s.equals(NewProgramPage.this.m_className) || this.m_classes.contains(s);
                    }
                }
            }
        }

        private void isConflict(String s) {
            JOptionPane.showMessageDialog(NewProgramPage.this, "You cannot use the identifier \"" + s + "\" for a field\nbecause the wizard needs to use it.", "Error", 0);
        }

        void registerClass(String s) throws IdentifierException {
            if (!NewProgramPage.this.isLegalIdentifier(s)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, "The wizard has tried to create a class\nthat is not a legal identifier: " + s, "Error", 0);
                throw new IdentifierException();
            }
            if (this.m_classes.contains(s)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, "The wizard has tried to create two classes\nwith the same name: " + s, "Error", 0);
                throw new IdentifierException();
            }
            if (this.m_wizard.contains(s) || this.m_misc.contains(s)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, "The wizard has tried to create a class\nwith the same name as an identifier: " + s, "Error", 0);
                throw new IdentifierException();
            }
            if (this.m_user.contains(s)) {
                this.isConflict(s);
                throw new IdentifierException();
            }
            this.m_classes.addElement(s);
        }

        void registerWizardIdentifier(String s) throws IdentifierException {
            if (!NewProgramPage.this.isLegalIdentifier(s)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, "The wizard has tried to create an identifier\nthat is not legal: " + s, "Error", 0);
                throw new IdentifierException();
            }
            if (this.isClassName(s)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, "The wizard has tried to create an identifier\nwith the same name as a class: " + s, "Error", 0);
                throw new IdentifierException();
            }
            if (this.m_wizard.contains(s) || this.m_misc.contains(s)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, "The wizard has tried to create two identifiers\nwith the same name: " + s, "Error", 0);
                throw new IdentifierException();
            }
            if (this.m_user.contains(s)) {
                this.isConflict(s);
                throw new IdentifierException();
            }
            this.m_wizard.addElement(s);
        }

        void registerUserIdentifier(String s) throws IdentifierException {
            if (!NewProgramPage.this.isLegalIdentifier(s)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, s.concat(" is not a legal identifier."), "Error", 0);
                throw new IdentifierException();
            }
            if (this.isClassName(s)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, "You cannot create a field with the name\n\"" + s + "\" because it is a class name.", "Error", 0);
                throw new IdentifierException();
            }
            if (this.m_user.contains(s)) {
                JOptionPane.showMessageDialog(NewProgramPage.this, "You cannot have two fields\nwith the same name: " + s, "Error", 0);
                throw new IdentifierException();
            }
            if (this.m_wizard.contains(s) || this.m_misc.contains(s)) {
                this.isConflict(s);
                throw new IdentifierException();
            }
            this.m_user.addElement(s);
        }
    }

    private final class IdentifierException
    extends Exception {
        private IdentifierException() {
        }
    }

    private static final class Field {
        final String name;
        final String type;

        Field(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }
}

