/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import hepjas.analysis.EventSource;
import hepjas.analysis.PeerSupport;
import hepjas.analysis.peer.AnalysisApplication;
import hepjas.analysis.peer.JobPeer;
import jas2.jds.module.LocalDIM;
import jas2.jds.module.ModuleException;
import jas2.job.AbstractJob;
import jas2.job.AnalysisException;
import jas2.job.JobJob;
import jas2.job.LoaderException;
import jas2.job.OpenJobException;
import jas2.plugin.RunEvent;
import jas2.plugin.RunListener;
import jas2.swingstudio.JASJob;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.Job;
import jas2.swingstudio.LocalClassLoader;
import jas2.util.tree.SimpleNodeListener;
import jas2.util.tree.TreeItem;
import java.io.EOFException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;

public class LocalJob
extends AbstractJob
implements Job,
AnalysisApplication,
Serializable {
    private static final long serialVersionUID = 1L;
    private Vector m_runListeners = new Vector();
    private transient JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    private transient JASJob m_jasJob;
    private transient int m_maxEvents = 0;
    private transient BoundedRangeModel m_progress;
    private Vector m_loaded = new Vector();
    private int m_changes = 0;
    private LocalDIM m_DIM;
    private String m_dataSource;
    private String m_dataSetName;
    private String m_jobName;

    public LocalJob(JASJob jasJob, String jobName) {
        super(jobName);
        this.m_jasJob = jasJob;
        this.m_progress = new DefaultBoundedRangeModel();
        this.m_app.setModel(this.m_progress);
        PeerSupport.setAnalysisApplication(this);
        this.setHepAnalysisJob(new hepjas.analysis.Job(jobName));
        this.m_jobName = jobName;
        this.setClassLoader(new LocalClassLoader());
        this.getTreeRoot().addNodeListener(new SimpleNodeListener(){

            @Override
            public void treeChanged(TreeItem item) {
                if ((item.flags & 2) != 0) {
                    LocalJob.this.m_jasJob.deleteNode(item);
                } else {
                    LocalJob.this.m_jasJob.addNode(item);
                }
                LocalJob.this.m_jasJob.updateTree();
            }
        });
    }

    LocalJob(JASJob jasJob, String jobName, LocalDIM dim, String dataSource) {
        this(jasJob, jobName);
        this.m_DIM = dim;
        this.m_dataSource = dataSource;
    }

    @Override
    public hepjas.analysis.Job currentJob() {
        return this.getHepAnalysisJob();
    }

    @Override
    public JobPeer createJobPeer(String s, hepjas.analysis.Job job) {
        return new JobJob(this);
    }

    @Override
    public boolean open() throws ModuleException {
        if (this.m_DIM != null) {
            EventSource es = this.m_DIM.openDataSet(this.m_dataSource);
            if (es != null) {
                this.setEventSource(es);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isLoaded(String className) {
        return this.m_loaded.contains(className);
    }

    @Override
    public void reopen(ObjectInputStream stream, JASJob jasJob) throws OpenJobException {
        this.m_app = JavaAnalysisStudio.getApp();
        if (this.m_DIM != null) {
            this.m_DIM.setLocalJobBuilder(this.m_app.getLocalJobBuilder());
        }
        this.setClassLoader(new LocalClassLoader());
        this.m_jasJob = jasJob;
        this.m_progress = new DefaultBoundedRangeModel();
        this.m_app.setModel(this.m_progress);
        PeerSupport.setAnalysisApplication(this);
        this.setHepAnalysisJob(new hepjas.analysis.Job(this.m_jobName));
        this.getTreeRoot().addNodeListener(new SimpleNodeListener(){

            @Override
            public void treeChanged(TreeItem item) {
                if ((item.flags & 2) != 0) {
                    LocalJob.this.m_jasJob.deleteNode(item);
                } else {
                    LocalJob.this.m_jasJob.addNode(item);
                }
                LocalJob.this.m_jasJob.updateTree();
            }
        });
        Enumeration e = this.m_loaded.elements();
        try {
            boolean atEnd;
            int pos;
            EventSource es;
            while (e.hasMoreElements()) {
                String s = (String)e.nextElement();
                super.loadObject(s);
            }
            if (this.m_DIM != null && (es = this.m_DIM.openDataSet(this.m_dataSource)) != null) {
                this.setEventSource(es);
            }
            try {
                pos = stream.readInt();
                atEnd = stream.readBoolean();
            }
            catch (EOFException x) {
                pos = 0;
                atEnd = false;
            }
            if (atEnd) {
                this.go(0);
            } else if (pos > 0) {
                this.go(pos);
            }
        }
        catch (Exception x) {
            throw new OpenJobException(x);
        }
    }

    public void save() {
    }

    @Override
    public void loadObject(String s) throws LoaderException {
        super.loadObject(s);
        this.m_loaded.addElement(s);
    }

    @Override
    public Class loadClientClass(String className) throws ClassNotFoundException {
        return this.m_app.getExtensionLoader().loadClass(className);
    }

    @Override
    public OutputStream getLogStream() {
        return this.m_app.getOutputStream("Log Messages");
    }

    @Override
    public OutputStream getErrorStream() {
        return this.m_app.getOutputStream("Error Messages");
    }

    @Override
    public void reload() {
        this.setClassLoader(new LocalClassLoader());
        super.unloadAll();
        Enumeration e = this.m_loaded.elements();
        try {
            while (e.hasMoreElements()) {
                super.loadObject((String)e.nextElement());
            }
        }
        catch (LoaderException le) {
            this.m_app.error("Could not reload", le);
        }
    }

    @Override
    public void unloadAll() {
        this.setClassLoader(new LocalClassLoader());
        super.unloadAll();
        this.m_loaded.removeAllElements();
    }

    @Override
    public void sendMessage(String message) {
        JavaAnalysisStudio.getApp().setMessage(message);
    }

    @Override
    protected void reportError(AnalysisException e) {
        JavaAnalysisStudio.getApp().error("Error running remote analysis (see Error Message window for details)");
    }

    @Override
    public void notifyInfo() {
        this.m_jasJob.setCommandChanged();
        this.m_maxEvents = this.eventsTotal() > 0 ? this.eventsTotal() : 100;
        this.m_progress.setMaximum(this.m_maxEvents);
        this.m_progress.setValue(this.eventsAnalyzed());
        if (!this.m_runListeners.isEmpty()) {
            this.fireRunListeners(new RunEvent(this, this.isRunning() ? 3000 : 2999));
        }
    }

    @Override
    public void notifyInfo(int i) {
        int eventsAnalyzed = i;
        if (eventsAnalyzed > this.m_maxEvents) {
            this.m_maxEvents *= 3;
            this.m_progress.setMaximum(this.m_maxEvents);
        }
        this.m_progress.setValue(eventsAnalyzed);
    }

    @Override
    public boolean isChanged() {
        return this.m_changes > 0;
    }

    @Override
    public void addRunListener(RunListener listener) {
        this.m_runListeners.addElement(listener);
    }

    @Override
    public void removeRunListener(RunListener listener) {
        this.m_runListeners.removeElement(listener);
    }

    private void fireRunListeners(RunEvent event) {
        Enumeration e = this.m_runListeners.elements();
        while (e.hasMoreElements()) {
            ((RunListener)e.nextElement()).runStateChanged(event);
        }
    }

    @Override
    protected Thread createEventLoopThread(Runnable loop) {
        Thread t = super.createEventLoopThread(loop);
        t.setPriority(t.getPriority() - 1);
        return t;
    }
}

