/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.swingstudio.JASClassPathDialog;
import jas2.util.Application;
import jas2.util.JASDialog;
import jas2.util.JASEditableComboBox;
import jas2.util.JASState;
import jas2.util.UserProperties;
import jas2.util.WrappingTextArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class LoadDialog
extends JASDialog
implements ChangeListener {
    static final String length_Key = "MaxClassesLength";
    private static final String m_message = "Specify the class name of your Java analysis routine (e.g. MyAnalysis or slac.sld.Recon). The class must extend hep.analysis.EventAnalyzer or hep.analysis.EventGenerator and must be in your current JAS_CLASSPATH.";
    private JASEditableComboBox m_classes;
    private String m_text;
    private JFrame m_frame;
    private String[] m_lastClasses;
    private static final String m_lastClasses_Key = "LastClasses";

    LoadDialog(JFrame f) {
        this(f, m_message, m_lastClasses_Key);
    }

    protected LoadDialog(JFrame f, String message, String key) {
        super((Frame)f, "Load...", true, 13);
        this.m_frame = f;
        WrappingTextArea text = new WrappingTextArea(message, false, this.getBackground(), new Dimension(340, 75));
        Container c = this.getContentPane();
        c.add((Component)text, "South");
        this.m_classes = new JASEditableComboBox(key, length_Key, true);
        JButton classPathButton = new JButton("Set Class Path ...");
        classPathButton.addActionListener(new ShowClassPath());
        c.add((Component)new JLabel("Class: "), "West");
        c.add((Component)this.m_classes, "Center");
        c.add((Component)classPathButton, "East");
        this.m_classes.addChangeListener(this);
        this.setHelpTopic("jobs.eventAnalysisAndGeneration.loadingClasses");
        this.pack();
    }

    @Override
    protected void onOK() {
        this.m_text = this.getText();
        this.m_classes.saveState();
        super.onOK();
    }

    @Override
    protected void enableOK(JASState s) {
        s.setEnabled(this.getText().length() > 0);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.callEnable();
    }

    String getClassName() {
        return this.m_text;
    }

    private String getText() {
        return this.m_classes.getText();
    }

    static void updateListWithClass(String c) {
        UserProperties p = Application.getApplication().getUserProperties();
        p.setStringArray(m_lastClasses_Key, p.updateStringArray(p.getStringArray(m_lastClasses_Key, null), c, length_Key));
    }

    private class ShowClassPath
    implements ActionListener {
        private ShowClassPath() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JASClassPathDialog dlg = new JASClassPathDialog(LoadDialog.this.m_frame);
            dlg.doModal();
        }
    }
}

