/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.jds.interfaces.Version;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.util.HasHelpPage;
import jas2.util.HasNextPages;
import jas2.util.JASDialog;
import jas2.util.JASEditableComboBox;
import jas2.util.JASWizardPage;
import jas2.util.SpinBox;
import jas2.util.UserProperties;
import jas2.util.WrappingTextArea;
import jas2.util.layout.PnutsLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

abstract class JDSWizard
extends JASWizardPage
implements HasNextPages,
HasHelpPage {
    int m_port = 1099;
    String m_service = Version.getService();
    boolean m_useRMIDefaults = true;
    InetAddress m_rmiIP;
    JASEditableComboBox m_server;
    private String[] m_lastServers;
    private final String m_lastServers_Key = "Servers";
    JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    final UserProperties m_prop = this.m_app.getUserProperties();

    JDSWizard() {
        super(new PnutsLayout("cols=2,expand=y"));
        String[] defServers = new String[]{"sldnt0.slac.stanford.edu"};
        this.m_lastServers = this.m_prop.getStringArray("Servers", defServers);
        this.m_server = new JASEditableComboBox(this.m_lastServers, true);
        JButton advanced = new JButton("Advanced Connection Options..."){

            @Override
            public void fireActionPerformed(ActionEvent e) {
                AdvancedConnectDialog dlg = new AdvancedConnectDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this));
                dlg.doModal();
            }
        };
        WrappingTextArea ta = new WrappingTextArea("Enter the name of a server that is running the Java Data Server code for Java Analysis Studio.  The server sldnt0.slac.stanford.edu is normally available for testing and contains some sample datasets. If your computer is running the Java Data Server code and you wish to access data on your computer, leave the text field blank.", false, this.getBackground(), new Dimension(400, 100));
        this.add(new JLabel("Server Name:"));
        this.add((Component)this.m_server, "halign=fill,expand=x");
        this.add((Component)advanced, "colspan=2,halign=right");
    }

    @Override
    public String getHelpTopic() {
        return "userInterface.newJobWizard.selectingAJavaDataServer";
    }

    @Override
    public void beforeShowing() {
        this.m_server.requestFocus();
    }

    void saveLastServer() {
        this.m_prop.setStringArray("Servers", UserProperties.updateStringArray(this.m_lastServers, this.m_server.getText()));
    }

    private class AdvancedConnectDialog
    extends JASDialog
    implements ActionListener {
        private SpinBox portField;
        private JTextField serviceField;
        private JCheckBox rmiDefault;
        private JComboBox rmiIPAddress;
        private JLabel rmiIPLabel;

        AdvancedConnectDialog(Frame f) {
            InetAddress[] ips;
            super(f, "Advanced Connection Options...", true, 13);
            this.setHelpTopic("userInterface.newJobWizard.advancedOptionsDialog");
            try {
                InetAddress local = InetAddress.getLocalHost();
                ips = InetAddress.getAllByName(local.getHostName());
            }
            catch (UnknownHostException x) {
                ips = null;
            }
            this.portField = new SpinBox(JDSWizard.this.m_port, 1, 9999);
            this.serviceField = new JTextField(JDSWizard.this.m_service, 20);
            this.rmiDefault = new JCheckBox("Use RMI Defaults", JDSWizard.this.m_useRMIDefaults);
            this.rmiDefault.addActionListener(this);
            this.rmiIPAddress = new JComboBox<InetAddress>(ips);
            this.rmiIPLabel = new JLabel("IP Address");
            if (JDSWizard.this.m_rmiIP != null) {
                this.rmiIPAddress.setSelectedItem(JDSWizard.this.m_rmiIP);
            }
            this.actionPerformed(null);
            JPanel p1 = new JPanel(new PnutsLayout(2, 2, 2));
            p1.setBorder(BorderFactory.createTitledBorder("Remote RMI Options"));
            p1.add((Component)new JLabel("RMI Registry Port"), "halign=right");
            p1.add((Component)this.portField, "halign=left");
            p1.add((Component)new JLabel("Service Name"), "halign=right");
            p1.add((Component)this.serviceField, "halign=left");
            JPanel p2 = new JPanel(new PnutsLayout(2, 2, 2));
            p2.setBorder(BorderFactory.createTitledBorder("Local RMI Options"));
            p2.add((Component)this.rmiDefault, "colspan=2,halign=left");
            p2.add(this.rmiIPLabel);
            p2.add((Component)this.rmiIPAddress, "halign=left");
            JPanel p = new JPanel(new PnutsLayout("cols=1,halign=fill"));
            p.add(p1);
            p.add(p2);
            this.setContentPane(p);
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean enable = !this.rmiDefault.isSelected();
            this.rmiIPAddress.setEnabled(enable);
            this.rmiIPLabel.setEnabled(enable);
        }

        @Override
        public void onOK() {
            JDSWizard.this.m_port = this.portField.getValue();
            JDSWizard.this.m_service = this.serviceField.getText();
            JDSWizard.this.m_useRMIDefaults = this.rmiDefault.isSelected();
            JDSWizard.this.m_rmiIP = (InetAddress)this.rmiIPAddress.getSelectedItem();
            if (!JDSWizard.this.m_useRMIDefaults) {
                System.getProperties().put("java.rmi.server.hostname", JDSWizard.this.m_rmiIP.getHostAddress());
            } else {
                System.getProperties().remove("java.rmi.server.hostname");
            }
            super.onOK();
        }
    }
}

