/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.swingstudio.JASCommandProcessor;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.JobToolBar;
import jas2.swingstudio.RebinSlider;
import jas2.util.Application;
import jas2.util.JASCheckboxMenuItem;
import jas2.util.JASCheckboxState;
import jas2.util.UserProperties;
import jas2.util.layout.ToolbarLayout;
import jas2.util.xmlmenus.XMLMenuBuilder;
import java.awt.Component;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class JASToolbarHolder
extends JPanel {
    private boolean doNotTouchCheckBoxMenu = false;
    private JToolBar m_applicationToolBar;
    private JToolBar m_codeToolBar;
    private JToolBar m_jobToolBar;
    private JToolBar m_webToolBar;
    private JToolBar m_rebinSlider;
    private ToolbarCommand m_command = new ToolbarCommand();
    private static final int VIEW_MENU = 4;
    private static final int TOOLBAR_MENU = 0;
    private boolean largeIcons = false;
    private boolean showText = false;
    private JPopupMenu theToolBarPopupMenu;
    private UserProperties userProp = Application.getApplication().getUserProperties();
    private static final String applicationToolbarProp = "ApplicationToolbarVisible";
    private static final String jobToolbarProp = "JobToolbarVisible";
    private static final String codeToolbarProp = "CodeToolbarVisible";
    private static final String webToolbarProp = "WebToolbarVisible";
    private static final String rebinSliderProp = "RebinSliderVisible";

    public JASToolbarHolder(XMLMenuBuilder xmb) {
        this.m_applicationToolBar = xmb.getToolBar("applicationToolBar");
        this.m_jobToolBar = xmb.getToolBar("jobToolBar");
        this.m_codeToolBar = xmb.getToolBar("codeToolBar");
        this.m_webToolBar = xmb.getToolBar("webToolBar");
        this.m_rebinSlider = xmb.getToolBar("rebinSlider");
        this.addIfVisible(this.m_applicationToolBar);
        this.addIfVisible(this.m_jobToolBar);
        this.addIfVisible(this.m_codeToolBar);
        this.addIfVisible(this.m_webToolBar);
        this.addIfVisible(this.m_rebinSlider);
        this.theToolBarPopupMenu = JavaAnalysisStudio.getApp().getXMLMenuBuilder().getPopupMenu("toolbarPopupMenu");
        JavaAnalysisStudio.getApp().getCommandManager().add(this.m_command);
        this.setLayout(new ToolbarLayout(0, 5, 5));
        this.enableEvents(16L);
    }

    @Override
    public Component add(Component comp) {
        this.setToolbarCheckBoxMenuEnabled(comp, true, false);
        return super.add(comp);
    }

    @Override
    public Component add(Component comp, int index) {
        this.setToolbarCheckBoxMenuEnabled(comp, true, false);
        return super.add(comp, index);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.setToolbarCheckBoxMenuEnabled(comp, true, false);
        super.add(comp, constraints);
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.setToolbarCheckBoxMenuEnabled(comp, true, false);
        super.add(comp, constraints, index);
    }

    @Override
    public Component add(String name, Component comp) {
        this.setToolbarCheckBoxMenuEnabled(comp, true, false);
        return super.add(name, comp);
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        this.setToolbarCheckBoxMenuEnabled(comp, false, true);
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.isPopupTrigger()) {
            this.theToolBarPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void addIfVisible(JToolBar t) {
        if (t.getName().equals("applicationToolBar")) {
            if (this.getApplicationToolbarVisible()) {
                this.add(this.m_applicationToolBar);
            }
        } else if (t.getName().equals("jobToolBar")) {
            if (this.getJobToolbarVisible()) {
                this.add(this.m_jobToolBar);
            }
        } else if (t.getName().equals("codeToolBar")) {
            if (this.getCodeToolbarVisible()) {
                this.add(this.m_codeToolBar);
            }
        } else if (t.getName().equals("webToolBar")) {
            if (this.getWebToolbarVisible()) {
                this.add(this.m_webToolBar);
            }
        } else if (t.getName().equals("rebinSlider") && this.getRebinSliderVisible()) {
            this.add(this.m_rebinSlider);
        }
    }

    private void changeMenu(int index, boolean enabled, boolean calledByRemove) {
        if (calledByRemove) {
            JMenu toolbarmenu = (JMenu)JavaAnalysisStudio.getApp().getMenuBar().getMenu(4).getPopupMenu().getComponent(0);
            ((JASCheckboxMenuItem)toolbarmenu.getItem(index)).setCorrespondingToolBarFloating(true);
        } else {
            JMenu toolbarmenu = (JMenu)JavaAnalysisStudio.getApp().getMenuBar().getMenu(4).getPopupMenu().getComponent(0);
            ((JASCheckboxMenuItem)toolbarmenu.getItem(index)).setCorrespondingToolBarFloating(false);
        }
        JavaAnalysisStudio.getApp().getMenuBar().getMenu(4).getPopupMenu().getComponent(index).setEnabled(enabled);
        if (this.theToolBarPopupMenu != null) {
            this.theToolBarPopupMenu.getComponent(index).setEnabled(enabled);
        }
    }

    private void setToolbarCheckBoxMenuEnabled(Component comp, boolean enabled, boolean calledByRemove) {
        String name = comp.getName();
        if (!this.doNotTouchCheckBoxMenu) {
            if (name.equals("applicationToolBar")) {
                this.changeMenu(0, enabled, calledByRemove);
            } else if (name.equals("jobToolBar")) {
                this.changeMenu(1, enabled, calledByRemove);
            } else if (name.equals("codeToolBar")) {
                this.changeMenu(2, enabled, calledByRemove);
            } else if (name.equals("webToolBar")) {
                this.changeMenu(3, enabled, calledByRemove);
            } else if (name.equals("rebinSlider")) {
                this.changeMenu(4, enabled, calledByRemove);
            } else {
                System.out.println("ERROR: unknown toolbar");
            }
        }
    }

    private void setAToolbarVisible(JToolBar theToolBar, String theProp, boolean visible) {
        if (visible) {
            this.add(theToolBar);
        } else {
            this.doNotTouchCheckBoxMenu = true;
            this.remove(theToolBar);
            this.doNotTouchCheckBoxMenu = false;
        }
        this.userProp.setBoolean(theProp, visible);
        this.revalidate();
        this.repaint();
    }

    public void setApplicationToolbarVisible(boolean visible) {
        this.setAToolbarVisible(this.m_applicationToolBar, applicationToolbarProp, visible);
    }

    public void setJobToolbarVisible(boolean visible) {
        this.setAToolbarVisible(this.m_jobToolBar, jobToolbarProp, visible);
    }

    public void setCodeToolbarVisible(boolean visible) {
        this.setAToolbarVisible(this.m_codeToolBar, codeToolbarProp, visible);
    }

    public void setWebToolbarVisible(boolean visible) {
        this.setAToolbarVisible(this.m_webToolBar, webToolbarProp, visible);
    }

    public void setRebinSliderVisible(boolean visible) {
        this.setAToolbarVisible(this.m_rebinSlider, rebinSliderProp, visible);
    }

    public boolean getApplicationToolbarVisible() {
        return this.userProp.getBoolean(applicationToolbarProp, true);
    }

    private boolean getJobToolbarVisible() {
        return this.userProp.getBoolean(jobToolbarProp, true);
    }

    private boolean getCodeToolbarVisible() {
        return this.userProp.getBoolean(codeToolbarProp, true);
    }

    private boolean getWebToolbarVisible() {
        return this.userProp.getBoolean(webToolbarProp, true);
    }

    private boolean getRebinSliderVisible() {
        return this.userProp.getBoolean(rebinSliderProp, true);
    }

    JComboBox getEventSourceComboBox() {
        return ((JobToolBar)this.m_jobToolBar).getEventSourceComboBox();
    }

    void setRebinModel(BoundedRangeModel xModel, BoundedRangeModel yModel) {
        ((RebinSlider)this.m_rebinSlider).setModel(xModel, yModel);
    }

    private class ToolbarCommand
    extends JASCommandProcessor {
        private ToolbarCommand() {
        }

        public void onApplicationToolbar(boolean b) {
            JASToolbarHolder.this.setApplicationToolbarVisible(b);
            this.setChanged();
        }

        public void onJobToolbar(boolean b) {
            JASToolbarHolder.this.setJobToolbarVisible(b);
            this.setChanged();
        }

        public void onCodeToolbar(boolean b) {
            JASToolbarHolder.this.setCodeToolbarVisible(b);
            this.setChanged();
        }

        public void onWebToolbar(boolean b) {
            JASToolbarHolder.this.setWebToolbarVisible(b);
            this.setChanged();
        }

        public void onRebinSlider(boolean b) {
            JASToolbarHolder.this.setRebinSliderVisible(b);
            this.setChanged();
        }

        public void enableApplicationToolbar(JASCheckboxState state) {
            state.setCheckbox(JASToolbarHolder.this.getApplicationToolbarVisible());
            state.setEnabled(true);
        }

        public void enableJobToolbar(JASCheckboxState state) {
            state.setCheckbox(JASToolbarHolder.this.getJobToolbarVisible());
            state.setEnabled(true);
        }

        public void enableCodeToolbar(JASCheckboxState state) {
            state.setCheckbox(JASToolbarHolder.this.getCodeToolbarVisible());
            state.setEnabled(true);
        }

        public void enableWebToolbar(JASCheckboxState state) {
            state.setCheckbox(JASToolbarHolder.this.getWebToolbarVisible());
            state.setEnabled(true);
        }

        public void enableRebinSlider(JASCheckboxState state) {
            state.setCheckbox(JASToolbarHolder.this.getRebinSliderVisible());
            state.setEnabled(true);
        }

        public void onLargeIcons(boolean b) {
            JASToolbarHolder.this.largeIcons = b;
            this.setChanged();
        }

        public void onShowText(boolean b) {
            JASToolbarHolder.this.showText = b;
            this.setChanged();
        }

        public void enableLargeIcons(JASCheckboxState state) {
            state.setCheckbox(JASToolbarHolder.this.largeIcons);
            state.setEnabled(true);
        }

        public void enableShowText(JASCheckboxState state) {
            state.setCheckbox(JASToolbarHolder.this.showText);
            state.setEnabled(true);
        }
    }
}

