/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.hist.DataSource;
import jas2.hist.ExtendedStatistics;
import jas2.hist.HasStatistics;
import jas2.hist.HasStyle;
import jas2.hist.HistogramUpdate;
import jas2.hist.JASHistStyle;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.hist.Statistics;
import jas2.jds.interfaces.Remote1DHistogramInfo;
import jas2.jds.interfaces.RemoteRebinnable1DHistogramData;
import jas2.jds.interfaces.RemoteRebinnable2DHistogramData;
import jas2.jds.interfaces.RemoteScatterSource;
import jas2.swingstudio.JAS2DRebinAdaptor;
import jas2.swingstudio.JASScatterAdaptor;
import jas2.util.rmi.RMIDestination;
import jas2.util.rmi.RMIEventDelivery;
import java.rmi.RemoteException;
import java.rmi.ServerRuntimeException;
import java.util.Observable;
import java.util.Observer;

public class JASRebinAdaptor
extends Observable
implements Rebinnable1DHistogramData,
Observer,
HasStyle,
HasStatistics,
ExtendedStatistics {
    private double[][] cacheData;
    private Statistics cacheStats;
    private int cacheBins;
    private double cacheMin;
    private double cacheMax;
    private boolean cacheErrors;
    private Remote1DHistogramInfo info;
    private String[] axisLabels;
    private RemoteRebinnable1DHistogramData m_remote;
    private static final boolean debug = System.getProperty("debugCache") != null;

    public JASRebinAdaptor(RemoteRebinnable1DHistogramData source, RMIDestination obs) {
        obs.addObserver(this);
        this.m_remote = source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable obs, Object arg) {
        HistogramUpdate hu = (HistogramUpdate)arg;
        if (debug) {
            System.out.println("JASRebinAdaptor: update " + hu);
        }
        this.setChanged();
        JASRebinAdaptor jASRebinAdaptor = this;
        synchronized (jASRebinAdaptor) {
            if (hu.isDataUpdate()) {
                this.cacheStats = null;
                this.cacheData = null;
            }
            if (hu.isRangeUpdate()) {
                this.info = null;
                this.axisLabels = null;
            }
            if (hu.isTitleUpdate()) {
                this.info = null;
            }
            if (hu.isReset()) {
                this.info = null;
                this.cacheStats = null;
                this.cacheData = null;
                this.axisLabels = null;
            }
        }
        this.notifyObservers(hu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][] rebin(int bins, double min, double max, boolean wantErrors, boolean hurry) {
        double[][] result;
        if (this.cacheData != null && (bins != this.cacheBins || min != this.cacheMin || max != this.cacheMax || wantErrors && !this.cacheErrors)) {
            this.cacheData = null;
        }
        if ((result = this.cacheData) == null) {
            try {
                JASRebinAdaptor jASRebinAdaptor = this;
                synchronized (jASRebinAdaptor) {
                    this.cacheData = result = this.m_remote.remoteRebin(bins, min, max, wantErrors, hurry);
                }
                if (hurry) {
                    return result;
                }
                this.cacheBins = bins;
                this.cacheMin = min;
                this.cacheMax = max;
                this.cacheErrors = wantErrors;
            }
            catch (ServerRuntimeException e) {
                System.out.println("Server Runtime exception!!");
                e.detail.printStackTrace();
            }
            catch (RemoteException e) {
                System.out.println("Terrible problem during remote rebin!!");
                e.printStackTrace();
            }
        } else if (debug) {
            System.out.println("Data found in cache");
        }
        return result;
    }

    @Override
    public double getMin() {
        Remote1DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return myinfo.m_min;
    }

    @Override
    public double getMax() {
        Remote1DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return myinfo.m_max;
    }

    @Override
    public int getBins() {
        Remote1DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return myinfo.m_bins;
    }

    @Override
    public int getAxisType() {
        Remote1DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return myinfo.m_axisType;
    }

    @Override
    public boolean isRebinnable() {
        Remote1DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return myinfo.m_isRebinnable;
    }

    @Override
    public String getTitle() {
        Remote1DHistogramInfo myinfo = this.info;
        if (myinfo == null) {
            myinfo = this.setInfo();
        }
        return myinfo.m_title;
    }

    @Override
    public String[] getAxisLabels() {
        String[] myAxisLabels = this.axisLabels;
        if (myAxisLabels == null) {
            myAxisLabels = this.getRemoteAxisLabels();
        }
        return myAxisLabels;
    }

    @Override
    public JASHistStyle getStyle() {
        try {
            return this.m_remote.getStyle();
        }
        catch (RemoteException e) {
            System.out.println(e);
            return null;
        }
    }

    private String[] getRemoteAxisLabels() {
        String[] myAxisLabels;
        try {
            myAxisLabels = this.m_remote.getRemoteAxisLabels();
            this.axisLabels = myAxisLabels;
        }
        catch (RemoteException e) {
            System.out.println(e);
            return null;
        }
        return myAxisLabels;
    }

    private Remote1DHistogramInfo setInfo() {
        Remote1DHistogramInfo myinfo;
        try {
            this.info = myinfo = this.m_remote.getRemoteInfo();
        }
        catch (RemoteException e) {
            System.out.println(e);
            return null;
        }
        return myinfo;
    }

    public String toString() {
        try {
            return this.m_remote.getDescription();
        }
        catch (RemoteException e) {
            return super.toString();
        }
    }

    @Override
    public Statistics getStatistics() {
        Statistics stats = this.cacheStats;
        if (stats == null) {
            stats = this.getStats();
        }
        return stats == null ? null : this;
    }

    @Override
    public String[] getStatisticNames() {
        Statistics stats = this.cacheStats;
        if (stats == null) {
            stats = this.getStats();
        }
        return stats.getStatisticNames();
    }

    @Override
    public double getStatistic(String name) {
        Statistics stats = this.cacheStats;
        if (stats == null) {
            stats = this.getStats();
        }
        return stats.getStatistic(name);
    }

    @Override
    public Object getExtendedStatistic(String name) {
        Statistics stats = this.cacheStats;
        if (stats == null) {
            stats = this.getStats();
        }
        if (stats instanceof ExtendedStatistics) {
            return ((ExtendedStatistics)stats).getExtendedStatistic(name);
        }
        return null;
    }

    private Statistics getStats() {
        try {
            Statistics stats;
            this.cacheStats = stats = this.m_remote.getStatistics();
            return stats;
        }
        catch (RemoteException e) {
            System.out.println(e);
            return null;
        }
    }

    static DataSource getAdaptor(Object obj, RMIEventDelivery ed, RMIDestination dest) throws RemoteException {
        if (obj instanceof RemoteRebinnable1DHistogramData) {
            return new JASRebinAdaptor((RemoteRebinnable1DHistogramData)obj, dest);
        }
        if (obj instanceof RemoteScatterSource) {
            return new JASScatterAdaptor((RemoteScatterSource)obj, dest, ed);
        }
        if (obj instanceof RemoteRebinnable2DHistogramData) {
            return new JAS2DRebinAdaptor((RemoteRebinnable2DHistogramData)obj, dest, ed);
        }
        throw new RuntimeException("Unknown RemoteDataSource");
    }
}

