/*
 * Decompiled with CFR 0.152.
 */
package jas2.swingstudio;

import jas2.plugin.PageContext;
import jas2.plugin.PageEvent;
import jas2.plugin.PageListener;
import jas2.swingstudio.Closable;
import jas2.swingstudio.FullScreenWindow;
import jas2.swingstudio.HasCommandProcessor;
import jas2.swingstudio.JavaAnalysisStudio;
import jas2.swingstudio.PageListenerInfo;
import jas2.swingstudio.WindowItem;
import jas2.swingstudio.WindowManager;
import jas2.util.xml.XMLWriter;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;

final class InternalFramesWindowManager
extends JDesktopPane
implements WindowManager,
InternalFrameListener {
    private boolean m_changed = false;
    private Vector m_frames;
    private Vector m_listeners;
    private DesktopManager m_desktopManager;
    private int m_nCascaded = 0;
    private boolean init = false;
    private final int m_xCascadeOffset = 20;
    private final int m_yCascadeOffset = 20;
    private final float m_xCascadeFraction = 0.75f;
    private final float m_yCascadeFraction = 0.75f;
    private final JavaAnalysisStudio m_app = JavaAnalysisStudio.getApp();
    static final int CASCADE = -3;
    static final int TILE_HORIZONTALLY = -4;
    static final int TILE_VERTICALLY = -5;

    InternalFramesWindowManager() {
        this.m_desktopManager = this.getDesktopManager();
        this.m_frames = new Vector();
        this.putClientProperty("JDesktopPane.dragMode", "faster");
    }

    @Override
    public void newWindow(String name, Component c) {
        JInternalFrame frame = new JInternalFrame(name, true, true, true, true);
        frame.setDefaultCloseOperation(0);
        this.m_frames.addElement(frame);
        frame.setContentPane((Container)c);
        this.add(frame);
        if (this.init) {
            this.cascadeFrame(frame);
        }
        frame.addInternalFrameListener(this);
        frame.show();
        this.m_changed = true;
    }

    private void cascadeFrame(JInternalFrame frame) {
        Dimension paneSize = this.getSize();
        Dimension frameSize = new Dimension();
        frameSize.height = (int)((float)paneSize.height * 0.75f);
        frameSize.width = (int)((float)paneSize.width * 0.75f);
        Point position = new Point();
        position.translate(this.m_nCascaded * 20, this.m_nCascaded * 20);
        frame.setLocation(position);
        frame.setPreferredSize(frameSize);
        frame.setSize(frameSize);
        ++this.m_nCascaded;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (!this.init) {
            this.arrange(-3);
            this.init = true;
        }
    }

    void arrange(int index) {
        this.m_nCascaded = 0;
        JInternalFrame[] frames = this.getAllFrames();
        if (index == -3) {
            for (int i = frames.length - 1; i >= 0; --i) {
                JInternalFrame frame = frames[i];
                if (frame.isIcon()) continue;
                try {
                    frames[i].setMaximum(false);
                    this.cascadeFrame(frame);
                    continue;
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        } else {
            int numberOfWindows;
            int nLeft = numberOfWindows = this.getWindowCount();
            for (int i = 0; i < numberOfWindows; ++i) {
                if (frames[i].isIcon()) {
                    --nLeft;
                    continue;
                }
                try {
                    frames[i].setMaximum(false);
                    continue;
                }
                catch (PropertyVetoException x) {
                    --nLeft;
                }
            }
            int n = (int)Math.sqrt(nLeft);
            if (n < 1) {
                return;
            }
            int paneWidth = this.getSize().width;
            int paneHeight = this.getSize().height;
            boolean isHorizontal = index == -4;
            int xTranslation_1 = isHorizontal ? paneWidth / n : 0;
            int yTranslation_1 = isHorizontal ? 0 : paneHeight / n;
            int k = 0;
            Dimension size = new Dimension();
            Point point = new Point();
            int xTranslation_2 = 0;
            int yTranslation_2 = 0;
            if (isHorizontal) {
                size.width = paneWidth / n;
            } else {
                size.height = paneHeight / n;
            }
            block6: for (int i = 0; i < n; ++i) {
                point.setLocation(0, 0);
                point.translate(i * xTranslation_1, i * yTranslation_1);
                int nThis = nLeft / (n - i);
                nLeft -= nThis;
                if (isHorizontal) {
                    yTranslation_2 = size.height = paneHeight / nThis;
                } else {
                    xTranslation_2 = size.width = paneWidth / nThis;
                }
                int j = 0;
                while (true) {
                    JInternalFrame frame;
                    if ((frame = frames[k++]).isIcon() || frame.isMaximum()) {
                        continue;
                    }
                    frame.setSize(new Dimension(size));
                    frame.setLocation(new Point(point));
                    if (++j >= nThis) continue block6;
                    point.translate(xTranslation_2, yTranslation_2);
                }
            }
        }
    }

    @Override
    public void closeAllWindows() {
        for (int i = this.m_frames.size() - 1; i >= 0; --i) {
            if (this.closeWindow(i)) continue;
            return;
        }
        int n = this.m_frames.size();
        if (n == 0) {
            this.m_app.setNPages(0);
        }
    }

    @Override
    public boolean closeWindow(int i) {
        return this.closeWindow((JInternalFrame)this.m_frames.elementAt(i));
    }

    private Component detachWindow(int i) {
        return this.detachWindow((JInternalFrame)this.m_frames.elementAt(i));
    }

    private Component detachWindow(JInternalFrame f) {
        Container c = f.getContentPane();
        JInternalFrame[] a = this.getAllFrames();
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != f) continue;
            this.remove(i);
            this.m_frames.removeElement(f);
            this.checkRemoval(f);
            this.selectLastWindow();
            this.m_changed = true;
        }
        return c;
    }

    @Override
    public void doFullScreen() {
        int index = this.getSelectedWindow();
        final String name = this.getWindowName(index);
        final Component c = this.detachWindow(index);
        final FullScreenWindow w = new FullScreenWindow(this.m_app.getFrame(), (JComponent)c);
        w.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                w.dispose();
                InternalFramesWindowManager.this.newWindow(name, c);
                InternalFramesWindowManager.this.m_app.getFrame().repaint();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                InternalFramesWindowManager.this.newWindow(name, c);
                InternalFramesWindowManager.this.m_app.getFrame().repaint();
            }
        });
    }

    private boolean closeWindow(JInternalFrame f) {
        Container c = f.getContentPane();
        try {
            if (c instanceof Closable && !((Closable)((Object)c)).pleaseClose()) {
                return false;
            }
        }
        catch (Exception e) {
            this.m_app.error("Error", e);
            return false;
        }
        JInternalFrame[] a = this.getAllFrames();
        for (int i = 0; i < a.length; ++i) {
            if (a[i] != f) continue;
            this.firePageClosed(f.getContentPane());
            this.remove(i);
            this.m_frames.removeElement(f);
            this.checkRemoval(f);
            this.selectLastWindow();
            this.m_changed = true;
            this.repaint();
            return true;
        }
        return true;
    }

    private void selectLastWindow() {
        JInternalFrame[] frames = this.getAllFrames();
        if (frames.length > 0) {
            try {
                frames[0].setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    @Override
    public Vector openPages(Class pageClass) {
        Vector<Container> result = new Vector<Container>();
        Enumeration e = this.m_frames.elements();
        while (e.hasMoreElements()) {
            JInternalFrame f = (JInternalFrame)e.nextElement();
            Container c = f.getContentPane();
            if (pageClass != null && !pageClass.isInstance(c)) continue;
            result.addElement(c);
        }
        return result;
    }

    @Override
    public WindowItem[] getItems() {
        int n = this.m_frames.size();
        WindowItem[] result = new WindowItem[n];
        for (int i = 0; i < n; ++i) {
            JInternalFrame f = this.elementAt(i);
            result[i] = new WindowItem(f.getTitle(), f.getContentPane());
        }
        return result;
    }

    @Override
    public void initialize(WindowItem[] wa, Vector listeners) {
        int i;
        this.m_listeners = listeners;
        this.m_nCascaded = 0;
        this.removeAll();
        this.m_frames.removeAllElements();
        int nPages = 0;
        for (i = 0; i < wa.length; ++i) {
            String name = wa[i].name;
            this.newWindow(name, wa[i].Component);
            if (!name.startsWith("Page ")) continue;
            ++nPages;
        }
        for (i = 0; i < wa.length; ++i) {
            wa[i].Component.setVisible(true);
        }
        this.m_app.setNPages(nPages);
        this.m_changed = false;
    }

    @Override
    public void selectWindow(int i) {
        this.m_desktopManager.activateFrame(this.elementAt(i));
        int formerlySelected = this.getSelectedWindow();
        try {
            JInternalFrame frame;
            if (formerlySelected >= 0) {
                frame = this.elementAt(formerlySelected);
                frame.setSelected(false);
                this.m_desktopManager.deactivateFrame(frame);
            }
            frame = this.elementAt(i);
            frame.setSelected(true);
            frame.setIcon(false);
            frame.moveToFront();
            this.m_changed = true;
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public String getWindowName(int i) {
        return this.elementAt(i).getTitle();
    }

    @Override
    public Component getWindow(int i) {
        return this.elementAt(i).getContentPane();
    }

    @Override
    public int getWindowCount() {
        return this.m_frames.size();
    }

    @Override
    public int getSelectedWindow() {
        int n = this.m_frames.size();
        for (int i = 0; i < n; ++i) {
            if (!this.elementAt(i).isSelected()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void setCurrentTitle(String s) {
        int i = this.getSelectedWindow();
        if (i >= 0) {
            this.elementAt(i).setTitle(s);
        }
    }

    @Override
    public void saveState(XMLWriter xml) {
        this.m_changed = false;
    }

    private JInternalFrame elementAt(int i) {
        return (JInternalFrame)this.m_frames.elementAt(i);
    }

    private void checkRemoval(JInternalFrame f) {
        if (this.m_frames.size() == 0) {
            this.m_app.setNPages(0);
            this.m_nCascaded = 0;
        }
    }

    @Override
    public int find(Component c) {
        int n = this.getWindowCount();
        for (int i = 0; i < n; ++i) {
            if (this.getWindow(i) != c) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void addPageListener(Component Component2, PageListener listener, PageContext context) {
        if (this.m_listeners == null) {
            this.m_listeners = new Vector(4, 2);
        }
        this.m_listeners.addElement(new PageListenerInfo(Component2, listener, context));
    }

    @Override
    public void removePageListener(PageListener listener) {
        if (this.m_listeners != null) {
            int n = this.m_listeners.size();
            int i = 0;
            while (i < n) {
                PageListenerInfo info = (PageListenerInfo)this.m_listeners.elementAt(i);
                if (info.listener == listener) {
                    this.m_listeners.removeElementAt(i);
                    --n;
                    continue;
                }
                ++i;
            }
        }
    }

    public void removeListenersForComponent(Component c) {
        if (this.m_listeners != null) {
            int n = this.m_listeners.size();
            int i = 0;
            while (i < n) {
                PageListenerInfo info = (PageListenerInfo)this.m_listeners.elementAt(i);
                if (info.Component == c) {
                    this.m_listeners.removeElementAt(i);
                    --n;
                    continue;
                }
                ++i;
            }
        }
    }

    private void firePageClosed(Component c) {
        this.notifyListenersForComponent(c, 4001);
        this.removeListenersForComponent(c);
    }

    private void firePageSelected(Component c) {
        if (c instanceof Closable) {
            ((Closable)((Object)c)).pageSelected(true);
        }
        this.notifyListenersForComponent(c, 3999);
    }

    private void firePageDeselected(Component c) {
        if (c instanceof Closable) {
            ((Closable)((Object)c)).pageSelected(false);
        }
        this.notifyListenersForComponent(c, 4000);
    }

    private void firePageIconized(Component c) {
        this.notifyListenersForComponent(c, 4002);
    }

    private void firePageDeiconized(Component c) {
        this.notifyListenersForComponent(c, 4003);
    }

    private void notifyListenersForComponent(Component c, int id) {
        if (this.m_listeners != null) {
            Enumeration e = this.m_listeners.elements();
            while (e.hasMoreElements()) {
                PageListenerInfo info = (PageListenerInfo)e.nextElement();
                if (info.Component != c) continue;
                info.listener.pageChanged(new PageEvent(info.context, id));
            }
        }
    }

    @Override
    public void internalFrameActivated(InternalFrameEvent e) {
        Container c = ((JInternalFrame)e.getSource()).getContentPane();
        this.firePageSelected(c);
        if (c instanceof HasCommandProcessor) {
            this.m_app.getCommandManager().add(((HasCommandProcessor)((Object)c)).getCommandProcessor());
        }
    }

    @Override
    public void internalFrameDeactivated(InternalFrameEvent e) {
        Container c = ((JInternalFrame)e.getSource()).getContentPane();
        this.firePageDeselected(c);
        if (c instanceof HasCommandProcessor) {
            this.m_app.getCommandManager().remove(((HasCommandProcessor)((Object)c)).getCommandProcessor());
        }
    }

    @Override
    public void internalFrameClosed(InternalFrameEvent e) {
    }

    @Override
    public void internalFrameClosing(InternalFrameEvent e) {
        this.closeWindow((JInternalFrame)e.getSource());
    }

    @Override
    public void internalFrameDeiconified(InternalFrameEvent e) {
        this.firePageDeiconized(((JInternalFrame)e.getSource()).getContentPane());
    }

    @Override
    public void internalFrameIconified(InternalFrameEvent e) {
        this.firePageIconized(((JInternalFrame)e.getSource()).getContentPane());
        this.selectLastWindow();
    }

    @Override
    public void internalFrameOpened(InternalFrameEvent e) {
    }

    @Override
    public boolean windowListChanged() {
        return this.m_changed;
    }

    @Override
    public Vector getPageListeners() {
        return this.m_listeners;
    }
}

