/*
 * Decompiled with CFR 0.152.
 */
package jas2.loader;

import jas2.loader.ClassPath;
import jas2.loader.NestedClassException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClassPathLoader
extends ClassLoader {
    private static final boolean debug = System.getProperty("debugLoader") != null;
    private String loaderName;
    private ClassPath path;
    private Hashtable m_cache = new Hashtable();

    public ClassPathLoader(ClassPath path, String name) {
        this.path = path;
        this.loaderName = name;
    }

    public ClassPath getClassPath() {
        return this.path;
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = (Class<?>)this.m_cache.get(name);
        if (c == null) {
            try {
                ClassLoader parent = this.getClass().getClassLoader();
                c = parent != null ? parent.loadClass(name) : this.findSystemClass(name);
            }
            catch (ClassNotFoundException e1) {
                byte[] data = this.loadClassData(name);
                c = this.defineClass(name, data, 0, data.length);
            }
            catch (NoClassDefFoundError e1) {
                byte[] data = this.loadClassData(name);
                c = this.defineClass(name, data, 0, data.length);
            }
            this.m_cache.put(name, c);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        if (debug) {
            System.err.println("Could not load resource " + name);
        }
        return null;
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        InputStream result = ClassPathLoader.getSystemResourceAsStream(name);
        if (result != null) {
            return result;
        }
        Enumeration e = this.path.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            result = o instanceof ZipFile ? this.getResourceFromJar((ZipFile)o, name) : this.getResourceFromFileSystem((File)o, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private InputStream getResourceFromFileSystem(File dir, String name) {
        try {
            File f = new File(dir, name);
            if (f.exists()) {
                return new FileInputStream(f);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private InputStream getResourceFromJar(ZipFile zip, String name) {
        try {
            ZipEntry entry = zip.getEntry(name);
            if (entry != null) {
                return zip.getInputStream(entry);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public byte[] loadClassData(String theClassName) throws ClassNotFoundException {
        String sep = File.separator;
        String theClassPath = theClassName.replace('.', sep.charAt(0)) + ".class";
        String theJarStyleClassPath = theClassName.replace('.', '/') + ".class";
        Enumeration e = this.path.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            byte[] data = o instanceof ZipFile ? this.loadFromJar((ZipFile)o, theJarStyleClassPath) : this.loadFromFilesystem((File)o, theClassPath);
            if (data == null) continue;
            if (debug) {
                String from = o instanceof ZipFile ? ((ZipFile)o).getName() : ((File)o).getAbsolutePath();
                System.out.println(this.loaderName + ": loaded class " + theClassName + " from: " + from);
            }
            return data;
        }
        throw new ClassNotFoundException("Class " + theClassName + " not found");
    }

    private byte[] loadFromFilesystem(File file, String theClassPath) throws NestedClassException {
        File f = new File(file, theClassPath);
        FileInputStream input = null;
        try {
            input = new FileInputStream(f);
            int l = (int)f.length();
            byte[] byArray = this.loadFromInputStream(input, l);
            return byArray;
        }
        catch (FileNotFoundException x) {
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException x) {
            throw new NestedClassException("Error reading class file: " + f.getName(), x);
        }
        finally {
            try {
                if (input != null) {
                    ((InputStream)input).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private byte[] loadFromJar(ZipFile zipFile, String theJarStyleClassPath) throws ClassNotFoundException {
        byte[] byArray;
        InputStream input = null;
        try {
            ZipEntry entry = zipFile.getEntry(theJarStyleClassPath);
            if (entry == null) {
                byte[] byArray2 = null;
                return byArray2;
            }
            input = zipFile.getInputStream(entry);
            int len = (int)entry.getSize();
            byArray = this.loadFromInputStream(input, len);
        }
        catch (IOException x) {
            throw new NestedClassException("Error reading zip file: " + zipFile.getName(), x);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    protected byte[] loadFromInputStream(InputStream input, int len) throws IOException {
        byte[] data = new byte[len];
        int p = 0;
        int n = input.read(data, p, len);
        while (n > 0) {
            n = input.read(data, p += n, len -= n);
        }
        return data;
    }
}

