/*
 * Decompiled with CFR 0.152.
 */
package jas2.loader;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ClassPath {
    private Vector v = new Vector();

    public ClassPath() {
    }

    public ClassPath(String path) {
        StringTokenizer tk = new StringTokenizer(path, File.pathSeparator);
        while (tk.hasMoreElements()) {
            try {
                this.add(tk.nextToken());
            }
            catch (ZipException zipException) {
            }
            catch (IOException iOException) {}
        }
    }

    public void add(String s) throws ZipException, IOException {
        File f = new File(s);
        if (f.isDirectory()) {
            this.v.addElement(f);
        } else {
            ZipFile z = new ZipFile(f);
            this.v.addElement(z);
        }
    }

    public void add(File f) {
        this.v.addElement(f);
    }

    public void add(ZipFile z) {
        this.v.addElement(z);
    }

    public Enumeration elements() {
        return this.v.elements();
    }

    public void setContents(Vector newVector) {
        this.v = newVector;
    }

    public void clear() {
        Enumeration e = this.v.elements();
        this.v = new Vector();
        this.close(e);
    }

    private void close(Enumeration e) {
        e = this.v.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            try {
                if (!(o instanceof ZipFile)) continue;
                ((ZipFile)o).close();
            }
            catch (IOException iOException) {}
        }
    }

    public void finalize() {
        this.close(this.v.elements());
    }

    public String getClassPath() {
        String sep = File.pathSeparator;
        StringBuffer result = new StringBuffer();
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            result.append(o instanceof ZipFile ? ((ZipFile)o).getName() : o.toString());
            if (!e.hasMoreElements()) continue;
            result.append(sep);
        }
        return result.toString();
    }

    public String toString() {
        return this.getClassPath();
    }
}

