/*
 * Decompiled with CFR 0.152.
 */
package jas2.jds.module;

import hepjas.analysis.EventSource;
import jas2.jds.module.DIM2;
import jas2.jds.module.ModuleException;
import jas2.util.tree.TreeItem;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Vector;

public abstract class BasicServer
implements FilenameFilter,
DIM2 {
    private String directory = ".";
    private String fileExtension;
    private String title;
    private Vector dataSetList;

    public BasicServer(String[] args, String title, String fileExtension) {
        this.fileExtension = fileExtension;
        this.title = title;
        if (args.length > 0) {
            this.title = args[0];
        }
        if (args.length > 1) {
            this.directory = args[1];
        }
        if (args.length > 2) {
            this.fileExtension = args[2];
        }
        if (args.length > 3) {
            throw new RuntimeException("Too many arguments passed to server");
        }
    }

    @Override
    public boolean accept(File dir, String name) {
        if (new File(dir, name).isDirectory()) {
            TreeItem item = new TreeItem();
            item.path = new String[1];
            item.path[0] = name;
            item.flags = 1;
            this.dataSetList.addElement(item);
        } else if (this.fileExtension == null || name.endsWith("." + this.fileExtension)) {
            TreeItem item = new TreeItem();
            item.path = new String[1];
            item.path[0] = name;
            this.dataSetList.addElement(item);
        }
        return true;
    }

    @Override
    public TreeItem[] getDataSets(TreeItem base) {
        this.dataSetList = new Vector();
        File dir = new File(this.directory);
        for (int i = 0; i < base.path.length; ++i) {
            dir = new File(dir, base.path[i]);
        }
        dir.list(this);
        System.out.println("getDataSets returned " + this.dataSetList.size() + " items for base=" + base);
        Object[] result = new TreeItem[this.dataSetList.size()];
        this.dataSetList.copyInto(result);
        this.dataSetList = null;
        return result;
    }

    @Override
    public EventSource openDataSet(TreeItem base) throws ModuleException {
        File dir = new File(this.directory);
        for (int i = 0; i < base.path.length; ++i) {
            dir = new File(dir, base.path[i]);
        }
        return this.createEventSource(dir.getAbsolutePath());
    }

    @Override
    public EventSource openDataSet(String fileName) throws ModuleException {
        throw new RuntimeException("Unimplemented method exception");
    }

    protected abstract EventSource createEventSource(String var1) throws ModuleException;

    public String toString() {
        return this.title;
    }
}

