/*
 * Decompiled with CFR 0.152.
 */
package jas2.jds.module;

import jas2.jds.module.LocalDIM2;
import jas2.jds.module.LocalJobBuilder;
import jas2.util.Finishable;
import jas2.util.HasHelpPage;
import jas2.util.JASWizardPage;
import jas2.util.OpenLocalFilePanel;
import java.awt.BorderLayout;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public abstract class BasicLocalDIM
implements LocalDIM2 {
    private FileFilter fileFilter;
    transient LocalJobBuilder m_ljb;

    public BasicLocalDIM(FileFilter f) {
        this.fileFilter = f;
    }

    public BasicLocalDIM(String description, String filetype) {
        this(new BasicFileFilter(description, filetype));
    }

    @Override
    public JASWizardPage getSetupPage() {
        return new BasicWizardPage();
    }

    @Override
    public void setLocalJobBuilder(LocalJobBuilder ljb) {
        this.m_ljb = ljb;
    }

    @Override
    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    public String toString() {
        return this.fileFilter.getDescription();
    }

    public String getHelpTopic() {
        return "builtInModules.BasicLocalDIM";
    }

    private static class BasicFileFilter
    extends FileFilter {
        private String description;
        private String filetype;

        BasicFileFilter(String description, String filetype) {
            this.description = description;
            this.filetype = filetype;
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().endsWith(this.filetype);
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    class BasicWizardPage
    extends JASWizardPage
    implements Finishable,
    HasHelpPage {
        OpenLocalFilePanel m_filePanel;

        BasicWizardPage() {
            super(new BorderLayout());
            this.m_filePanel = new OpenLocalFilePanel(false, false, BasicLocalDIM.this.getClass().getName(), BasicLocalDIM.this.fileFilter);
            this.add("North", this.m_filePanel);
        }

        @Override
        public void onFinish() {
            String fileName = this.m_filePanel.getText();
            if (fileName.length() == 0) {
                JOptionPane.showMessageDialog(this, "You must enter a file name.", "Error...", 0);
                return;
            }
            BasicLocalDIM.this.m_ljb.createJob(fileName);
            this.m_filePanel.saveState();
            this.dispose();
        }

        @Override
        public String getHelpTopic() {
            return BasicLocalDIM.this.getHelpTopic();
        }
    }
}

