/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist.normalization;

import jas2.hist.DataSource;
import jas2.hist.normalization.SimpleNormalizer;
import java.util.Observable;
import java.util.Observer;

public abstract class DataSourceNormalizer
extends SimpleNormalizer
implements Observer {
    protected boolean hurry;
    protected DataSource source;
    private double norm;

    public DataSourceNormalizer(DataSource source) {
        super(1.0);
        this.source = source;
        String property = System.getProperty("hurry", "false");
        this.hurry = property != null && property.equalsIgnoreCase("true");
    }

    protected void init() {
        if (this.source instanceof Observable) {
            ((Observable)((Object)this.source)).addObserver(this);
        }
        this.norm = this.calculateNormalization();
    }

    @Override
    public void update(Observable obs, Object arg) {
        double newNorm = this.calculateNormalization();
        if (newNorm != this.norm) {
            this.norm = newNorm;
            this.normalizationChanged();
        }
    }

    @Override
    public double getNormalizationFactor() {
        return super.getNormalizationFactor() * this.norm;
    }

    protected abstract double calculateNormalization();
}

