/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.DateTransformationConverter;
import jas2.hist.JASHist2DScatterData;
import jas2.hist.JASHistScatterPlotStyle;
import jas2.hist.ScatterEnumeration;
import jas2.hist.TwoDOverlay;
import jas2.plot.CoordinateTransformation;
import jas2.plot.DateCoordinateTransformation;
import jas2.plot.DoubleCoordinateTransformation;
import jas2.plot.OverlayContainer;
import jas2.plot.PlotGraphics;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;

class ScatterOverlay
extends TwoDOverlay
implements ImageObserver {
    private Image imageCache = null;
    private Image newImage = null;
    private JASHist2DScatterData parent;
    private boolean async = false;

    ScatterOverlay(JASHist2DScatterData parent) {
        super(parent);
        this.parent = parent;
    }

    @Override
    public void containerNotify(OverlayContainer c) {
        if (c == null) {
            Image image = this.imageCache;
            if (image != null) {
                ((ScatterImage)image.getSource()).abort();
            }
            if ((image = this.newImage) != null) {
                ((ScatterImage)image.getSource()).abort();
            }
        }
        super.containerNotify(c);
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if (img == this.imageCache) {
            if ((infoflags & 0x80) != 0) {
                this.imageCache = null;
            } else if ((infoflags & 0x10) != 0) {
                this.container.repaint();
            }
        } else if (img == this.newImage && (infoflags & 0x80) != 0) {
            this.newImage = null;
        }
        return true;
    }

    @Override
    public void paint(PlotGraphics g, boolean isPrinting) {
        this.async = !isPrinting;
        JASHistScatterPlotStyle style = (JASHistScatterPlotStyle)this.parent.style;
        if (style.getDisplayAsScatterPlot()) {
            CoordinateTransformation xp = this.container.getXTransformation();
            CoordinateTransformation yp = this.container.getYTransformation();
            if (xp instanceof DateCoordinateTransformation) {
                xp = new DateTransformationConverter((DateCoordinateTransformation)xp);
            }
            if (xp instanceof DoubleCoordinateTransformation && yp instanceof DoubleCoordinateTransformation) {
                DoubleCoordinateTransformation xt = (DoubleCoordinateTransformation)xp;
                DoubleCoordinateTransformation yt = (DoubleCoordinateTransformation)yp;
                double x1 = xt.convert(xt.getPlotMin());
                double x2 = xt.convert(xt.getPlotMax());
                double y1 = yt.convert(yt.getPlotMin());
                double y2 = yt.convert(yt.getPlotMax());
                int height = (int)(y1 - y2);
                int width = (int)(x2 - x1);
                Image current = this.imageCache;
                if (current == null) {
                    this.imageCache = current = this.container.createImage(new ScatterImage(width, height, xt, yt));
                    g.drawImage(current, x1, y2, this);
                } else {
                    int oldWidth = current.getWidth(null);
                    int oldHeight = current.getHeight(null);
                    if (oldWidth == width && oldHeight == height) {
                        g.drawImage(current, x1, y2, this);
                    } else if (oldWidth > 0 && oldHeight > 0) {
                        Image next = this.newImage;
                        if (next == null) {
                            this.newImage = next = this.container.createImage(new ScatterImage(width, height, xt, yt));
                            this.container.prepareImage(next, this);
                        } else {
                            int newWidth = next.getWidth(null);
                            int newHeight = next.getHeight(null);
                            if (newWidth <= 0 || newHeight <= 0 || newWidth != width || newHeight != height) {
                                // empty if block
                            }
                        }
                        g.drawImage(current, x1, y2, width, height, this);
                    }
                }
            }
        } else {
            super.paint(g, isPrinting);
        }
    }

    @Override
    public void paintIcon(PlotGraphics g, int width, int height) {
        JASHistScatterPlotStyle style = (JASHistScatterPlotStyle)this.parent.style;
        if (style.getDisplayAsScatterPlot()) {
            g.setColor(style.getDataPointColor());
            g.fillRect(1.0, 1.0, width - 2, height - 2);
        } else {
            super.paintIcon(g, width, height);
        }
    }

    void continueImage() {
        Image image = this.imageCache;
        if (image != null) {
            ((ScatterImage)image.getSource()).continueDrawing();
        }
        if ((image = this.newImage) != null) {
            ((ScatterImage)image.getSource()).continueDrawing();
        }
    }

    void restartImage(boolean newEnumNeeded) {
        Image image = this.imageCache;
        if (image != null) {
            ((ScatterImage)image.getSource()).restart(newEnumNeeded);
        }
        if ((image = this.newImage) != null) {
            ((ScatterImage)image.getSource()).restart(newEnumNeeded);
        }
    }

    private void imageReallyComplete(ImageProducer producer) {
        Image next = this.newImage;
        if (next != null && next.getSource() == producer) {
            Image oldImage = this.imageCache;
            this.imageCache = next;
            oldImage.flush();
            this.newImage = null;
            this.container.repaint();
        }
    }

    final class ScatterImage
    implements ImageProducer,
    Runnable {
        private final DoubleCoordinateTransformation xt;
        private final DoubleCoordinateTransformation yt;
        private ImageConsumer consumer;
        private ScatterEnumeration enumer;
        private Thread thread;
        private boolean abort = false;
        private boolean pastPointOfNoContinue = false;
        private final int height;
        private final int width;

        ScatterImage(int width, int height, DoubleCoordinateTransformation xt, DoubleCoordinateTransformation yt) {
            this.width = width;
            this.height = height;
            this.xt = xt;
            this.yt = yt;
        }

        @Override
        public boolean isConsumer(ImageConsumer c) {
            return this.consumer.equals(c);
        }

        @Override
        public void addConsumer(ImageConsumer c) {
            if (this.consumer != null) {
                throw new RuntimeException("Only single consumer supported");
            }
            this.consumer = c;
        }

        @Override
        public void removeConsumer(ImageConsumer c) {
            this.consumer = null;
        }

        @Override
        public void requestTopDownLeftRightResend(ImageConsumer c) {
        }

        @Override
        public void run() {
            ImageConsumer consumer = this.consumer;
            if (consumer != null) {
                this.deliverImage(consumer);
            }
            this.thread = null;
        }

        @Override
        public void startProduction(ImageConsumer c) {
            this.consumer = c;
            if (ScatterOverlay.this.async) {
                this.thread = new Thread(this);
                this.thread.start();
            } else {
                this.run();
            }
        }

        void abort() {
            try {
                Thread t = this.thread;
                if (t != null) {
                    this.abort = true;
                    t.join();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.abort = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void continueDrawing() {
            Thread t = this.thread;
            if (t != null) {
                ScatterImage scatterImage = this;
                synchronized (scatterImage) {
                    if (!this.pastPointOfNoContinue) {
                        return;
                    }
                }
                try {
                    t.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (ScatterOverlay.this.async) {
                this.thread = new Thread(this);
                this.thread.start();
            } else {
                this.run();
            }
        }

        void restart(boolean newEnumNeeded) {
            this.abort();
            if (newEnumNeeded) {
                this.enumer = null;
            } else if (this.enumer != null) {
                this.enumer.restart();
            }
            if (ScatterOverlay.this.async) {
                this.thread = new Thread(this);
                this.thread.start();
            } else {
                this.run();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void deliverImage(ImageConsumer consumer) {
            JASHistScatterPlotStyle style = (JASHistScatterPlotStyle)((ScatterOverlay)ScatterOverlay.this).parent.style;
            Color c = style.getDataPointColor();
            byte[] r = new byte[]{0, (byte)c.getRed()};
            byte[] g = new byte[]{0, (byte)c.getGreen()};
            byte[] b = new byte[]{0, (byte)c.getBlue()};
            byte[] a = new byte[]{0, -2};
            IndexColorModel model = new IndexColorModel(1, 2, r, g, b, a);
            byte[] pixels = new byte[this.width * this.height];
            consumer.setDimensions(this.width, this.height);
            consumer.setColorModel(model);
            double[] d = new double[2];
            int point = style.getDataPointStyle();
            int size = style.getDataPointSize();
            int size2 = size / 2;
            double x1 = this.xt.convert(this.xt.getPlotMin());
            double y2 = this.yt.convert(this.yt.getPlotMax());
            if (this.enumer == null) {
                double data_xMin = ((ScatterOverlay)ScatterOverlay.this).parent.dataSource.getXMin();
                double data_xMax = ((ScatterOverlay)ScatterOverlay.this).parent.dataSource.getXMax();
                double data_yMin = ((ScatterOverlay)ScatterOverlay.this).parent.dataSource.getYMin();
                double data_yMax = ((ScatterOverlay)ScatterOverlay.this).parent.dataSource.getYMax();
                double plot_xMin = this.xt.getPlotMin();
                double plot_xMax = this.xt.getPlotMax();
                double plot_yMin = this.yt.getPlotMin();
                double plot_yMax = this.yt.getPlotMax();
                if (data_xMin < plot_xMin || data_xMax > plot_xMax || data_yMin < plot_yMin || data_yMax > plot_yMax) {
                    double xMin = Math.max(data_xMin, plot_xMin);
                    double xMax = Math.min(data_xMax, plot_xMax);
                    double yMin = Math.max(data_yMin, plot_yMin);
                    double yMax = Math.min(data_yMax, plot_yMax);
                    double xExtra = (double)size2 * (plot_xMax - plot_xMin) / (this.xt.convert(plot_xMax) - x1);
                    double yExtra = (double)size2 * (plot_yMax - plot_yMin) / (this.yt.convert(plot_yMin) - y2);
                    this.enumer = data_xMin + xExtra < plot_xMin || data_xMax - xExtra > plot_xMax || data_yMin + yExtra < plot_yMin || data_yMax - yExtra > plot_yMax ? ((ScatterOverlay)ScatterOverlay.this).parent.dataSource.startEnumeration(xMin - xExtra, xMax + xExtra, yMin - yExtra, yMax + yExtra) : ((ScatterOverlay)ScatterOverlay.this).parent.dataSource.startEnumeration();
                } else {
                    this.enumer = ((ScatterOverlay)ScatterOverlay.this).parent.dataSource.startEnumeration();
                }
            }
            long nextUpdate = System.currentTimeMillis() + 200L;
            int n = 0;
            while (!this.abort) {
                block80: {
                    block81: {
                        int row;
                        int col;
                        block79: {
                            boolean ok = this.enumer.getNextPoint(d);
                            if (!ok) {
                                ScatterImage data_yMin = this;
                                synchronized (data_yMin) {
                                    ok = this.enumer.getNextPoint(d);
                                    if (!ok) {
                                        this.pastPointOfNoContinue = true;
                                        break;
                                    }
                                }
                            }
                            col = Math.round((float)(this.xt.convert(d[0]) - x1));
                            row = Math.round((float)(this.yt.convert(d[1]) - y2));
                            if (size >= 2) break block79;
                            if (col < 0 || col >= this.width) break block80;
                            try {
                                pixels[row * this.width + col] = 1;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                            break block81;
                        }
                        switch (point) {
                            case 0: {
                                int col_start;
                                int row_start;
                                int col_end = Math.min(this.width, col + size2);
                                int row_end = Math.min(this.height, row + size2);
                                int i = row_start * this.width;
                                for (row_start = Math.max(0, row - size2); row_start < row_end; ++row_start) {
                                    for (col_start = Math.max(0, col - size2); col_start < col_end; ++col_start) {
                                        try {
                                            pixels[i + col_start] = 1;
                                            continue;
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                    i += this.width;
                                }
                                break;
                            }
                            case 1: {
                                int col_start;
                                int row_start = row - size * 64 / 100;
                                int i = Math.max(0, row_start) * this.width;
                                int j = Math.max(0, -row_start);
                                while (j < size) {
                                    int extra = j / 2;
                                    int col_end = Math.min(this.width - 1, col + extra);
                                    for (col_start = Math.max(0, col - extra); col_start <= col_end; ++col_start) {
                                        try {
                                            pixels[i + col_start] = 1;
                                            continue;
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                    ++j;
                                    i += this.width;
                                }
                                break;
                            }
                            case 2: {
                                int col_start;
                                int row_start = Math.max(0, row - size2);
                                int row_end = Math.min(this.height, row + size2);
                                int i = row_start * this.width;
                                int j = Math.max(size2 - row, 0);
                                while (j < size2) {
                                    int col_end = Math.min(this.width - 1, col + j);
                                    for (col_start = Math.max(0, col - j); col_start <= col_end; ++col_start) {
                                        try {
                                            pixels[i + col_start] = 1;
                                            continue;
                                        }
                                        catch (ArrayIndexOutOfBoundsException extra) {
                                            // empty catch block
                                        }
                                    }
                                    ++j;
                                    i += this.width;
                                }
                                j = size2;
                                while (j >= 0) {
                                    int col_end = Math.min(this.width - 1, col + j);
                                    for (col_start = Math.max(0, col - j); col_start <= col_end; ++col_start) {
                                        try {
                                            pixels[i + col_start] = 1;
                                            continue;
                                        }
                                        catch (ArrayIndexOutOfBoundsException extra) {
                                            // empty catch block
                                        }
                                    }
                                    --j;
                                    i += this.width;
                                }
                                break;
                            }
                            case 3: {
                                int col_start;
                                int i = row * this.width;
                                int col_end = Math.min(this.width - 1, col + size2);
                                for (col_start = Math.max(0, col - size2); col_start <= col_end; ++col_start) {
                                    try {
                                        pixels[i + col_start] = 1;
                                        continue;
                                    }
                                    catch (ArrayIndexOutOfBoundsException j) {
                                        // empty catch block
                                    }
                                }
                                i -= size2 * this.width;
                                int j = -size2;
                                while (j <= size2) {
                                    if (col >= 0 && col < this.width) {
                                        try {
                                            pixels[i + col] = 1;
                                        }
                                        catch (ArrayIndexOutOfBoundsException extra) {
                                            // empty catch block
                                        }
                                    }
                                    if (col + j >= 0 && col + j < this.width) {
                                        try {
                                            pixels[i + col + j] = 1;
                                        }
                                        catch (ArrayIndexOutOfBoundsException extra) {
                                            // empty catch block
                                        }
                                    }
                                    if (col - j >= 0 && col - j < this.width) {
                                        try {
                                            pixels[i + col - j] = 1;
                                        }
                                        catch (ArrayIndexOutOfBoundsException extra) {
                                            // empty catch block
                                        }
                                    }
                                    ++j;
                                    i += this.width;
                                }
                                break;
                            }
                            case 4: {
                                if (col < 0 || col >= this.width) break;
                                int row_start = Math.max(0, row - size2);
                                int row_end = Math.min(this.height, row + size2);
                                int i = row_start * this.width + col;
                                while (row_start < row_end) {
                                    try {
                                        pixels[i] = 1;
                                    }
                                    catch (ArrayIndexOutOfBoundsException j) {
                                        // empty catch block
                                    }
                                    ++row_start;
                                    i += this.width;
                                }
                                break;
                            }
                            case 5: {
                                int col_start;
                                if (row < 0 || row >= this.height) break;
                                int i = row * this.width;
                                int col_end = Math.min(this.width, col + size2);
                                for (col_start = Math.max(0, col - size2); col_start < col_end; ++col_start) {
                                    try {
                                        pixels[i + col_start] = 1;
                                        continue;
                                    }
                                    catch (ArrayIndexOutOfBoundsException j) {
                                        // empty catch block
                                    }
                                }
                                break;
                            }
                            case 6: {
                                int col_start;
                                int i = row * this.width;
                                int col_end = Math.min(this.width - 1, col + size2);
                                for (col_start = Math.max(0, col - size2); col_start <= col_end; ++col_start) {
                                    try {
                                        pixels[i + col_start] = 1;
                                        continue;
                                    }
                                    catch (ArrayIndexOutOfBoundsException j) {
                                        // empty catch block
                                    }
                                }
                                int row_start = Math.max(0, row - size2);
                                int row_end = Math.min(this.height - 1, row + size2);
                                i -= (row - row_start) * this.width - col;
                                while (row_start <= row_end) {
                                    try {
                                        pixels[i] = 1;
                                    }
                                    catch (ArrayIndexOutOfBoundsException j) {
                                        // empty catch block
                                    }
                                    ++row_start;
                                    i += this.width;
                                }
                                break;
                            }
                            case 7: {
                                int col_start;
                                int row_start = Math.max(0, row - size2);
                                int row_end = Math.min(this.height, row + size2);
                                int col_end = Math.min(this.width, col + size2);
                                int i = row_start * this.width;
                                if (row_start > 0) {
                                    for (col_start = Math.max(0, col - size2); col_start < col_end; ++col_start) {
                                        try {
                                            pixels[i + col_start] = 1;
                                            continue;
                                        }
                                        catch (ArrayIndexOutOfBoundsException j) {
                                            // empty catch block
                                        }
                                    }
                                }
                                boolean l_Line = col - size2 >= 0;
                                boolean r_Line = col + size2 < this.width;
                                i += col;
                                while (row_start < row_end) {
                                    if (l_Line) {
                                        try {
                                            pixels[i - size2] = 1;
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                    if (r_Line) {
                                        try {
                                            pixels[i + size2] = 1;
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                    }
                                    ++row_start;
                                    i += this.width;
                                }
                                i -= col;
                                for (col_start = Math.max(0, col - size2); col_start <= col_end; ++col_start) {
                                    try {
                                        pixels[i + col_start] = 1;
                                        continue;
                                    }
                                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                        // empty catch block
                                    }
                                }
                                break;
                            }
                        }
                    }
                    long now = System.currentTimeMillis();
                    if (now > nextUpdate) {
                        consumer.setPixels(0, 0, this.width, this.height, (ColorModel)model, pixels, 0, this.width);
                        consumer.imageComplete(2);
                        nextUpdate = now + 200L;
                    }
                }
                ++n;
            }
            if (this.abort) {
                consumer.imageComplete(4);
            } else {
                consumer.setPixels(0, 0, this.width, this.height, (ColorModel)model, pixels, 0, this.width);
                consumer.imageComplete(2);
                ScatterOverlay.this.imageReallyComplete(this);
            }
        }
    }
}

