/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.Basic1DFunction;
import jas2.hist.BinnedDataManager;
import jas2.hist.DataManager;
import jas2.hist.DataManagerException;
import jas2.hist.DataSource;
import jas2.hist.DateDataManager;
import jas2.hist.DateScatterDataManager;
import jas2.hist.DefaultDataManager;
import jas2.hist.DoubleDataManager;
import jas2.hist.DoubleScatterDataManager;
import jas2.hist.FitListener;
import jas2.hist.Fitter;
import jas2.hist.FunctionData;
import jas2.hist.IntegerDataManager;
import jas2.hist.JASHist1DFunctionData;
import jas2.hist.JASHistAxis;
import jas2.hist.JASHistData;
import jas2.hist.JASHistPropertyDialog;
import jas2.hist.ManagedAxis;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.hist.Rebinnable2DHistogramData;
import jas2.hist.SaveAsDialog;
import jas2.hist.ScatterPlotSource;
import jas2.hist.StatisticsBlock;
import jas2.hist.StringDataManager;
import jas2.hist.SupportsFunctions;
import jas2.hist.TwoDDataManager;
import jas2.hist.VectorGraphicsTransferable;
import jas2.hist.XMLPrintWriter;
import jas2.hist.XYDataSource;
import jas2.plot.Axis;
import jas2.plot.DataArea;
import jas2.plot.HasPopupItems;
import jas2.plot.JASPlotMouseListener;
import jas2.plot.Legend;
import jas2.plot.PlotPanel;
import jas2.plot.PrintHelper;
import jas2.plot.Title;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class JASHist
extends JComponent
implements JASPlotMouseListener {
    public static final int NONE = 0;
    public static final int BEVEL_IN = 1;
    public static final int BEVEL_OUT = 2;
    public static final int ETCHED = 3;
    public static final int LINE = 4;
    public static final int SHADOW = 5;
    public static final int LEGEND_NEVER = 0;
    public static final int LEGEND_AUTOMATIC = 1;
    public static final int LEGEND_ALWAYS = 2;
    private static Vector fitListeners;
    private Title title;
    private StatisticsBlock stats;
    private boolean isInit = false;
    private boolean changed = false;
    private int showLegend = 1;
    private DataArea dataArea;
    private DataManager dataManager;
    private Legend legend;
    private PlotPanel contentPane = new JASHistPlotPanel();
    static final long serialVersionUID = 4433180397297758071L;

    public JASHist() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPane, "Center");
        this.setPreferredSize(new Dimension(200, 200));
        ManagedAxis xAxis = new ManagedAxis(2);
        ManagedAxis yAxis = new ManagedAxis(1);
        this.legend = new Legend();
        this.contentPane.add(this.legend);
        this.legend.setVisible(false);
        this.stats = new StatisticsBlock();
        this.contentPane.add(this.stats);
        this.stats.setVisible(false);
        this.dataArea = new JASHistDataArea(xAxis, yAxis);
        this.dataManager = new DefaultDataManager(this, this.dataArea);
        this.contentPane.add(this.dataArea);
        this.changed = false;
        this.isInit = false;
    }

    DataManager getDataManager() {
        return this.dataManager;
    }

    public DataArea getDataArea() {
        return this.dataArea;
    }

    public boolean supportsProperties() {
        return !(this.dataManager instanceof DefaultDataManager);
    }

    public void showProperties() {
        this.showProperties((byte)0);
    }

    public void showProperties(byte axis) {
        new JASHistPropertyDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this), this, axis).show();
    }

    @Override
    public void addNotify() {
        this.isInit = true;
        if (this.dataManager != null) {
            int nFunc;
            if (this.dataManager.numberOfDataSources() != 0) {
                Enumeration e = this.dataManager.getDataSources();
                while (e.hasMoreElements()) {
                    JASHistData d = (JASHistData)e.nextElement();
                    d.restoreNormalizationObserver();
                    d.show(true);
                }
            }
            if (this.dataManager instanceof BinnedDataManager && (nFunc = ((BinnedDataManager)this.dataManager).numberOfFunctions()) > 0) {
                Enumeration e = ((BinnedDataManager)this.dataManager).getFunctions();
                while (e.hasMoreElements()) {
                    JASHistData d = (JASHistData)e.nextElement();
                    d.show(true);
                }
            }
            this.dataManager.init();
        }
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        this.isInit = false;
        if (this.dataManager != null) {
            int nFunc;
            this.dataManager.setRealized(false);
            if (this.dataManager.numberOfDataSources() != 0) {
                Enumeration e = this.dataManager.getDataSources();
                while (e.hasMoreElements()) {
                    JASHistData d = (JASHistData)e.nextElement();
                    d.deleteNormalizationObserver();
                    d.show(false);
                }
            }
            if (this.dataManager instanceof BinnedDataManager && (nFunc = ((BinnedDataManager)this.dataManager).numberOfFunctions()) > 0) {
                Enumeration e = ((BinnedDataManager)this.dataManager).getFunctions();
                while (e.hasMoreElements()) {
                    JASHistData d = (JASHistData)e.nextElement();
                    d.show(false);
                }
            }
        }
        super.removeNotify();
    }

    public void writeXML(Writer w, boolean snapshot) {
        XMLPrintWriter pw = new XMLPrintWriter(w);
        pw.print(this, snapshot);
    }

    public boolean getAllowUserInteraction() {
        return this.contentPane.getAllowUserInteraction();
    }

    public void setAllowUserInteraction(boolean allow) {
        this.contentPane.setAllowUserInteraction(allow);
        this.setChanged();
    }

    public boolean getAllowPopupMenus() {
        return this.contentPane.getAllowPopupMenus();
    }

    public void setAllowPopupMenus(boolean allow) {
        this.contentPane.setAllowPopupMenus(allow);
        this.setChanged();
    }

    public void setShowStatistics(boolean show) {
        this.stats.setVisible(show);
        this.contentPane.revalidate();
        this.setChanged();
    }

    public boolean getShowStatistics() {
        return this.stats.isVisible();
    }

    @Override
    public void setBackground(Color c) {
        this.contentPane.setBackground(c);
        this.setChanged();
    }

    @Override
    public Color getBackground() {
        if (this.contentPane.isPaintingBackground()) {
            return this.contentPane.getBackground();
        }
        return super.getBackground();
    }

    public void setForegroundColor(Color c) {
        super.setForeground(c);
        this.setChanged();
    }

    public Color getDataAreaColor() {
        return this.dataArea.getBackground();
    }

    public void setDataAreaColor(Color c) {
        this.dataArea.setBackground(c);
        this.setChanged();
    }

    public void setDataAreaBorderType(int type) {
        this.dataArea.setBorderType(type);
        this.dataArea.revalidate();
        this.setChanged();
    }

    public int getDataAreaBorderType() {
        return this.dataArea.getBorderType();
    }

    public void setDataAreaBorder(Border b) {
        this.dataArea.setBorder(b);
    }

    public Border getDataAreaBorder() {
        return this.dataArea.getBorder();
    }

    public JASHistAxis getXAxis() {
        return this.dataManager.getXAxis();
    }

    public JASHistAxis getYAxis() {
        return this.dataManager.getYAxis(0);
    }

    public JASHistAxis getYAxis(int index) {
        return this.dataManager.getYAxis(index);
    }

    public JASHistAxis[] getYAxes() {
        return this.dataManager.getYAxes();
    }

    public void setShowLegend(int legend) {
        this.showLegend = legend;
        this.dataManager.showLegend();
    }

    public int getShowLegend() {
        return this.showLegend;
    }

    public JASHistData addData(DataSource ds) throws DataManagerException {
        if (ds instanceof Rebinnable1DHistogramData) {
            return this.add1DData((Rebinnable1DHistogramData)ds);
        }
        if (ds instanceof XYDataSource) {
            return this.addXYData((XYDataSource)ds);
        }
        if (ds instanceof Rebinnable2DHistogramData) {
            return this.add2DData((Rebinnable2DHistogramData)ds);
        }
        if (ds instanceof ScatterPlotSource) {
            return this.addScatterData((ScatterPlotSource)ds);
        }
        if (ds instanceof FunctionData) {
            return this.addFunctionData((FunctionData)ds);
        }
        throw new DataManagerException("Unknown DataSource subclass: " + ds);
    }

    private JASHistData add1DData(Rebinnable1DHistogramData ds) throws DataManagerException {
        if (this.dataManager instanceof DefaultDataManager) {
            int type = ds.getAxisType();
            if (type == 1) {
                this.dataManager = new DoubleDataManager(this, this.dataArea, this.legend, this.stats, 50);
            } else if (type == 4) {
                this.dataManager = new IntegerDataManager(this, this.dataArea, this.legend, this.stats, 50);
            } else if (type == 2) {
                this.dataManager = new StringDataManager(this, this.dataArea, this.legend, this.stats);
            } else if (type == 3) {
                this.dataManager = new DateDataManager(this, this.dataArea, this.legend, this.stats, 50);
            } else {
                throw new DataManagerException("Unsupported axis type");
            }
            if (this.isInit) {
                this.dataManager.init();
            }
        }
        JASHistData data = this.dataManager.add(ds);
        this.setChanged();
        return data;
    }

    private JASHistData addXYData(XYDataSource ds) throws DataManagerException {
        if (this.dataManager instanceof DefaultDataManager) {
            int type = ds.getAxisType();
            if (type == 1) {
                this.dataManager = new DoubleDataManager(this, this.dataArea, this.legend, this.stats, 50);
            } else if (type == 4) {
                this.dataManager = new IntegerDataManager(this, this.dataArea, this.legend, this.stats, 50);
            } else if (type == 3) {
                this.dataManager = new DateDataManager(this, this.dataArea, this.legend, this.stats, 50);
            } else {
                throw new DataManagerException("Unsupported axis type");
            }
            if (this.isInit) {
                this.dataManager.init();
            }
        }
        JASHistData data = this.dataManager.add(ds);
        this.setChanged();
        return data;
    }

    private JASHistData addScatterData(ScatterPlotSource ds) throws DataManagerException {
        if (this.dataManager instanceof DefaultDataManager) {
            int typeX = ds.getXAxisType();
            int typeY = ds.getYAxisType();
            if (typeY != 1) {
                throw new DataManagerException("Scatterplot Y Axis must be of type DOUBLE");
            }
            if (typeX == 1) {
                this.dataManager = new DoubleScatterDataManager(this, this.dataArea, this.legend, this.stats);
            } else if (typeX == 3) {
                this.dataManager = new DateScatterDataManager(this, this.dataArea, this.legend, this.stats);
            }
            if (this.isInit) {
                this.dataManager.init();
            }
        }
        JASHistData data = this.dataManager.add(ds);
        this.setChanged();
        return data;
    }

    private JASHistData add2DData(Rebinnable2DHistogramData ds) throws DataManagerException {
        if (this.dataManager instanceof DefaultDataManager) {
            int typeX = ds.getXAxisType();
            int typeY = ds.getYAxisType();
            if (typeX == 1) {
                this.dataManager = new DoubleScatterDataManager(this, this.dataArea, this.legend, this.stats);
            } else if (typeX == 3) {
                this.dataManager = new DateScatterDataManager(this, this.dataArea, this.legend, this.stats);
            } else {
                throw new DataManagerException("Unsupported X Axis type for ScatterPlot");
            }
            if (this.isInit) {
                this.dataManager.init();
            }
        }
        JASHistData data = this.dataManager.add(ds);
        this.setChanged();
        return data;
    }

    private JASHistData addFunctionData(FunctionData ds) throws DataManagerException {
        if (this.dataManager instanceof SupportsFunctions) {
            JASHist1DFunctionData data = ((SupportsFunctions)((Object)this.dataManager)).addFunction((Basic1DFunction)ds);
            this.setChanged();
            return data;
        }
        throw new UnsupportedOperationException("Cannot add function.");
    }

    int numberOfDataSets() {
        return this.dataManager.numberOfDataSources();
    }

    int numberOfFunctions() {
        if (this.dataManager instanceof SupportsFunctions) {
            return ((SupportsFunctions)((Object)this.dataManager)).numberOfFunctions();
        }
        return 0;
    }

    public Enumeration getDataSources() {
        return this.dataManager.getDataSources();
    }

    public int getNumberOfDataSources() {
        return this.dataManager.numberOfDataSources();
    }

    public Enumeration get1DFunctions() {
        if (this.dataManager instanceof SupportsFunctions) {
            return ((SupportsFunctions)((Object)this.dataManager)).getFunctions();
        }
        return null;
    }

    public void destroy() {
        this.dataManager.destroy();
        this.contentPane.removeAll();
    }

    public void removeAllData() {
        this.dataManager.destroy();
        this.dataManager = new DefaultDataManager(this, this.dataArea);
        this.setChanged();
    }

    private void resetAxis(JASHistAxis a) {
        a.setRangeAutomatic(true);
        a.setAllowSuppressedZero(true);
        a.setLogarithmic(false);
        this.setChanged();
    }

    public void fillFunctionMenu(JMenu menu) {
        if (this.dataManager instanceof SupportsFunctions) {
            ((SupportsFunctions)((Object)this.dataManager)).fillFunctionMenu(menu);
            menu.setEnabled(true);
        } else {
            menu.setEnabled(false);
        }
    }

    public void fillSliceMenu(JMenu menu) {
        if (this.dataManager instanceof TwoDDataManager) {
            ((TwoDDataManager)this.dataManager).fillSliceMenu(menu);
            menu.setEnabled(true);
        } else {
            menu.setEnabled(false);
        }
    }

    public String getTitle() {
        if (this.title == null) {
            return null;
        }
        return this.title.getText();
    }

    public Title getTitleObject() {
        return this.title;
    }

    public void setTitleObject(Title newTitle) {
        if (this.title != null) {
            this.contentPane.remove(this.title);
        }
        this.title = newTitle;
        this.contentPane.add(this.title);
        this.contentPane.invalidate();
        this.setChanged();
    }

    public void setTitle(String newValue) {
        if (newValue != null && newValue.length() != 0) {
            if (this.title == null) {
                this.title = new Title(newValue);
                this.contentPane.add(this.title);
                this.contentPane.invalidate();
                this.validate();
            } else {
                this.title.setText(newValue);
            }
            this.setChanged();
        } else if (this.title != null) {
            this.contentPane.remove(this.title);
            this.contentPane.invalidate();
            this.validate();
            this.title = null;
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    private void setChanged() {
        this.changed = true;
        this.validate();
        this.repaint();
    }

    public static void addFitListener(FitListener fitListener) {
        if (fitListeners == null) {
            fitListeners = new Vector(1, 1);
        }
        fitListeners.addElement(fitListener);
    }

    static void notifyFitListeners(Fitter fitter) {
        if (fitListeners != null) {
            Enumeration e = fitListeners.elements();
            while (e.hasMoreElements()) {
                ((FitListener)e.nextElement()).fitStarted(fitter);
            }
        }
    }

    @Override
    public void mouseEventNotify(MouseEvent e) {
        this.processMouseEvent(e);
    }

    public void deselected() {
        this.contentPane.deselected();
    }

    public StatisticsBlock getStats() {
        return this.stats;
    }

    public void setStats(StatisticsBlock newStats) {
        this.stats = newStats;
    }

    public Legend getLegend() {
        return this.legend;
    }

    public void setLegend(Legend newLegend) {
        this.legend = newLegend;
    }

    public void saveAs() {
        SaveAsDialog dlg = new SaveAsDialog(this);
    }

    public void copy() {
        VectorGraphicsTransferable t = new VectorGraphicsTransferable(this);
        this.getToolkit().getSystemClipboard().setContents(t, t);
    }

    private class JASHistDataArea
    extends DataArea {
        JASHistDataArea(Axis xAxis, Axis yAxis) {
            super(xAxis, yAxis);
        }

        @Override
        public void modifyPopupMenu(JPopupMenu menu, Component source) {
            if (source == this || !(source instanceof HasPopupItems)) {
                menu.add(new SetTitleMenuItem());
                JCheckBoxMenuItem ss = new JCheckBoxMenuItem("Show Statistics"){

                    @Override
                    public void fireActionPerformed(ActionEvent e) {
                        JASHist.this.setShowStatistics(!JASHist.this.getShowStatistics());
                    }
                };
                ss.setSelected(JASHist.this.getShowStatistics());
                menu.add(ss);
                JASHist.this.dataManager.modifyPopupMenu(menu, source);
                super.modifyPopupMenu(menu, source);
            }
        }
    }

    private final class SetTitleMenuItem
    extends JCheckBoxMenuItem {
        SetTitleMenuItem() {
            super("Show Title");
            this.setSelected(JASHist.this.title != null && JASHist.this.title.isVisible());
        }

        @Override
        protected void fireActionPerformed(ActionEvent e) {
            if (JASHist.this.title == null || JASHist.this.title.getText().length() == 0) {
                JASHist.this.setTitle("Title");
                JASHist.this.title.edit();
            } else {
                JASHist.this.title.setVisible(!JASHist.this.title.isVisible());
            }
        }
    }

    private final class JASHistPlotPanel
    extends PlotPanel
    implements HasPopupItems {
        private JASHistPlotPanel() {
        }

        void showWarning(Component parent, String text) {
            JOptionPane.showMessageDialog(parent, text, "Warning: Deprecated", 2);
        }

        @Override
        public void print(Graphics g) {
            PrintHelper ph = PrintHelper.instance();
            Thread t = ph.printingThread();
            if (!ph.isPrinting()) {
                ph.setPrintingThread(Thread.currentThread());
            }
            super.print(g);
            ph.setPrintingThread(t);
        }

        @Override
        public void modifyPopupMenu(JPopupMenu menu, Component source) {
            if (menu.getComponentCount() > 0) {
                menu.addSeparator();
            }
            JCheckBoxMenuItem dl = new JCheckBoxMenuItem("Default Plot Layout"){

                @Override
                protected final void fireActionPerformed(ActionEvent e) {
                    JASHist.this.contentPane.restoreDefaultLayout();
                }
            };
            boolean def = JASHist.this.contentPane.hasDefaultLayout();
            dl.setSelected(def);
            dl.setEnabled(!def);
            menu.add(dl);
            menu.add(new JMenuItem("Plot Properties..."){

                @Override
                protected final void fireActionPerformed(ActionEvent e) {
                    JASHist.this.showProperties();
                }
            });
            menu.add(new JMenuItem("Copy Plot to Clipboard..."){

                @Override
                protected final void fireActionPerformed(ActionEvent e) {
                    JASHist.this.copy();
                }
            });
            menu.add(new JMenuItem("Save Plot As..."){

                @Override
                protected final void fireActionPerformed(ActionEvent e) {
                    JASHist.this.saveAs();
                }
            });
            menu.add(new JMenuItem("Print Plot..."){

                @Override
                protected final void fireActionPerformed(ActionEvent e) {
                    try {
                        PrintHelper ph = PrintHelper.instance();
                        ph.printTarget(JASHistPlotPanel.this);
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                }
            });
        }
    }
}

