/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.BinnedDataManager;
import jas2.hist.DataManagerException;
import jas2.hist.DataSource;
import jas2.hist.JASHist;
import jas2.hist.JASHistData;
import jas2.hist.Rebinnable1DHistogramData;
import jas2.hist.StatisticsBlock;
import jas2.hist.XYDataSource;
import jas2.plot.DataArea;
import jas2.plot.DoubleAxis;
import jas2.plot.Legend;
import java.io.IOException;
import java.io.ObjectInputStream;

class DoubleDataManager
extends BinnedDataManager {
    private DoubleAxis xAxis = new DoubleAxis();

    DoubleDataManager(JASHist plot, DataArea da, Legend l, StatisticsBlock stats, int bins) {
        super(plot, da, l, stats, bins);
        DoubleAxis yAxis = new DoubleAxis();
        yAxis.setUseSuggestedRange(true);
        this.xm.setDataManager(this, true, this.xAxis);
        this.ym[0].setDataManager(this, false, yAxis);
        new BinnedDataManager.DoubleAxisListener(this.xm);
        this.xm.setBins(bins);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        new BinnedDataManager.DoubleAxisListener(this.xm);
    }

    @Override
    final JASHistData add(DataSource data) {
        if (data instanceof Rebinnable1DHistogramData) {
            Rebinnable1DHistogramData d = (Rebinnable1DHistogramData)data;
            if (d.getAxisType() != 1) {
                throw new DataManagerException("Incompatible data type for axis");
            }
        } else {
            XYDataSource d = (XYDataSource)data;
            if (d.getAxisType() != 1) {
                throw new DataManagerException("Incompatible data type for axis");
            }
        }
        return super.add(data);
    }

    @Override
    protected final void calcMinMaxBins(double x1, double x2) {
        double oldXMin = this.xAxis.getPlotMin();
        double oldXMax = this.xAxis.getPlotMax();
        if (x1 != oldXMin || x2 != oldXMax) {
            this.xAxis.setMin(x1);
            this.xAxis.setMax(x2);
            this.xm.invalidate();
        }
    }
}

