/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.BinnedDataAxisAttributesNodeTraverser;
import jas2.hist.Bins2DNodeTraverser;
import jas2.hist.ClassNodeTraverser;
import jas2.hist.ConstructorNodeTraverser;
import jas2.hist.DataSource;
import jas2.hist.DataSourceNodeTraverser;
import jas2.hist.JASHist2DHistogramStyle;
import jas2.hist.JASHistScatterPlotStyle;
import jas2.hist.JASHistStyle;
import jas2.hist.PointDataAxisAttributesNodeTraverser;
import jas2.hist.Points2DNodeTraverser;
import jas2.hist.ScatterStyleNodeTraverser;
import jas2.hist.StatisticsTraverser;
import jas2.hist.Style2DNodeTraverser;
import jas2.hist.XML2DHistDataSource;
import jas2.hist.XML2DScatterDataSource;
import jas2.util.xml.XMLNodeTraverser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class Data2DTraverser
extends XMLNodeTraverser {
    private String type;
    private int paxis = 0;
    private int baxis = 0;
    private JASHist2DHistogramStyle style;
    private ConstructorNodeTraverser ct = null;
    private StatisticsTraverser stats = null;
    private Style2DNodeTraverser st = new Style2DNodeTraverser();
    private ScatterStyleNodeTraverser scst = new ScatterStyleNodeTraverser();
    private Bins2DNodeTraverser b2d;
    private BinnedDataAxisAttributesNodeTraverser[] baa = new BinnedDataAxisAttributesNodeTraverser[2];
    private PointDataAxisAttributesNodeTraverser[] paa = new PointDataAxisAttributesNodeTraverser[2];
    private Points2DNodeTraverser p2d;
    private String refName;

    Data2DTraverser(Node node) throws XMLNodeTraverser.BadXMLException {
        this.traverse(node);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void handleElement(Element node, String name) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("bins2d")) {
            this.b2d = new Bins2DNodeTraverser(node);
            return;
        } else if (name.equals("points")) {
            this.p2d = new Points2DNodeTraverser(node);
            return;
        } else if (name.equals("pointDataAxisAttributes")) {
            this.paa[this.paxis++] = new PointDataAxisAttributesNodeTraverser(node);
            return;
        } else if (name.equals("binnedDataAxisAttributes")) {
            this.baa[this.baxis++] = new BinnedDataAxisAttributesNodeTraverser(node);
            return;
        } else if (name.equals("class")) {
            this.ct = new ClassNodeTraverser(node);
            return;
        } else if (name.equals("datasource")) {
            this.ct = new DataSourceNodeTraverser(node);
            return;
        } else if (name.equals("statistics")) {
            this.stats = new StatisticsTraverser(node);
            return;
        } else if (name.equals("style2d")) {
            if (this.type.equals("scatter2d")) {
                JASHistScatterPlotStyle scatstyle = new JASHistScatterPlotStyle();
                this.style = scatstyle;
                this.scst.traverse((Node)node, scatstyle);
                return;
            } else {
                if (!this.type.equals("histogram2d")) throw new XMLNodeTraverser.BadXMLException("type attribute for data2d element must be scatter2d of histogram2d.");
                this.style = new JASHist2DHistogramStyle();
                this.st.traverse(node, this.style);
            }
            return;
        } else {
            super.handleElement(node, name);
        }
    }

    @Override
    protected void handleAttributeNode(Attr node, String name, String value) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("type")) {
            this.type = value;
        } else if (name.equals("name")) {
            this.refName = value;
        } else {
            super.handleAttributeNode(node, name, value);
        }
    }

    DataSource getDataSource() throws XMLNodeTraverser.BadXMLException {
        if (this.ct != null) {
            return this.ct.getDataSource();
        }
        if (this.b2d != null) {
            return new XML2DHistDataSource(this.b2d, this.baa[0], this.baa[1], this.stats);
        }
        return new XML2DScatterDataSource(this.paa[0].getType(), this.paa[1].getType(), this.p2d.getTitle(), this.p2d.getData());
    }

    JASHistStyle getStyle() {
        return this.style;
    }

    String getRefName() {
        return this.refName;
    }
}

