/*
 * Decompiled with CFR 0.152.
 */
package jas2.hist;

import jas2.hist.FontNodeTraverser;
import jas2.hist.JASHistAxis;
import jas2.hist.LabelNodeTraverser;
import jas2.hist.XMLPrintWriter;
import jas2.plot.Axis;
import jas2.plot.EditableLabel;
import jas2.util.xml.XMLNodeTraverser;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class AxisNodeTraverser
extends XMLNodeTraverser {
    private static LabelNodeTraverser lt = new LabelNodeTraverser();
    private static FontNodeTraverser ft = new FontNodeTraverser();
    private JASHistAxis axis;

    AxisNodeTraverser() {
    }

    void traverse(Node node, JASHistAxis axis) throws XMLNodeTraverser.BadXMLException {
        this.axis = axis;
        super.traverse(node);
    }

    @Override
    protected void handleElement(Element node, String name) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("label")) {
            EditableLabel l = this.axis.getLabelObject();
            if (l == null) {
                l = new EditableLabel("", "Axis Label");
                this.axis.setLabelObject(l);
            }
            lt.traverse((Node)node, l);
        } else if (name.equals("font")) {
            ft.traverse(node, (Axis)((Object)this.axis));
        } else {
            super.handleElement(node, name);
        }
    }

    @Override
    protected void handleAttributeNode(Attr node, String name, String value) throws XMLNodeTraverser.BadXMLException {
        if (name.equals("logarithmic")) {
            this.axis.setLogarithmic(this.toBoolean(value));
        } else if (name.equals("allowSuppressedZero")) {
            this.axis.setAllowSuppressedZero(this.toBoolean(value));
        } else if (name.equals("numberOfBins")) {
            this.axis.setBins(this.toInt(value));
        } else if (name.equals("type")) {
            this.axis.setAxisType(XMLPrintWriter.convertStringToAxisType(value));
        } else if (name.equals("min")) {
            this.axis.setMin(this.toDouble(value));
        } else if (name.equals("max")) {
            this.axis.setMax(this.toDouble(value));
        } else if (name.equals("showOverflows")) {
            this.axis.setShowOverflows(this.toBoolean(value));
        } else if (!name.equals("location")) {
            super.handleAttributeNode(node, name, value);
        }
    }
}

