/*
 * Decompiled with CFR 0.152.
 */
package jas2.hep;

import hepjas.analysis.Histogram;
import hepjas.analysis.Partition;
import hepjas.analysis.partition.Abstract1DPartition;
import hepjas.analysis.partition.Abstract2DPartition;
import hepjas.analysis.partition.PartitionNotification;
import hepjas.analysis.partition.ScatterDataSource;
import jas2.hep.HistogramUpdateAdapter;
import jas2.hep.Partition1DAdapter;
import jas2.hep.Partition2DAdapter;
import jas2.hep.ScatterAdapter;
import jas2.hep.StatisticsAdapter;
import jas2.hist.DataSource;
import jas2.hist.HasStatistics;
import jas2.hist.Statistics;
import jas2.hist.util.ObserverAdapter;
import java.util.Observable;

public abstract class PartitionAdapter
extends ObserverAdapter
implements DataSource,
HasStatistics {
    private String m_title;
    private Partition m_partition;

    public static DataSource create(Histogram h) {
        return PartitionAdapter.create(h.getPartition(), h.getName());
    }

    public static DataSource create(Partition partition, String title) {
        PartitionAdapter result;
        if (partition instanceof Abstract1DPartition) {
            result = new Partition1DAdapter((Abstract1DPartition)partition);
        } else if (partition instanceof Abstract2DPartition) {
            result = partition instanceof ScatterDataSource ? new ScatterAdapter((Abstract2DPartition)partition) : new Partition2DAdapter((Abstract2DPartition)partition);
        } else {
            throw new IllegalArgumentException("Argument is an unknown subtype of Partition");
        }
        result.m_title = title;
        ((PartitionAdapter)result).m_partition = partition;
        return result;
    }

    PartitionAdapter(Observable obs) {
        super(obs);
    }

    @Override
    public void notifyObservers(Object arg) {
        if (arg instanceof PartitionNotification) {
            arg = HistogramUpdateAdapter.create((PartitionNotification)arg);
        }
        super.notifyObservers(arg);
    }

    @Override
    public Statistics getStatistics() {
        return new StatisticsAdapter(this.m_partition.getStatistics());
    }

    @Override
    public String getTitle() {
        return this.m_title;
    }

    public String toString() {
        hepjas.analysis.partition.Statistics stats = this.m_partition.getStatistics();
        if (stats != null) {
            return this.getTitle() + ": " + stats;
        }
        return this.getTitle() + ": no statistics available";
    }
}

