/*
 * Decompiled with CFR 0.152.
 */
package htmllayout;

import htmllayout.Cell;
import htmllayout.Scanner;
import htmllayout.TableParser;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Hashtable;

public class HtmlLayout
implements LayoutManager {
    static final String anonLabelName = new String("Anonymous label");
    boolean labelsAdded;
    static final int MIN = 0;
    static final int PREF = 1;
    static final int LEFT = 0;
    static final int RIGHT = 1;
    static final int CENTER = 2;
    static final int FIT = 3;
    static final int MAX = 4;
    static final int TOP = 5;
    static final int BOTTOM = 6;
    static final String[] ALIGNNAMES = new String[]{"LEFT", "RIGHT", "CENTER", "FIT", "MAX", "TOP", "BOTTOM"};
    Hashtable nameToCell;
    Hashtable compToCell;
    Cell[] cells;
    Cell[] cellsColFirst;
    int rows;
    int cols;
    int horzAlign = 4;
    int vertAlign = 4;
    Dimension prefDim = new Dimension(-1, -1);

    public HtmlLayout(String html) {
        this.nameToCell = new Hashtable(30);
        this.compToCell = new Hashtable(30);
        this.parse(new Scanner(html), true, null);
        this.addCellsToTable(this.nameToCell);
    }

    HtmlLayout(TableParser parent) {
        this.parse(parent.in, false, parent);
    }

    public void addLabels(Container parent) {
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].addLabels(parent);
        }
        this.labelsAdded = true;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        this.prefDim.width = -1;
        if (name == anonLabelName) {
            return;
        }
        if (name == null) {
            throw new IllegalArgumentException("null component name");
        }
        Cell c = (Cell)this.nameToCell.get(name);
        if (c == null) {
            throw new IllegalArgumentException("Cannot add to layout: unknown component name " + name);
        }
        this.compToCell.put(comp, c);
        c.comp = comp;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.prefDim.width = -1;
        Cell c = (Cell)this.compToCell.remove(comp);
        if (c != null) {
            c.comp = null;
        }
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.layoutSize(parent, 1);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.layoutSize(parent, 0);
    }

    void parse(Scanner s, boolean eatTable, TableParser parent) {
        TableParser tp = new TableParser(s, eatTable, parent);
        this.rows = tp.rows;
        this.cols = tp.cols;
        this.horzAlign = tp.horz;
        this.vertAlign = tp.vert;
        this.cells = new Cell[tp.cellCount];
        int cpos = 0;
        this.cellsColFirst = new Cell[tp.cellCount];
        int ccfpos = 0;
        for (int i = 0; i < this.rows * this.cols; ++i) {
            if (tp.cells[i / this.cols][i % this.cols] != null) {
                this.cells[cpos] = tp.cells[i / this.cols][i % this.cols];
                ++cpos;
            }
            if (tp.cells[i % this.rows][i / this.rows] == null) continue;
            this.cellsColFirst[ccfpos] = tp.cells[i % this.rows][i / this.rows];
            ++ccfpos;
        }
    }

    Dimension layoutSize(Container parent, int whichSize) {
        if (!this.labelsAdded) {
            this.addLabels(parent);
        }
        return this.layoutSize(parent.getInsets(), whichSize);
    }

    Dimension layoutSize(Insets insets, int whichSize) {
        int i;
        int[] ypos = new int[this.rows + 1];
        int[] xpos = new int[this.cols + 1];
        for (i = 0; i < this.cells.length; ++i) {
            this.cells[i].updateSize(whichSize);
        }
        for (i = 0; i < this.cells.length; ++i) {
            this.cells[i].addToYTable(ypos);
            this.cellsColFirst[i].addToXTable(xpos);
        }
        Dimension d = new Dimension(xpos[this.cols], ypos[this.rows]);
        this.prefDim.width = d.width;
        this.prefDim.height = d.height;
        d.width += insets.left + insets.right;
        d.height += insets.top + insets.bottom;
        return d;
    }

    @Override
    public void layoutContainer(Container parent) {
        if (!this.labelsAdded) {
            this.addLabels(parent);
        }
        Insets insets = parent.getInsets();
        Dimension d = parent.getSize();
        int top = insets.top;
        int bottom = d.height - insets.bottom;
        int left = insets.left;
        int right = d.width - insets.right;
        this.preferredLayoutSize(parent);
        if (right - left < this.prefDim.width || bottom - top < this.prefDim.height) {
            this.minimumLayoutSize(parent);
        }
        this.layout(top, bottom, left, right);
    }

    void layout(int top, int bottom, int left, int right) {
        if (right - left > this.prefDim.width && this.horzAlign != 4 && this.horzAlign != 3) {
            left = HtmlLayout.calcTopOrLeft(left, right, this.prefDim.width, this.horzAlign);
            right = left + this.prefDim.width;
        }
        if (bottom - top > this.prefDim.height && this.vertAlign != 4 && this.vertAlign != 3) {
            top = HtmlLayout.calcTopOrLeft(top, bottom, this.prefDim.height, this.vertAlign);
            bottom = top + this.prefDim.height;
        }
        this.doLayout(top, bottom, left, right);
    }

    private void doLayout(int top, int bottom, int left, int right) {
        int[] ypos = new int[this.rows + 1];
        int[] xpos = new int[this.cols + 1];
        this.layoutDim(xpos, left, right, true);
        this.layoutDim(ypos, top, bottom, false);
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].finalLayout(xpos, ypos);
        }
    }

    private void layoutDim(int[] pos, int start, int end, boolean isX) {
        pos[0] = start;
        boolean[] want = new boolean[pos.length - 1];
        for (int i = 0; i < this.cells.length; ++i) {
            if (isX) {
                this.cellsColFirst[i].firstXLayout(pos, want);
                continue;
            }
            this.cells[i].firstYLayout(pos, want);
        }
        int diff = end - pos[want.length];
        if (diff < 0) {
            this.squeeze(-diff, pos, isX);
        } else if (diff > 0) {
            this.grow(diff, pos, want);
        }
        pos[pos.length - 1] = end;
    }

    private void squeeze(int pixels, int[] vals, boolean isX) {
        int[][] touch = new int[vals.length][isX ? this.rows : this.cols];
        int[] limit = new int[vals.length];
        int downto = vals[vals.length - 1] - pixels;
        if (downto < 2) {
            return;
        }
        while (vals[vals.length - 1] > downto) {
            int i;
            int[] count = new int[vals.length];
            for (i = 0; i < limit.length; ++i) {
                limit[i] = Integer.MAX_VALUE;
            }
            for (i = 0; i < this.cells.length; ++i) {
                if (isX) {
                    this.cellsColFirst[i].squeezeX(vals, touch, count, limit);
                    continue;
                }
                this.cells[i].squeezeY(vals, touch, count, limit);
            }
            boolean[] scale = new boolean[vals.length];
            int max = this.maxSqueeze(vals.length - 1, touch, count, limit, vals, scale);
            int amount = Math.min(pixels, max);
            int width = vals[vals.length - 1] - vals[0];
            int slide = 0;
            int i2 = 0;
            while (i2 < vals.length) {
                if (scale[i2]) {
                    slide = amount * (vals[i2] - vals[0]) / width;
                }
                int n = i2++;
                vals[n] = vals[n] - slide;
            }
            pixels -= slide;
        }
    }

    private int maxSqueeze(int rule, int[][] touch, int[] count, int[] limit, int[] vals, boolean[] scale) {
        scale[rule] = true;
        int max = limit[rule];
        for (int i = 0; i < count[rule]; ++i) {
            int othermax = this.maxSqueeze(touch[rule][i], touch, count, limit, vals, scale);
            if (othermax >= max) continue;
            max = othermax;
        }
        return max;
    }

    private void grow(int pixels, int[] vals, boolean[] where) {
        boolean all;
        int count = 0;
        for (int i = 0; i < where.length; ++i) {
            if (!where[i]) continue;
            ++count;
        }
        boolean bl = all = count == 0;
        if (all) {
            count = where.length;
        }
        double dif = ((double)pixels - 0.001) / (double)count;
        double a = 0.0;
        for (int i = 0; i < where.length; ++i) {
            if (all || where[i]) {
                a += dif;
            }
            int n = i + 1;
            vals[n] = vals[n] + (int)a;
        }
    }

    static int calcTopOrLeft(int tol, int bor, int wid, int align) {
        int newTol;
        switch (align) {
            case 0: 
            case 5: {
                newTol = tol;
                break;
            }
            case 1: 
            case 6: {
                newTol = bor - wid;
                break;
            }
            case 2: {
                newTol = tol + (bor - tol - wid) / 2;
                break;
            }
            default: {
                throw new Error("illegal align value");
            }
        }
        return newTol;
    }

    void addCellsToTable(Hashtable nToCell) {
        for (int i = 0; i < this.cells.length; ++i) {
            this.cells[i].addToNameTable(nToCell);
        }
    }

    private String descString() {
        return " dim = " + this.cols + ", " + this.rows + " fill = " + this.horzAlign + ", " + this.vertAlign;
    }

    void dump(int space) {
        int i;
        for (i = 0; i < space; ++i) {
            System.err.print(' ');
        }
        System.err.println("HtmlLayout" + this.descString());
        for (i = 0; i < this.cells.length; ++i) {
            this.cells[i].dump(space + 2);
        }
    }

    public String toString() {
        String s = "[HtmlLayout" + this.descString() + " cells =";
        for (int i = 0; i < this.cells.length; ++i) {
            s = s + " " + this.cells[i];
        }
        return s + "]";
    }
}

