/*
 * Decompiled with CFR 0.152.
 */
package hepjas.physics.jets;

import hepjas.physics.BasicHep3Vector;
import hepjas.physics.Hep3Vector;
import hepjas.physics.HepLorentzVector;
import hepjas.physics.predicate.Predicate;
import java.util.Enumeration;

public class EventShape {
    private double m_dSphMomPower = 2.0;
    private double m_dDeltaThPower = 0.0;
    private int m_iFast = 4;
    private double m_dConv = 1.0E-4;
    private int m_iGood = 2;
    private double[][] m_dAxes = new double[4][4];
    private double[] m_dThrust = new double[4];
    private double m_dOblateness;
    private BasicHep3Vector m_EigenVector1;
    private BasicHep3Vector m_EigenVector2;
    private BasicHep3Vector m_EigenVector3;
    private double m_dEigenValue1;
    private double m_dEigenValue2;
    private double m_dEigneValue3;
    private static final int m_maxpart = 1000;

    public void setEvent(Enumeration e) {
        this.setEvent(e, null);
    }

    public void setEvent(Enumeration e, Predicate cut) {
        int i;
        double thp;
        double sgn;
        double[][] mom = new double[1000][6];
        double tmax = 0.0;
        double phi = 0.0;
        double the = 0.0;
        double[][] fast = new double[this.m_iFast + 1][6];
        double[][] work = new double[11][6];
        double[] tdi = new double[4];
        double[] tpr = new double[4];
        double[][] temp = new double[3][5];
        int np = 0;
        while (e.hasMoreElements()) {
            Hep3Vector v;
            Object o = e.nextElement();
            if (cut != null && !cut.accept(o)) continue;
            if (np >= 1000) {
                throw new RuntimeException("Too many particles input to EventShape");
            }
            if (o instanceof Hep3Vector) {
                v = (Hep3Vector)o;
            } else if (o instanceof HepLorentzVector) {
                HepLorentzVector l = (HepLorentzVector)o;
                v = l.v3();
            } else {
                throw new RuntimeException("Element input to EventShape is not a Hep3Vector or an HepLorentzVector");
            }
            mom[np][1] = v.x();
            mom[np][2] = v.y();
            mom[np][3] = v.z();
            mom[np][4] = v.mag();
            mom[np][5] = Math.abs(this.m_dDeltaThPower) <= 0.001 ? 1.0 : Math.pow(mom[np][4], this.m_dDeltaThPower);
            tmax += mom[np][4] * mom[np][5];
            ++np;
        }
        if (np < 2) {
            this.m_dThrust[1] = -1.0;
            this.m_dOblateness = -1.0;
            return;
        }
        block1: for (int pass = 1; pass < 3; ++pass) {
            int iw;
            int j;
            int i2;
            if (pass == 2) {
                int i3;
                phi = this.ulAngle(this.m_dAxes[1][1], this.m_dAxes[1][2]);
                this.ludbrb(mom, 0.0, -phi, 0.0, 0.0, 0.0);
                for (i3 = 0; i3 < 3; ++i3) {
                    for (int j2 = 1; j2 < 4; ++j2) {
                        temp[i3][j2] = this.m_dAxes[i3 + 1][j2];
                    }
                    temp[i3][4] = 0.0;
                }
                this.ludbrb(temp, 0.0, -phi, 0.0, 0.0, 0.0);
                for (i3 = 0; i3 < 3; ++i3) {
                    for (int j3 = 1; j3 < 4; ++j3) {
                        this.m_dAxes[i3 + 1][j3] = temp[i3][j3];
                    }
                }
                the = this.ulAngle(this.m_dAxes[1][3], this.m_dAxes[1][1]);
                this.ludbrb(mom, -the, 0.0, 0.0, 0.0, 0.0);
                for (i3 = 0; i3 < 3; ++i3) {
                    for (int j4 = 1; j4 < 4; ++j4) {
                        temp[i3][j4] = this.m_dAxes[i3 + 1][j4];
                    }
                    temp[i3][4] = 0.0;
                }
                this.ludbrb(temp, -the, 0.0, 0.0, 0.0, 0.0);
                for (i3 = 0; i3 < 3; ++i3) {
                    for (int j5 = 1; j5 < 4; ++j5) {
                        this.m_dAxes[i3 + 1][j5] = temp[i3][j5];
                    }
                }
            }
            for (int ifas = 0; ifas < this.m_iFast + 1; ++ifas) {
                fast[ifas][4] = 0.0;
            }
            block11: for (i2 = 0; i2 < np; ++i2) {
                if (pass == 2) {
                    mom[i2][4] = Math.sqrt(mom[i2][1] * mom[i2][1] + mom[i2][2] * mom[i2][2]);
                }
                for (int ifas = this.m_iFast - 1; ifas > -1; --ifas) {
                    int j6;
                    if (mom[i2][4] > fast[ifas][4]) {
                        for (j6 = 1; j6 < 6; ++j6) {
                            fast[ifas + 1][j6] = fast[ifas][j6];
                            if (ifas != 0) continue;
                            fast[ifas][j6] = mom[i2][j6];
                        }
                        continue;
                    }
                    for (j6 = 1; j6 < 6; ++j6) {
                        fast[ifas + 1][j6] = mom[i2][j6];
                    }
                    continue block11;
                }
            }
            for (i2 = 0; i2 < work.length; ++i2) {
                work[i2][4] = 0.0;
            }
            int p = Math.min(this.m_iFast, np) - 1;
            int nc = this.iPow(2, p);
            for (int n = 0; n < nc; ++n) {
                for (int j7 = 1; j7 < 4; ++j7) {
                    tdi[j7] = 0.0;
                }
                for (int i4 = 0; i4 < Math.min(this.m_iFast, n); ++i4) {
                    sgn = fast[i4][5];
                    if (this.iPow(2, i4 + 1) * ((n + this.iPow(2, i4)) / this.iPow(2, i4 + 1)) >= i4 + 1) {
                        sgn = -sgn;
                    }
                    for (j = 1; j < 5 - pass; ++j) {
                        tdi[j] = tdi[j] + sgn * fast[i4][j];
                    }
                }
                double tds = tdi[1] * tdi[1] + tdi[2] * tdi[2] + tdi[3] * tdi[3];
                for (iw = Math.min(n, 9); iw > -1; --iw) {
                    if (tds > work[iw][4]) {
                        for (j = 1; j < 5; ++j) {
                            work[iw + 1][j] = work[iw][j];
                            if (iw != 0) continue;
                            work[iw][j] = j < 4 ? tdi[j] : tds;
                        }
                        continue;
                    }
                    for (j = 1; j < 4; ++j) {
                        work[iw + 1][j] = tdi[j];
                    }
                    work[iw + 1][4] = tds;
                }
            }
            this.m_dThrust[pass] = 0.0;
            thp = -99999.0;
            int nagree = 0;
            for (iw = 0; iw < Math.min(nc, 10) && nagree < this.m_iGood; ++nagree, ++iw) {
                thp = 0.0;
                double thps = -99999.0;
                while (thp > thps + this.m_dConv) {
                    thps = thp;
                    for (j = 1; j < 4; ++j) {
                        if (thp <= 1.0E-10) {
                            tdi[j] = work[iw][j];
                            continue;
                        }
                        tdi[j] = tpr[j];
                        tpr[j] = 0.0;
                    }
                    for (int i5 = 0; i5 < np; ++i5) {
                        sgn = this.sign(mom[i5][5], tdi[1] * mom[i5][1] + tdi[2] * mom[i5][2] + tdi[3] * mom[i5][3]);
                        for (int j8 = 1; j8 < 5 - pass; ++j8) {
                            tpr[j8] = tpr[j8] + sgn * mom[i5][j8];
                        }
                    }
                    thp = Math.sqrt(tpr[1] * tpr[1] + tpr[2] * tpr[2] + tpr[3] * tpr[3]) / tmax;
                }
                if (thp < this.m_dThrust[pass] - this.m_dConv) continue block1;
                if (!(thp > this.m_dThrust[pass] + this.m_dConv)) continue;
                nagree = 0;
                sgn = this.iPow(-1, (int)Math.round(Math.random()));
                for (j = 1; j < 4; ++j) {
                    this.m_dAxes[pass][j] = sgn * tpr[j] / (tmax * thp);
                }
                this.m_dThrust[pass] = thp;
            }
        }
        sgn = this.iPow(-1, (int)Math.round(Math.random()));
        this.m_dAxes[3][1] = -sgn * this.m_dAxes[2][2];
        this.m_dAxes[3][2] = sgn * this.m_dAxes[2][1];
        this.m_dAxes[3][3] = 0.0;
        thp = 0.0;
        for (i = 0; i < np; ++i) {
            thp += mom[i][5] * Math.abs(this.m_dAxes[3][1] * mom[i][1] + this.m_dAxes[3][2] * mom[i][2]);
        }
        this.m_dThrust[3] = thp / tmax;
        for (i = 0; i < 3; ++i) {
            for (int j = 1; j < 4; ++j) {
                temp[i][j] = this.m_dAxes[i + 1][j];
            }
            temp[i][4] = 0.0;
        }
        this.ludbrb(temp, the, phi, 0.0, 0.0, 0.0);
        for (i = 0; i < 3; ++i) {
            for (int j = 1; j < 4; ++j) {
                this.m_dAxes[i + 1][j] = temp[i][j];
            }
        }
        this.m_dOblateness = this.m_dThrust[2] - this.m_dThrust[3];
    }

    public void setThMomPower(double tp) {
        if (tp > 0.0) {
            this.m_dDeltaThPower = tp - 1.0;
        }
    }

    public double getThMomPower() {
        return 1.0 + this.m_dDeltaThPower;
    }

    public void setFast(int nf) {
        if (nf > 3) {
            this.m_iFast = nf;
        }
    }

    public int getFast() {
        return this.m_iFast;
    }

    public BasicHep3Vector thrustAxis() {
        return new BasicHep3Vector(this.m_dAxes[1][1], this.m_dAxes[1][2], this.m_dAxes[1][3]);
    }

    public BasicHep3Vector majorAxis() {
        return new BasicHep3Vector(this.m_dAxes[2][1], this.m_dAxes[2][2], this.m_dAxes[2][3]);
    }

    public BasicHep3Vector minorAxis() {
        return new BasicHep3Vector(this.m_dAxes[3][1], this.m_dAxes[3][2], this.m_dAxes[3][3]);
    }

    public BasicHep3Vector thrust() {
        return new BasicHep3Vector(this.m_dThrust[1], this.m_dThrust[2], this.m_dThrust[3]);
    }

    public double oblateness() {
        return this.m_dOblateness;
    }

    private double ulAngle(double x, double y) {
        double ulangl = 0.0;
        double r = Math.sqrt(x * x + y * y);
        if (r < 1.0E-20) {
            return ulangl;
        }
        if (Math.abs(x) / r < 0.8) {
            ulangl = this.sign(Math.acos(x / r), y);
        } else {
            ulangl = Math.asin(y / r);
            if (x < 0.0 && ulangl >= 0.0) {
                ulangl = Math.PI - ulangl;
            } else if (x < 0.0) {
                ulangl = -Math.PI - ulangl;
            }
        }
        return ulangl;
    }

    private double sign(double a, double b) {
        if (b < 0.0) {
            return -Math.abs(a);
        }
        return Math.abs(a);
    }

    private void ludbrb(double[][] mom, double the, double phi, double bx, double by, double bz) {
        double[][] rot = new double[4][4];
        double[] pr = new double[4];
        double[] dp = new double[5];
        int np = mom.length;
        if (the * the + phi * phi > 1.0E-20) {
            rot[1][1] = Math.cos(the) * Math.cos(phi);
            rot[1][2] = -Math.sin(phi);
            rot[1][3] = Math.sin(the) * Math.cos(phi);
            rot[2][1] = Math.cos(the) * Math.sin(phi);
            rot[2][2] = Math.cos(phi);
            rot[2][3] = Math.sin(the) * Math.sin(phi);
            rot[3][1] = -Math.sin(the);
            rot[3][2] = 0.0;
            rot[3][3] = Math.cos(the);
            for (int i = 0; i < np; ++i) {
                int j;
                for (j = 1; j < 4; ++j) {
                    pr[j] = mom[i][j];
                    mom[i][j] = 0.0;
                }
                for (j = 1; j < 4; ++j) {
                    for (int k = 1; k < 4; ++k) {
                        mom[i][j] = mom[i][j] + rot[j][k] * pr[k];
                    }
                }
            }
            double beta = Math.sqrt(bx * bx + by * by + bz * bz);
            if (beta * beta > 1.0E-20) {
                if (beta > 0.99999999) {
                    bx *= 0.99999999 / beta;
                    by *= 0.99999999 / beta;
                    bz *= 0.99999999 / beta;
                    beta = 0.99999999;
                }
                double gamma = 1.0 / Math.sqrt(1.0 - beta * beta);
                for (int i = 0; i < np; ++i) {
                    for (int j = 1; j < 5; ++j) {
                        dp[j] = mom[i][j];
                    }
                    double bp = bx * dp[1] + by * dp[2] + bz * dp[3];
                    double gbp = gamma * (gamma * bp / (1.0 + gamma) + dp[4]);
                    mom[i][1] = dp[1] + gbp * bx;
                    mom[i][2] = dp[2] + gbp * by;
                    mom[i][3] = dp[3] + gbp * bz;
                    mom[i][4] = gamma * (dp[4] + bp);
                }
            }
        }
    }

    private int iPow(int man, int exp) {
        int ans = 1;
        for (int k = 0; k < exp; ++k) {
            ans *= man;
        }
        return ans;
    }
}

