/*
 * Decompiled with CFR 0.152.
 */
package hepjas.physics.generator.event;

import hepjas.physics.Hep3Vector;
import hepjas.physics.HepLorentzVector;
import hepjas.physics.Particle;
import hepjas.physics.ParticleEnumeration;
import hepjas.physics.ParticleType;
import hepjas.physics.generator.event.GeneratorParticleVector;

public class GeneratorParticle
implements Particle {
    private double m_dpX;
    private double m_dpY;
    private double m_dpZ;
    private double m_denergy;
    private double m_doriginX;
    private double m_doriginY;
    private double m_doriginZ;
    private double m_productionTime;
    private int m_statusCode;
    private ParticleType m_pType;
    private GeneratorParticleVector m_parents;
    private GeneratorParticleVector m_daughters = new GeneratorParticleVector();

    public GeneratorParticle() {
        this.m_parents = new GeneratorParticleVector();
    }

    public void setStatusCode(int status) {
        this.m_statusCode = status;
    }

    public void setProductionTime(double prodtime) {
        this.m_productionTime = prodtime;
    }

    public void setType(ParticleType ptype) {
        this.m_pType = ptype;
    }

    public void setOrigin(Hep3Vector origin) {
        this.m_doriginX = origin.x();
        this.m_doriginY = origin.y();
        this.m_doriginZ = origin.z();
    }

    public void setP(HepLorentzVector p) {
        this.m_dpX = p.v3().x();
        this.m_dpY = p.v3().y();
        this.m_dpZ = p.v3().z();
        this.m_denergy = p.t();
    }

    @Override
    public double getPX() {
        return this.m_dpX;
    }

    @Override
    public double getPY() {
        return this.m_dpY;
    }

    @Override
    public double getPZ() {
        return this.m_dpZ;
    }

    @Override
    public double getEnergy() {
        return this.m_denergy;
    }

    @Override
    public double getMass() {
        return this.m_pType.getMass();
    }

    @Override
    public double getOriginX() {
        return this.m_doriginX;
    }

    @Override
    public double getOriginY() {
        return this.m_doriginY;
    }

    @Override
    public double getOriginZ() {
        return this.m_doriginZ;
    }

    @Override
    public double getProductionTime() {
        return this.m_productionTime;
    }

    @Override
    public int getStatusCode() {
        return this.m_statusCode;
    }

    @Override
    public double[] getMomentum() {
        double[] result = new double[]{this.getPX(), this.getPY(), this.getPZ()};
        return result;
    }

    @Override
    public double[] getOrigin() {
        double[] result = new double[]{this.getOriginX(), this.getOriginY(), this.getOriginZ()};
        return result;
    }

    @Override
    public ParticleEnumeration getDaughters() {
        return this.m_daughters.particles();
    }

    @Override
    public Particle getParent() {
        if (this.m_parents.isEmpty()) {
            return null;
        }
        if (this.m_parents.size() == 1) {
            return (Particle)this.m_parents.elementAt(0);
        }
        throw new RuntimeException("Invalid call to getParent for Particle with >1 parent. Use getParents() instead");
    }

    @Override
    public ParticleEnumeration getParents() {
        return this.m_parents.particles();
    }

    @Override
    public ParticleType getType() {
        return this.m_pType;
    }

    public void addParent(GeneratorParticle parent) {
        this.m_parents.addElement(parent);
        parent.IAmYourDaughter(this);
    }

    private void IAmYourDaughter(GeneratorParticle daughter) {
        this.m_daughters.addElement(daughter);
    }
}

