/*
 * Decompiled with CFR 0.152.
 */
package hepjas.physics;

import hepjas.physics.BasicHep3Vector;
import hepjas.physics.BasicHepLorentzVector;
import hepjas.physics.Hep3Matrix;
import hepjas.physics.Hep3Vector;
import hepjas.physics.HepLorentzVector;
import java.util.Enumeration;

public class VecOp {
    private VecOp() {
    }

    public static Hep3Vector add(Hep3Vector v, Hep3Vector w) {
        return new BasicHep3Vector(v.x() + w.x(), v.y() + w.y(), v.z() + w.z());
    }

    public static Hep3Vector sub(Hep3Vector v, Hep3Vector w) {
        return new BasicHep3Vector(v.x() - w.x(), v.y() - w.y(), v.z() - w.z());
    }

    public static Hep3Vector mult(double scalar, Hep3Vector v) {
        return new BasicHep3Vector(scalar * v.x(), scalar * v.y(), scalar * v.z());
    }

    public static Hep3Vector mult(Hep3Matrix m, Hep3Vector v) {
        double w1 = v.x() * m.e(1, 1) + v.y() * m.e(1, 2) + v.z() * m.e(1, 3);
        double w2 = v.x() * m.e(2, 1) + v.y() * m.e(2, 2) + v.z() * m.e(2, 3);
        double w3 = v.x() * m.e(3, 1) + v.y() * m.e(3, 2) + v.z() * m.e(3, 3);
        return new BasicHep3Vector(w1, w2, w3);
    }

    public static Hep3Vector neg(Hep3Vector v) {
        return new BasicHep3Vector(-v.x(), -v.y(), -v.z());
    }

    public static double dot(Hep3Vector v, Hep3Vector w) {
        return v.x() * w.x() + v.y() * w.y() + v.z() * w.z();
    }

    public static Hep3Vector cross(Hep3Vector v, Hep3Vector w) {
        double u1 = v.y() * w.z() - v.z() * w.y();
        double u2 = v.z() * w.x() - v.x() * w.z();
        double u3 = v.x() * w.y() - v.y() * w.x();
        return new BasicHep3Vector(u1, u2, u3);
    }

    public static Hep3Vector unit(Hep3Vector v) {
        double mag = v.mag();
        if (mag != 0.0) {
            return VecOp.mult(1.0 / mag, v);
        }
        return new BasicHep3Vector(0.0, 0.0, 0.0);
    }

    public static HepLorentzVector add(HepLorentzVector v, HepLorentzVector w) {
        return new BasicHepLorentzVector(v.t() + w.t(), VecOp.add(v.v3(), w.v3()));
    }

    public static HepLorentzVector sub(HepLorentzVector v, HepLorentzVector w) {
        return new BasicHepLorentzVector(v.t() - w.t(), VecOp.sub(v.v3(), w.v3()));
    }

    public static HepLorentzVector mult(double scalar, HepLorentzVector v) {
        return new BasicHepLorentzVector(scalar * v.t(), VecOp.mult(scalar, v.v3()));
    }

    public static HepLorentzVector neg(HepLorentzVector v) {
        return new BasicHepLorentzVector(-v.t(), VecOp.neg(v.v3()));
    }

    public static double dot(HepLorentzVector v, HepLorentzVector w) {
        return v.t() * w.t() - VecOp.dot(v.v3(), w.v3());
    }

    public static Hep3Vector CM(Enumeration vecSet) {
        boolean empty = true;
        boolean threeVecSet = false;
        boolean fourVecSet = false;
        Hep3Vector cmVec = new BasicHep3Vector();
        while (vecSet.hasMoreElements()) {
            if (empty) {
                empty = false;
                Object e = vecSet.nextElement();
                if (e instanceof Hep3Vector) {
                    threeVecSet = true;
                    cmVec = (Hep3Vector)e;
                    continue;
                }
                if (e instanceof HepLorentzVector) {
                    fourVecSet = true;
                    HepLorentzVector v = (HepLorentzVector)e;
                    cmVec = v.v3();
                    continue;
                }
                throw new RuntimeException("Element is not a 3- or 4-vector");
            }
            if (fourVecSet) {
                try {
                    HepLorentzVector v = (HepLorentzVector)vecSet.nextElement();
                    cmVec = VecOp.add(cmVec, v.v3());
                    continue;
                }
                catch (ClassCastException ex) {
                    throw new RuntimeException("Element of 4Vec enumeration is not a 4Vec.");
                }
            }
            if (!threeVecSet) continue;
            try {
                cmVec = VecOp.add(cmVec, (Hep3Vector)vecSet.nextElement());
            }
            catch (ClassCastException ex) {
                throw new RuntimeException("Element of 3Vec enumeration is not a 3Vec object.");
            }
        }
        if (!empty) {
            return cmVec;
        }
        throw new RuntimeException("CM:vector set is empty.");
    }

    public static HepLorentzVector boost(HepLorentzVector fourVector, Hep3Vector boostVector) {
        double beta = boostVector.mag();
        if (beta >= 1.0) {
            throw new RuntimeException("Boost beta >= 1.0 !");
        }
        double gamma = 1.0 / Math.sqrt(1.0 - beta * beta);
        double t = fourVector.t();
        Hep3Vector v = fourVector.v3();
        double tp = gamma * (t - VecOp.dot(boostVector, v));
        Hep3Vector vp = VecOp.add(v, VecOp.add(VecOp.mult((gamma - 1.0) / (beta * beta) * VecOp.dot(boostVector, v), boostVector), VecOp.mult(-gamma * t, boostVector)));
        return new BasicHepLorentzVector(tp, vp);
    }

    public static HepLorentzVector boost(HepLorentzVector fourVector, HepLorentzVector refFourVector) {
        Hep3Vector refVector = refFourVector.v3();
        Hep3Vector boostVector = new BasicHep3Vector(refVector.x(), refVector.y(), refVector.z());
        boostVector = VecOp.mult(1.0 / refFourVector.t(), boostVector);
        return VecOp.boost(fourVector, boostVector);
    }
}

