/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.partition.AbstractTwoDFillable;
import hepjas.analysis.partition.RangeChangeListener;
import hepjas.analysis.partition.Statistics;
import hepjas.analysis.partition.StatisticsProvider;

public class TwoDStatisticsProvider
extends AbstractTwoDFillable
implements StatisticsProvider {
    private double m_xLow;
    private double m_xHigh;
    private double m_xMean;
    private double m_xRms;
    private double m_yLow;
    private double m_yHigh;
    private double m_yMean;
    private double m_yRms;
    private double m_totalWeight;
    private int m_entries;
    private RangeChangeListener m_xRange;
    private RangeChangeListener m_yRange;
    static final long serialVersionUID = -4389000125022775776L;

    TwoDStatisticsProvider() {
        this.clear();
    }

    TwoDStatisticsProvider(RangeChangeListener xl, RangeChangeListener yl) {
        this.clear();
        this.m_xRange = xl;
        this.m_yRange = yl;
    }

    void setRangeChangeListener(RangeChangeListener xl, RangeChangeListener yl) {
        this.m_xRange = xl;
        this.m_yRange = yl;
    }

    @Override
    public void fillW(double x, double y, double v) {
        boolean b2;
        this.m_totalWeight += v;
        this.m_xMean += x * v;
        this.m_xRms += x * x * v;
        this.m_yMean += y * v;
        this.m_yRms += y * y * v;
        if (this.m_entries++ == 0) {
            this.m_xLow = this.m_xHigh = x;
            this.m_yLow = this.m_yHigh = y;
            if (this.m_xRange != null) {
                this.m_xRange.rangeChanged(x, x);
            }
            if (this.m_yRange != null) {
                this.m_yRange.rangeChanged(y, y);
            }
            return;
        }
        boolean b1 = x < this.m_xLow;
        boolean bl = b2 = x > this.m_xHigh;
        if (b1 || b2) {
            if (b1) {
                this.m_xLow = x;
            }
            if (b2) {
                this.m_xHigh = x;
            }
            if (this.m_xRange != null) {
                this.m_xRange.rangeChanged(this.m_xLow, this.m_xHigh);
            }
        }
        b1 = y < this.m_yLow;
        boolean bl2 = b2 = y > this.m_yHigh;
        if (b1 || b2) {
            if (b1) {
                this.m_yLow = y;
            }
            if (b2) {
                this.m_yHigh = y;
            }
            if (this.m_yRange != null) {
                this.m_yRange.rangeChanged(this.m_yLow, this.m_yHigh);
            }
        }
    }

    @Override
    public void clear() {
        this.m_entries = 0;
        this.m_totalWeight = 0.0;
        this.m_xMean = 0.0;
        this.m_xRms = 0.0;
        this.m_xLow = 0.0;
        this.m_xHigh = 0.0;
        this.m_yMean = 0.0;
        this.m_yRms = 0.0;
        this.m_yLow = 0.0;
        this.m_yHigh = 0.0;
    }

    public int getEntries() {
        return this.m_entries;
    }

    public double getXMean() {
        return this.m_xMean / this.m_totalWeight;
    }

    public double getXRMS() {
        return Math.sqrt(this.m_xRms / this.m_totalWeight - this.m_xMean * this.m_xMean / this.m_totalWeight / this.m_totalWeight);
    }

    public double getXMin() {
        return this.m_xLow;
    }

    public double getXMax() {
        return this.m_xHigh;
    }

    public double getYMean() {
        return this.m_yMean / this.m_totalWeight;
    }

    public double getYRMS() {
        return Math.sqrt(this.m_yRms / this.m_totalWeight - this.m_yMean * this.m_yMean / this.m_totalWeight / this.m_totalWeight);
    }

    public double getYMin() {
        return this.m_yLow;
    }

    public double getYMax() {
        return this.m_yHigh;
    }

    @Override
    public Statistics getStatistics() {
        Statistics stats = new Statistics(9);
        stats.setStatistic("entries", this.getEntries());
        stats.setStatistic("x mean", this.getXMean());
        stats.setStatistic("x rms", this.getXRMS());
        stats.setStatistic("x min", this.getXMin());
        stats.setStatistic("x max", this.getXMax());
        stats.setStatistic("y mean", this.getYMean());
        stats.setStatistic("y rms", this.getYRMS());
        stats.setStatistic("y min", this.getYMin());
        stats.setStatistic("y max", this.getYMax());
        return stats;
    }
}

