/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.Partition;
import hepjas.analysis.partition.Abstract2DPartition;
import hepjas.analysis.partition.BinType;
import hepjas.analysis.partition.RangeChangeListener;
import hepjas.analysis.partition.SimpleBinFinder;
import hepjas.analysis.partition.SimpleBinner;
import hepjas.analysis.partition.SimpleTwoDDataSourceAdapter;
import hepjas.analysis.partition.SimpleTwoDStorer;
import hepjas.analysis.partition.Statistics;
import hepjas.analysis.partition.TwoDBinAdapter;
import hepjas.analysis.partition.TwoDBinTypeAdapter;
import hepjas.analysis.partition.TwoDDataSource;
import hepjas.analysis.partition.TwoDFillable;
import hepjas.analysis.partition.TwoDFillableTee;
import hepjas.analysis.partition.TwoDStatisticsProvider;
import hepjas.analysis.partition.TwoDStorer;

public class Simple2DPartition
extends Abstract2DPartition {
    private TwoDStorer m_storer;
    private TwoDStatisticsProvider m_stats;
    private TwoDFillable m_filler;
    private double m_xMin;
    private double m_xMax;
    private double m_yMin;
    private double m_yMax;
    private boolean m_rangeSet;
    private BinType m_type = new SimpleBinner(0);
    private int m_xBins;
    private double m_xBinLow;
    private double m_xBinHigh;
    private int m_yBins;
    private double m_yBinLow;
    private double m_yBinHigh;
    private TwoDDataSource m_source;
    static final long serialVersionUID = -1795657090122338079L;

    public Simple2DPartition() {
        this.m_rangeSet = false;
        this.m_storer = this.createStorer();
        RangeChangeListener xr = this.getRangeChangeListener(0);
        RangeChangeListener yr = this.getRangeChangeListener(1);
        this.m_stats = new TwoDStatisticsProvider(xr, yr);
        this.m_filler = new TwoDFillableTee(this.m_storer, this.m_stats);
    }

    public Simple2DPartition(double xMin, double xMax, double yMin, double yMax) {
        this.m_rangeSet = true;
        this.m_xMin = xMin;
        this.m_xMax = xMax;
        this.m_yMin = yMin;
        this.m_yMax = yMax;
        this.m_storer = this.createStorer();
    }

    protected TwoDStorer createStorer() {
        return new SimpleTwoDStorer();
    }

    @Override
    public void fill(double x, double y) {
        this.m_filler.fill(x, y);
        this.setDataChanged();
    }

    @Override
    public void fillW(double x, double y, double weight) {
        this.m_filler.fillW(x, y, weight);
        this.setDataChanged();
    }

    @Override
    public void clear() {
        this.m_filler.clear();
        this.m_source = null;
        super.clear();
    }

    @Override
    public double getXMin() {
        if (this.m_rangeSet) {
            return this.m_xMin;
        }
        return this.m_stats.getXMin();
    }

    @Override
    public double getXMax() {
        if (this.m_rangeSet) {
            return this.m_xMax;
        }
        return this.m_stats.getXMax();
    }

    @Override
    public double getYMin() {
        if (this.m_rangeSet) {
            return this.m_yMin;
        }
        return this.m_stats.getYMin();
    }

    @Override
    public double getYMax() {
        if (this.m_rangeSet) {
            return this.m_yMax;
        }
        return this.m_stats.getYMax();
    }

    @Override
    public void setXBinning(int bins, double min, double max) {
        if (bins != this.m_xBins || min != this.m_xBinLow || max != this.m_xBinHigh) {
            this.m_xBins = bins;
            this.m_xBinLow = min;
            this.m_xBinHigh = max;
        }
        this.m_source = null;
    }

    @Override
    public void setYBinning(int bins, double min, double max) {
        if (bins != this.m_yBins || min != this.m_yBinLow || max != this.m_yBinHigh) {
            this.m_yBins = bins;
            this.m_yBinLow = min;
            this.m_yBinHigh = max;
        }
        this.m_source = null;
    }

    private void doBin() {
        this.clearDataChanged();
        SimpleBinFinder xFinder = new SimpleBinFinder(this.m_xBins, this.m_xBinLow, this.m_xBinHigh, false);
        SimpleBinFinder yFinder = new SimpleBinFinder(this.m_yBins, this.m_yBinLow, this.m_yBinHigh, false);
        TwoDBinTypeAdapter type = new TwoDBinTypeAdapter(this.m_type, this.m_xBins, this.m_yBins);
        TwoDBinAdapter fill = new TwoDBinAdapter(xFinder, yFinder, type);
        this.m_storer.fillData(fill);
        this.m_source = new SimpleTwoDDataSourceAdapter(xFinder, yFinder, type);
    }

    @Override
    public double[][] getBins() {
        if (this.m_source == null) {
            this.doBin();
        }
        return this.m_source.getBins();
    }

    @Override
    public double[][] getPlusErrors() {
        if (this.m_source == null) {
            this.doBin();
        }
        return this.m_source.getPlusErrors();
    }

    @Override
    public double[][] getMinusErrors() {
        if (this.m_source == null) {
            this.doBin();
        }
        return this.m_source.getMinusErrors();
    }

    @Override
    public Statistics getStatistics() {
        return this.m_stats.getStatistics();
    }

    @Override
    public int getNumberOfXBins() {
        return 40;
    }

    @Override
    public int getNumberOfYBins() {
        return 40;
    }

    @Override
    public boolean isRebinnable() {
        return true;
    }

    @Override
    public boolean hasAsymmetricErrorBars() {
        if (this.m_source == null) {
            this.doBin();
        }
        return this.m_source.hasAsymmetricErrorBars();
    }

    @Override
    public boolean hasSimpleQuadraticErrorBars() {
        if (this.m_source == null) {
            this.doBin();
        }
        return this.m_source.hasSimpleQuadraticErrorBars();
    }

    @Override
    public String[] getXAxisLabels() {
        if (this.m_source == null) {
            this.doBin();
        }
        return this.m_source.getXAxisLabels();
    }

    @Override
    public String[] getYAxisLabels() {
        if (this.m_source == null) {
            this.doBin();
        }
        return this.m_source.getYAxisLabels();
    }

    @Override
    public Partition makeCopy() {
        if (this.m_rangeSet) {
            return new Simple2DPartition(this.m_xMin, this.m_xMax, this.m_yMin, this.m_yMax);
        }
        return new Simple2DPartition();
    }
}

