/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import java.io.Serializable;

public final class PartitionNotification
implements Serializable {
    private static final int FINAL_UPDATE = 1;
    public static final int DATA_UPDATE = 2;
    public static final int RANGE_UPDATE = 4;
    public static final int TITLE_UPDATE = 8;
    public static final int RESET = 16;
    private final int AXIS_BASE = 32;
    protected int m_id;
    static final long serialVersionUID = 7268052608395174151L;

    public PartitionNotification(int id, boolean f) {
        if (f) {
            id |= 1;
        }
        this.m_id = id;
    }

    public void setAxis(int axisIndex) {
        this.m_id |= 32 << axisIndex;
    }

    public boolean axisIsSet(int axisIndex) {
        return (this.m_id & 32 << axisIndex) != 0;
    }

    public boolean isFinalUpdate() {
        return (this.m_id & 1) != 0;
    }

    public boolean isDataUpdate() {
        return (this.m_id & 2) != 0;
    }

    public boolean isRangeUpdate() {
        return (this.m_id & 4) != 0;
    }

    public boolean isTitleUpdate() {
        return (this.m_id & 8) != 0;
    }

    public boolean isReset() {
        return (this.m_id & 0x10) != 0;
    }

    public String toString() {
        return "PartitionNotification " + (this.isDataUpdate() ? "DATA " : "") + (this.isRangeUpdate() ? "RANGE " : "") + (this.isTitleUpdate() ? "TITLE " : "") + (this.isReset() ? "RESET " : "") + (this.isFinalUpdate() ? "FINAL " : "");
    }
}

