/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.Partition;
import hepjas.analysis.partition.BinAdapter;
import hepjas.analysis.partition.BinType;
import hepjas.analysis.partition.FillableTee;
import hepjas.analysis.partition.OneDDelegatingPartition;
import hepjas.analysis.partition.OneDStatisticsProvider;
import hepjas.analysis.partition.SimpleBinFinder;
import hepjas.analysis.partition.SimpleBinner;
import hepjas.analysis.partition.SimpleOneDDataSourceAdapter;

public class FixedPartition
extends OneDDelegatingPartition {
    private SimpleBinFinder m_finder;
    static final long serialVersionUID = -9108903495924785576L;

    public FixedPartition(double low, double high) {
        this(low, high, 40);
    }

    public FixedPartition(double low, double high, int bins) {
        this(low, high, new SimpleBinner(bins));
    }

    public FixedPartition(double low, double high, BinType binner) {
        int bins = binner.getNumberOfBins();
        OneDStatisticsProvider stats = new OneDStatisticsProvider(low, high, bins);
        this.m_finder = new SimpleBinFinder(bins, low, high, false);
        BinAdapter filler = new BinAdapter(this.m_finder, binner);
        FillableTee tee = new FillableTee(stats, filler);
        this.setFillable(tee);
        this.setStatisticsProvider(stats);
        this.setBinInfo(this.m_finder);
        this.setDataSource(new SimpleOneDDataSourceAdapter(this.m_finder, binner));
    }

    @Override
    public Partition makeCopy() {
        return new FixedPartition(this.m_finder.getMin(), this.m_finder.getMax(), this.m_finder.getNumberOfBins());
    }
}

