/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis.partition;

import hepjas.analysis.Partition;
import hepjas.analysis.partition.BinAdapter;
import hepjas.analysis.partition.BinType;
import hepjas.analysis.partition.FillableTee;
import hepjas.analysis.partition.OneDDelegatingPartition;
import hepjas.analysis.partition.OneDStatisticsProvider;
import hepjas.analysis.partition.SimpleBinFinder;
import hepjas.analysis.partition.SimpleBinner;
import hepjas.analysis.partition.SimpleBinnerDataSourceAdapter;
import hepjas.analysis.partition.SimpleStorer;
import hepjas.analysis.partition.Statistics;
import hepjas.analysis.partition.ThresholdListener;
import hepjas.analysis.partition.ThresholdStorer;

public class AutoPartition
extends OneDDelegatingPartition
implements ThresholdListener {
    protected double m_min;
    protected double m_max;
    protected boolean m_autoRange;
    protected boolean m_thresholdReached;
    protected int m_defaultBins;
    protected int m_autoCutoff;
    private BinType m_type;
    private SimpleStorer m_storer;
    private OneDStatisticsProvider m_stats;
    static final long serialVersionUID = -4479135908960997917L;

    public AutoPartition() {
        this(2000, 40);
    }

    public AutoPartition(int autoCutoff, int bins) {
        this(autoCutoff, new SimpleBinner(bins));
    }

    public AutoPartition(int autoCutoff, BinType type) {
        if (autoCutoff <= 0) {
            throw new IllegalArgumentException("autoCutoff <= 0");
        }
        this.m_autoCutoff = autoCutoff;
        this.m_type = type;
        this.m_thresholdReached = false;
        this.m_autoRange = true;
        this.m_defaultBins = type.getNumberOfBins();
        this.m_storer = new ThresholdStorer(autoCutoff, this);
        this.m_stats = new OneDStatisticsProvider(this);
        this.setFillable(new FillableTee(this.m_storer, this.m_stats));
        this.setStatisticsProvider(this.m_stats);
    }

    public AutoPartition(double min, double max) {
        this(2000, 40, min, max);
    }

    public AutoPartition(int autoCutoff, int bins, double min, double max) {
        this(autoCutoff, new SimpleBinner(bins), min, max);
    }

    public AutoPartition(int autoCutoff, BinType type, double min, double max) {
        if (autoCutoff <= 0) {
            throw new IllegalArgumentException("autoCutoff <= 0");
        }
        this.m_autoCutoff = autoCutoff;
        this.m_type = type;
        this.m_thresholdReached = false;
        this.m_autoRange = false;
        this.m_min = min;
        this.m_max = max;
        this.m_defaultBins = type.getNumberOfBins();
        this.m_storer = new SimpleStorer();
        this.setFillable(this.m_storer);
    }

    @Override
    public void setBinning(int bins, double min, double max) {
        if (!this.m_thresholdReached) {
            SimpleBinFinder finder = new SimpleBinFinder(bins, min, max, false);
            SimpleBinner binner = new SimpleBinner(bins);
            BinAdapter fill = new BinAdapter(finder, binner);
            this.m_storer.fillData(fill);
            this.setDataSource(new SimpleBinnerDataSourceAdapter(finder, binner));
        }
    }

    @Override
    public void thresholdReached() {
        System.out.println("Auto Partition Threshold reached");
        if (this.m_autoRange) {
            this.m_min = this.m_stats.getMin();
            this.m_max = this.m_stats.getMax();
            System.out.println("min,max=" + this.m_min + "," + this.m_max);
            SimpleBinFinder finder = new SimpleBinFinder(this.m_defaultBins, this.m_min, this.m_max, false);
            BinAdapter fill = new BinAdapter(finder, this.m_type);
            this.m_storer.fillData(fill);
            this.setDataSource(new SimpleBinnerDataSourceAdapter(finder, this.m_type));
            this.m_stats.setRangeChangeListener(null);
            this.setFillable(new FillableTee(this.m_stats, fill));
            this.m_storer = null;
            this.m_thresholdReached = true;
        } else {
            System.out.println("min,max=" + this.m_min + "," + this.m_max);
            SimpleBinFinder finder = new SimpleBinFinder(this.m_defaultBins, this.m_min, this.m_max, false);
            this.m_stats = new OneDStatisticsProvider();
            this.setStatisticsProvider(this.m_stats);
            FillableTee fill = new FillableTee(this.m_stats, new BinAdapter(finder, this.m_type));
            this.m_storer.fillData(fill);
            this.setDataSource(new SimpleBinnerDataSourceAdapter(finder, this.m_type));
            this.setFillable(fill);
            this.m_storer = null;
            this.m_thresholdReached = true;
        }
    }

    @Override
    public int getNumberOfBins() {
        return this.m_defaultBins;
    }

    @Override
    public double getMin() {
        if (!this.m_autoRange || this.m_thresholdReached) {
            return this.m_min;
        }
        return this.m_stats.getMin();
    }

    @Override
    public double getMax() {
        if (!this.m_autoRange || this.m_thresholdReached) {
            return this.m_max;
        }
        return this.m_stats.getMax();
    }

    @Override
    public Statistics getStatistics() {
        if (this.m_autoRange || this.m_thresholdReached) {
            return this.m_stats.getStatistics();
        }
        OneDStatisticsProvider stats = new OneDStatisticsProvider();
        this.m_storer.fillData(stats);
        return stats.getStatistics();
    }

    @Override
    public boolean isRebinnable() {
        return !this.m_thresholdReached;
    }

    @Override
    public Partition makeCopy() {
        if (this.m_autoRange) {
            return new AutoPartition(this.m_autoCutoff, this.m_defaultBins);
        }
        return new AutoPartition(this.m_autoCutoff, this.m_defaultBins, this.m_min, this.m_max);
    }
}

