/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis;

import hepjas.analysis.AbstractNamedObject;
import hepjas.analysis.Folder;
import hepjas.analysis.HistogramFolder;
import hepjas.analysis.Partition;
import hepjas.analysis.Style;
import hepjas.analysis.partition.Statistics;
import hepjas.analysis.peer.HistogramPeer;
import hepjas.analysis.peer.Peer;
import java.util.Date;

public class Histogram
extends AbstractNamedObject {
    static final long serialVersionUID = -4631743296197770819L;
    private transient HistogramPeer m_peer;
    protected Partition m_partition;
    private Style style;
    private boolean clearOnRewind = true;
    transient Histogram m_nextGuess;

    public Histogram(String name) {
        this(name, HistogramFolder.getDefaultFolder());
    }

    public Histogram(String name, HistogramFolder parent) {
        this(name, parent, parent.getDefaultPartition().makeCopy());
    }

    public Histogram(String name, Partition partition) {
        this(name, HistogramFolder.getDefaultFolder(), partition);
    }

    public Histogram(String name, HistogramFolder parent, Partition partition) {
        super(name, parent);
        this.setPartition(partition);
    }

    public void fill(double x) {
        this.m_partition.fill(x);
    }

    public void fillW(double x, double value) {
        this.m_partition.fillW(x, value);
    }

    public void fill(int x) {
        this.m_partition.fill(x);
    }

    public void fillW(int x, double value) {
        this.m_partition.fillW(x, value);
    }

    public void fill(String x) {
        this.m_partition.fill(x);
    }

    public void fillW(String x, double value) {
        this.m_partition.fillW(x, value);
    }

    public void fill(Date x) {
        this.m_partition.fill(x);
    }

    public void fillW(Date x, double value) {
        this.m_partition.fillW(x, value);
    }

    public void fill(double x, double y) {
        this.m_partition.fill(x, y);
    }

    public void fillW(double x, double y, double weight) {
        this.m_partition.fillW(x, y, weight);
    }

    public void fill(Date x, double y) {
        this.m_partition.fill(x, y);
    }

    public void fillW(Date x, double y, double weight) {
        this.m_partition.fillW(x, y, weight);
    }

    public void show() {
        if (this.m_peer != null) {
            this.m_peer.show();
        }
    }

    public void clear() {
        this.m_partition.clear();
    }

    public int getEntries() {
        Statistics stats = this.m_partition.getStatistics();
        return stats == null ? 0 : (int)stats.getStatistic("entries", 0.0);
    }

    public void setPartition(Partition p) {
        p.setOwner(this);
        if (this.style != null) {
            p.setStyle(this.style);
        }
        this.m_partition = p;
        if (this.m_peer != null) {
            this.m_peer.partitionNotify();
        }
    }

    public void partitionDestroyedNotify() {
        this.m_partition = null;
    }

    public Partition getPartition() {
        return this.m_partition;
    }

    public static Histogram find(String name) {
        return Histogram.find(name, HistogramFolder.getDefaultFolder());
    }

    public static Histogram find(String name, HistogramFolder parent) {
        Histogram result = (Histogram)parent.find(name);
        if (result == null) {
            result = new Histogram(name, parent);
        }
        return result;
    }

    @Override
    Peer getPeer() {
        return this.m_peer;
    }

    @Override
    void setPeer(Peer peer) {
        this.m_peer = (HistogramPeer)peer;
        if (this.m_partition != null) {
            this.m_peer.partitionNotify();
        }
    }

    public String toString() {
        return "Histogram: " + this.getName() + " (entries=" + this.getEntries() + ")";
    }

    public void setStyle(Style style) {
        this.style = style;
        style.setContainer(((HistogramFolder)this.m_parent).getStyleContainer());
        this.m_partition.setStyle(style);
    }

    public Style getStyle() {
        return this.style;
    }

    @Override
    protected Folder getDefaultParent() {
        return HistogramFolder.getDefaultFolder();
    }

    public boolean isClearOnRewind() {
        return this.clearOnRewind;
    }

    public void setClearOnRewind(boolean value) {
        this.clearOnRewind = value;
    }

    void rewind() {
        if (this.clearOnRewind) {
            this.clear();
        }
    }
}

