/*
 * Decompiled with CFR 0.152.
 */
package hepjas.analysis;

import hepjas.analysis.AbstractNamedObject;
import hepjas.analysis.NamedObject;
import hepjas.analysis.peer.FolderPeer;
import hepjas.analysis.peer.Peer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Folder
extends AbstractNamedObject {
    static final long serialVersionUID = -6146292214168028168L;
    private Hashtable m_hash = new Hashtable();
    private transient FolderPeer m_peer;

    Folder(String name) {
        super(name);
    }

    Folder(Folder parent, String name) {
        super(name, parent);
    }

    protected void add(NamedObject child) {
        NamedObject old = (NamedObject)this.m_hash.get(child.getName());
        if (old != null) {
            old.delete();
        }
        this.m_hash.put(child.getName(), child);
        if (this.m_peer != null) {
            this.m_peer.addNotify(child);
        }
    }

    protected void remove(NamedObject child) {
        this.m_hash.remove(child.getName());
        if (this.m_peer != null) {
            this.m_peer.removeNotify(child);
        }
    }

    protected void rename(NamedObject child, String oldName) {
        this.m_hash.remove(oldName);
        this.m_hash.put(child.getName(), child);
        if (this.m_peer != null) {
            this.m_peer.changeNotify(child, oldName);
        }
    }

    public NamedObject find(String name) {
        return (NamedObject)this.m_hash.get(name);
    }

    public Folder findSubfolder(String name) {
        try {
            return (Folder)this.m_hash.get(name);
        }
        catch (ClassCastException x) {
            return null;
        }
    }

    public Enumeration getChildren() {
        return this.m_hash.elements();
    }

    @Override
    Peer getPeer() {
        return this.m_peer;
    }

    @Override
    void setPeer(Peer peer) {
        this.m_peer = (FolderPeer)peer;
        if (this.m_hash != null) {
            Enumeration e = this.m_hash.elements();
            while (e.hasMoreElements()) {
                this.m_peer.addNotify((NamedObject)e.nextElement());
            }
        }
    }

    void dump(PrintWriter out, String indent) {
        if (this.m_hash.isEmpty()) {
            return;
        }
        out.println(indent + this.toString());
        Enumeration e = this.m_hash.elements();
        indent = indent + "   ";
        while (e.hasMoreElements()) {
            NamedObject n = (NamedObject)e.nextElement();
            if (n instanceof Folder) {
                ((Folder)n).dump(out, indent);
                continue;
            }
            out.println(indent + n.toString());
        }
    }

    public String toString() {
        return "Folder: " + this.getName();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        Enumeration e = this.m_hash.elements();
        while (e.hasMoreElements()) {
            AbstractNamedObject o = (AbstractNamedObject)e.nextElement();
            o.m_parent = this;
        }
    }
}

