/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.util;

import hep.rootio.interfaces.RootObject;
import hep.rootio.interfaces.TKey;
import hep.rootio.interfaces.TNamed;
import hep.rootio.util.BranchEntry;
import hep.rootio.util.RootObjectTreeCellRenderer;
import hep.rootio.util.RootObjectTreeModel;
import hep.rootio.util.StreamerInfoTreeCellRenderer;
import hep.rootio.util.StreamerInfoTreeModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class StreamerInfoBrowser
extends JPanel
implements TreeSelectionListener {
    private static final TreeModel emptyTree = null;
    private JTree tree;
    private JTree objTree;

    public StreamerInfoBrowser(List streamerInfo) {
        super(new BorderLayout());
        this.tree = new JTree(new StreamerInfoTreeModel(streamerInfo));
        this.tree.setCellRenderer(new StreamerInfoTreeCellRenderer());
        this.tree.addTreeSelectionListener(this);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.objTree = new JTree(emptyTree);
        this.objTree.setCellRenderer(new RootObjectTreeCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this.objTree);
        JSplitPane split = new JSplitPane(1, new JScrollPane(this.tree), new JScrollPane(this.objTree));
        this.add((Component)split, "Center");
        this.setPreferredSize(new Dimension(500, 300));
        split.setDividerLocation(245);
        ToolTipManager.sharedInstance().setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(TreeSelectionEvent event) {
        Cursor old = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            TreePath path = this.tree.getSelectionPath();
            if (path == null) {
                this.objTree.setModel(emptyTree);
            } else {
                Object node = path.getLastPathComponent();
                if (node instanceof BranchEntry) {
                    node = ((BranchEntry)node).getValue();
                }
                if (node instanceof TKey) {
                    TKey key = (TKey)node;
                    this.objTree.setModel(new RootObjectTreeModel(key.getObject(), key.getName()));
                } else if (node instanceof TNamed) {
                    this.objTree.setModel(new RootObjectTreeModel(node, ((TNamed)node).getName()));
                } else if (node instanceof RootObject) {
                    this.objTree.setModel(new RootObjectTreeModel(node, ""));
                } else if (node.getClass().isArray()) {
                    this.objTree.setModel(new RootObjectTreeModel(node, ""));
                } else if (node instanceof List) {
                    this.objTree.setModel(new RootObjectTreeModel(node, ""));
                } else {
                    this.objTree.setModel(emptyTree);
                }
            }
        }
        catch (IOException x) {
            this.objTree.setModel(emptyTree);
            x.printStackTrace();
            this.error(x);
        }
        finally {
            this.setCursor(old);
        }
    }

    private void error(IOException x) {
        JOptionPane.showMessageDialog(this, x.getMessage(), "Error", 0);
    }
}

