/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.util;

import hep.rootio.RootClass;
import hep.rootio.RootMember;
import hep.rootio.interfaces.RootObject;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;

public class RootObjectTreeModel
extends DefaultTreeModel {
    public RootObjectTreeModel(Object top, String name) {
        super(RootObjectTreeNode.getNodeForValue(null, top, name, 0));
    }

    protected RootObjectTreeModel(TreeNode node) {
        super(node);
    }

    protected static TreeNode getNodeForChild(TreeNode parent, Object child, String name, int index) {
        return RootObjectTreeNode.getNodeForValue(parent, child, name, index);
    }

    protected static int getIndex(TreeNode child) {
        return ((RootObjectTreeNode)child).index;
    }

    static abstract class RootObjectTreeNode
    implements TreeNode {
        private TreeNode parent;
        private int index;
        private String tooltip;

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode child) {
            return ((RootObjectTreeNode)child).index;
        }

        public Enumeration children() {
            return new Enumeration(){
                private int n;
                private int i;
                {
                    this.n = this.getChildCount();
                    this.i = 0;
                }

                @Override
                public boolean hasMoreElements() {
                    return this.i < this.n;
                }

                public Object nextElement() {
                    return this.getChildAt(this.i++);
                }
            };
        }

        static RootObjectTreeNode getNodeForValue(TreeNode parent, Object value, String name, int index) {
            if (value == null) {
                return new RootSimpleValue(parent, "null", name, index);
            }
            if (value instanceof RootObject) {
                return new RootObjectNode(parent, (RootObject)value, name, index);
            }
            if (value instanceof List) {
                return new RootListNode(parent, (List)value, name, index);
            }
            if (value.getClass().isArray()) {
                return new RootArrayNode(parent, value, name, index);
            }
            return new RootSimpleValue(parent, value, name, index);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public TreeNode getChildAt(int p1) {
            throw new InternalError("getChildAt() called");
        }

        public String toString() {
            return this.description();
        }

        void setToolTip(String value) {
            this.tooltip = value;
        }

        String toolTip() {
            return this.tooltip;
        }

        abstract String description();

        RootObjectTreeNode(TreeNode parent, int index) {
            this.parent = parent;
            this.index = index;
        }
    }

    static class RootSubObject
    extends RootObjectTreeNode {
        private RootObject obj;
        private RootClass klass;

        @Override
        public int getChildCount() {
            int n = this.klass.getSuperClasses().length;
            return n += this.klass.getMembers().length;
        }

        @Override
        public TreeNode getChildAt(int index) {
            RootClass[] superClasses = this.klass.getSuperClasses();
            if (index < superClasses.length) {
                return new RootSubObject(this, this.obj, superClasses[index], index);
            }
            RootMember member = this.klass.getMembers()[index - superClasses.length];
            Object value = this.obj.getValue(member.getName());
            RootObjectTreeNode node = RootObjectTreeNode.getNodeForValue(this, value, member.getName(), index);
            node.setToolTip(member.getComment());
            return node;
        }

        @Override
        String description() {
            return "Class " + this.klass.getClassName();
        }

        RootSubObject(TreeNode parent, RootObject obj, RootClass klass, int index) {
            super(parent, index);
            this.obj = obj;
            this.klass = klass;
        }
    }

    static class RootSimpleValue
    extends RootObjectTreeNode {
        private Object value;
        private String name;

        @Override
        public boolean isLeaf() {
            return true;
        }

        @Override
        String description() {
            return this.name + " = " + this.value;
        }

        RootSimpleValue(TreeNode parent, Object value, String name, int index) {
            super(parent, index);
            this.value = value;
            this.name = name;
        }
    }

    static class RootObjectNode
    extends RootSubObject {
        private String name;

        @Override
        String description() {
            return this.name + " (" + super.description() + ")";
        }

        RootObjectNode(TreeNode parent, RootObject obj, String name, int index) {
            super(parent, obj, obj.rootClass(), index);
            this.name = name;
        }
    }

    static class RootListNode
    extends RootObjectTreeNode {
        private List list;
        private String name;

        @Override
        public int getChildCount() {
            return this.list.size();
        }

        @Override
        public TreeNode getChildAt(int index) {
            return RootObjectTreeNode.getNodeForValue(this, this.list.get(index), "[" + index + "]", index);
        }

        @Override
        String description() {
            return this.name + " (List)";
        }

        RootListNode(TreeNode parent, List list, String name, int index) {
            super(parent, index);
            this.list = list;
            this.name = name;
        }
    }

    static class RootArrayNode
    extends RootObjectTreeNode {
        private Object array;
        private String name;

        @Override
        public int getChildCount() {
            return Array.getLength(this.array);
        }

        @Override
        public TreeNode getChildAt(int index) {
            return RootObjectTreeNode.getNodeForValue(this, Array.get(this.array, index), "[" + index + "]", index);
        }

        @Override
        String description() {
            return this.name + " (Array)";
        }

        RootArrayNode(TreeNode parent, Object array, String name, int index) {
            super(parent, index);
            this.array = array;
            this.name = name;
        }
    }
}

