/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.util;

import hep.rootio.RootFileReader;
import hep.rootio.interfaces.RootObject;
import hep.rootio.interfaces.TKey;
import hep.rootio.interfaces.TNamed;
import hep.rootio.util.BranchEntry;
import hep.rootio.util.HackedFileSystemView;
import hep.rootio.util.RootDirectoryTreeCellRenderer;
import hep.rootio.util.RootDirectoryTreeModel;
import hep.rootio.util.RootObjectTreeCellRenderer;
import hep.rootio.util.RootObjectTreeModel;
import hep.rootio.util.StreamerInfoBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class RootObjectBrowser
extends JPanel
implements TreeSelectionListener {
    private static final String aboutMessage = "<HTML>RootObjectBrowser $Id: RootObjectBrowser.java,v 1.10 2001/06/04 16:17:53 tonyj Exp $<br>Author: Tony Johnson (tonyj@slac.stanford.edu)";
    private static final TreeModel emptyTree = null;
    private JTree tree = new JTree(emptyTree);
    private JTree objTree;
    private RootFileReader reader;
    private RootMenuBar menuBar;

    public RootObjectBrowser() {
        super(new BorderLayout());
        this.tree.setCellRenderer(new RootDirectoryTreeCellRenderer());
        this.tree.addTreeSelectionListener(this);
        this.objTree = new JTree(emptyTree);
        this.objTree.setCellRenderer(new RootObjectTreeCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this.objTree);
        JSplitPane split = new JSplitPane(1, new JScrollPane(this.tree), new JScrollPane(this.objTree));
        this.add((Component)split, "Center");
        this.menuBar = new RootMenuBar();
        this.add((Component)this.menuBar, "North");
        this.menuBar.setFileOpen(false);
        this.setPreferredSize(new Dimension(500, 300));
        split.setDividerLocation(245);
        ToolTipManager.sharedInstance().setEnabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootFile(File file) throws IOException {
        Cursor old = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.reader = new RootFileReader(file);
            RootDirectoryTreeModel model = new RootDirectoryTreeModel(this.reader){

                @Override
                public void handleException(IOException x) {
                    RootObjectBrowser.this.error(x);
                    x.printStackTrace();
                    super.handleException(x);
                }
            };
            this.tree.setModel(model);
            this.tree.setRowHeight(20);
            this.tree.setLargeModel(true);
            this.menuBar.setFileOpen(true);
        }
        finally {
            this.setCursor(old);
        }
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length > 1) {
            RootObjectBrowser.usage();
        }
        if (argv.length == 1 && argv[0].startsWith("-")) {
            RootObjectBrowser.usage();
        }
        JFrame frame = new JFrame("Root Object Browser");
        RootObjectBrowser browser = new RootObjectBrowser();
        if (argv.length == 1) {
            browser.setRootFile(new File(argv[0]));
        }
        frame.setContentPane(browser);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.show();
    }

    private static void usage() {
        System.out.println("java RootObjectBrowser [<file>]");
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(TreeSelectionEvent event) {
        Cursor old = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            TreePath path = this.tree.getSelectionPath();
            if (path == null) {
                this.objTree.setModel(emptyTree);
            } else {
                Object node = path.getLastPathComponent();
                if (node instanceof BranchEntry) {
                    node = ((BranchEntry)node).getValue();
                }
                if (node instanceof TKey) {
                    TKey key = (TKey)node;
                    this.objTree.setModel(new RootObjectTreeModel(key.getObject(), key.getName()));
                } else if (node instanceof TNamed) {
                    this.objTree.setModel(new RootObjectTreeModel(node, ((TNamed)node).getName()));
                } else if (node instanceof RootObject) {
                    this.objTree.setModel(new RootObjectTreeModel(node, ""));
                } else if (node.getClass().isArray()) {
                    this.objTree.setModel(new RootObjectTreeModel(node, ""));
                } else if (node instanceof List) {
                    this.objTree.setModel(new RootObjectTreeModel(node, ""));
                } else {
                    this.objTree.setModel(emptyTree);
                }
            }
        }
        catch (IOException x) {
            this.objTree.setModel(emptyTree);
            x.printStackTrace();
            this.error(x);
        }
        finally {
            this.setCursor(old);
        }
    }

    private void error(IOException x) {
        JOptionPane.showMessageDialog(this, x.getMessage(), "Error", 0);
    }

    private void showStreamerInfo() {
        try {
            Comparator sortByName = new Comparator(){

                public int compare(Object a, Object b) {
                    return ((TNamed)a).getName().compareTo(((TNamed)b).getName());
                }

                @Override
                public boolean equals(Object o) {
                    return o.getClass() == this.getClass();
                }
            };
            ArrayList streamerInfo = new ArrayList(this.reader.streamerInfo());
            Collections.sort(streamerInfo, sortByName);
            StreamerInfoBrowser browser = new StreamerInfoBrowser(streamerInfo);
            JFrame f = new JFrame("Root Streamer Info Browser");
            f.setContentPane(browser);
            f.setDefaultCloseOperation(2);
            f.pack();
            f.show();
        }
        catch (IOException x) {
            this.error(x);
        }
    }

    private class RootMenuBar
    extends JMenuBar {
        private RootToolsMenu tools;

        void setFileOpen(boolean state) {
            this.tools.setFileOpen(state);
        }

        RootMenuBar() {
            this.add(new RootFileMenu());
            this.tools = new RootToolsMenu();
            this.add(this.tools);
            this.add(new RootHelpMenu());
        }
    }

    private class RootFileMenu
    extends JMenu {
        RootFileMenu() {
            super("File");
            this.add(new JMenuItem("Open..."){

                @Override
                public void fireActionPerformed(ActionEvent e) {
                    JFileChooser dlg = null;
                    try {
                        if (System.getSecurityManager() != null && System.getProperty("os.name").indexOf("indows") > 0 && System.getProperty("java.version").startsWith("1.3")) {
                            dlg = new JFileChooser("Open Root File...", (FileSystemView)new HackedFileSystemView());
                        }
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    if (dlg == null) {
                        dlg = new JFileChooser("Open Root File...");
                    }
                    dlg.setFileFilter(new RootFileFilter());
                    int rc = dlg.showOpenDialog(RootObjectBrowser.this);
                    if (rc == 0) {
                        try {
                            RootObjectBrowser.this.setRootFile(dlg.getSelectedFile());
                        }
                        catch (IOException x) {
                            RootObjectBrowser.this.error(x);
                        }
                    }
                }
            });
            this.add(new JMenuItem("Exit"){

                @Override
                public void fireActionPerformed(ActionEvent e) {
                    System.exit(0);
                }
            });
        }
    }

    private class RootToolsMenu
    extends JMenu {
        private JMenuItem view;

        void setFileOpen(boolean state) {
            this.view.setEnabled(state);
        }

        RootToolsMenu() {
            super("Tools");
            this.view = new JMenuItem("View Streamer Info..."){

                @Override
                public void fireActionPerformed(ActionEvent e) {
                    RootObjectBrowser.this.showStreamerInfo();
                }
            };
            this.add(this.view);
        }
    }

    private class RootHelpMenu
    extends JMenu {
        RootHelpMenu() {
            super("Help");
            this.add(new JMenuItem("About..."){

                @Override
                public void fireActionPerformed(ActionEvent e) {
                    JOptionPane.showMessageDialog(RootObjectBrowser.this, RootObjectBrowser.aboutMessage);
                }
            });
        }
    }

    private static class RootFileFilter
    extends FileFilter {
        @Override
        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".root");
        }

        @Override
        public String getDescription() {
            return "Root Files (*.root)";
        }

        private RootFileFilter() {
        }
    }
}

