/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.util;

import hep.rootio.RootClass;
import hep.rootio.interfaces.TBranch;
import hep.rootio.interfaces.TBranchClones;
import hep.rootio.interfaces.TBranchObject;
import hep.rootio.interfaces.TKey;
import hep.rootio.interfaces.TNamed;
import java.awt.Component;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class RootDirectoryTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final Icon h1Icon = new ImageIcon(RootDirectoryTreeCellRenderer.class.getResource("images/h1_t.gif"));
    private static final Icon h2Icon = new ImageIcon(RootDirectoryTreeCellRenderer.class.getResource("images/h2_t.gif"));
    private static final Icon h3Icon = new ImageIcon(RootDirectoryTreeCellRenderer.class.getResource("images/h3_t.gif"));
    private static final Icon rootdbIcon = new ImageIcon(RootDirectoryTreeCellRenderer.class.getResource("images/rootdb_t.gif"));
    private static final Icon treeIcon = new ImageIcon(RootDirectoryTreeCellRenderer.class.getResource("images/tree_t.gif"));
    private static final Icon branchIcon = new ImageIcon(RootDirectoryTreeCellRenderer.class.getResource("images/branch_t.gif"));
    private static final Icon branchObIcon = new ImageIcon(RootDirectoryTreeCellRenderer.class.getResource("images/branch-ob_t.gif"));
    private static final Icon branchClIcon = new ImageIcon(RootDirectoryTreeCellRenderer.class.getResource("images/branch-cl_t.gif"));

    @Override
    public Component getTreeCellRendererComponent(JTree p1, Object p2, boolean p3, boolean p4, boolean p5, int p6, boolean p7) {
        super.getTreeCellRendererComponent(p1, p2, p3, p4, p5, p6, p7);
        if (p2 instanceof TNamed) {
            TNamed named = (TNamed)p2;
            this.setText(named.getTitle() + " (" + named.getName() + ")");
        }
        if (p2 instanceof TBranchObject) {
            this.setIcon(branchObIcon);
        } else if (p2 instanceof TBranchClones) {
            this.setIcon(branchClIcon);
        } else if (p2 instanceof TBranch) {
            this.setIcon(branchIcon);
        } else if (p2 instanceof TKey) {
            try {
                RootClass rc = ((TKey)p2).getObjectClass();
                if (rc.instanceOf("TTree")) {
                    this.setIcon(treeIcon);
                } else if (rc.instanceOf("TH2")) {
                    this.setIcon(h2Icon);
                } else if (rc.instanceOf("TH3")) {
                    this.setIcon(h3Icon);
                } else if (rc.instanceOf("TH1")) {
                    this.setIcon(h1Icon);
                } else if (rc.instanceOf("TFile")) {
                    this.setIcon(rootdbIcon);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this;
    }

    static Class _mthclass$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

