/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.reps;

import hep.rootio.RootClass;
import hep.rootio.RootClassNotFound;
import hep.rootio.RootInput;
import hep.rootio.RootObjectRepresentation;
import hep.rootio.implementation.RootByteArrayInputStream;
import hep.rootio.implementation.RootInputStream;
import hep.rootio.implementation.RootRandomAccessFile;
import hep.rootio.implementation.SpecificRootObject;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.zip.Inflater;

public class TKey
extends SpecificRootObject {
    private int fNbytes;
    private int fObjlen;
    private int fKeylen;
    private int fSeekKey;
    private SoftReference soft;
    private RootObjectRepresentation object;
    private RootRandomAccessFile raf;

    @Override
    public void read(RootInput in) throws IOException {
        this.fNbytes = in.readInt();
        this.put("fNbytes", this.fNbytes);
        int v = in.readVersion();
        this.fObjlen = in.readInt();
        this.put("fObjlen", this.fObjlen);
        this.put("fDatime", in.readObject("TDatime"));
        short s = in.readShort();
        this.fKeylen = s;
        this.put("fKeylen", (int)s);
        this.put("fCycle", in.readShort());
        this.fSeekKey = in.readInt();
        this.put("fSeekKey", this.fSeekKey);
        this.put("fSeekPdir", in.readInt());
        this.put("fClassName", in.readObject("TString"));
        this.put("fName", in.readObject("TString"));
        this.put("fTitle", in.readObject("TString"));
        this.raf = in.getRAF();
    }

    public RootObjectRepresentation getObject() throws RootClassNotFound, IOException {
        RootObjectRepresentation rootObjectRepresentation = this.object = this.soft != null ? (RootObjectRepresentation)this.soft.get() : null;
        if (this.object == null) {
            this.object = this.createObject(this.getObjectClass());
            this.raf.seek(this.fSeekKey + this.fKeylen);
            if (this.fObjlen > this.fNbytes - this.fKeylen) {
                RootInputStream in = this.getData();
                this.object.read(in);
            } else {
                this.raf.setMap(this.fKeylen);
                this.object.read(this.raf);
                this.raf.clearMap();
            }
            this.soft = new SoftReference<RootObjectRepresentation>(this.object);
        }
        return this.object;
    }

    RootInputStream getData() throws IOException {
        byte[] buf = new byte[this.fNbytes - this.fKeylen];
        int rc = this.raf.read(buf);
        if (rc != buf.length) {
            throw new IOException("Unexpected buffer length, expected " + buf.length + " got " + rc);
        }
        if (rc < this.fObjlen) {
            byte[] out = new byte[this.fObjlen];
            int nout = 0;
            int nin = 0;
            while (nout < this.fObjlen) {
                Inflater inf = new Inflater(true);
                try {
                    inf.setInput(buf, nin += 9, buf.length - nin);
                    rc = inf.inflate(out, nout, out.length - nout);
                    nout += rc;
                    nin += inf.getTotalIn();
                }
                catch (Exception exception) {
                    throw new IOException("Error during decompression");
                }
                finally {
                    inf.end();
                }
            }
            return new RootInputStream(new RootByteArrayInputStream(out, this.fKeylen), this.raf);
        }
        return new RootInputStream(new RootByteArrayInputStream(buf, this.fKeylen), this.raf);
    }

    private RootObjectRepresentation createObject(RootClass k) throws RootClassNotFound {
        return k.newInstance();
    }

    public int seekKey() {
        return this.fSeekKey;
    }

    public int keyLen() {
        return this.fKeylen;
    }

    public RootClass getObjectClass() throws RootClassNotFound {
        return this.raf.getFactory().create(this.get("fClassName").toString());
    }

    public String getName() {
        return this.get("fName").toString();
    }

    public String getTitle() {
        return this.get("fTitle").toString();
    }
}

