/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.reps;

import hep.rootio.RootInput;
import hep.rootio.implementation.RootRandomAccessFile;
import hep.rootio.implementation.SpecificRootObject;
import hep.rootio.reps.TKey;
import java.io.IOException;
import java.util.Hashtable;

public class TDirectory
extends SpecificRootObject {
    private Hashtable hash = new Hashtable();
    private Hashtable hashT = new Hashtable();
    private TKey[] keys;
    private TKey header;
    private RootRandomAccessFile raf;

    @Override
    public void read(RootInput in) throws IOException {
        int v = in.readVersion();
        this.put("fDatimeC", in.readObject("TDatime"));
        this.put("fDatimeM", in.readObject("TDatime"));
        this.put("fNbytesKeys", in.readInt());
        this.put("fNbytesName", in.readInt());
        this.put("fSeekDir", in.readInt());
        this.put("fSeekParent", in.readInt());
        int fSeekKeys = in.readInt();
        this.put("fSeekKeys", fSeekKeys);
        ((RootRandomAccessFile)in).seek(fSeekKeys);
        this.header = (TKey)in.readObject("TKey");
        this.put("fHeader", this.header);
        int nKeys = in.readInt();
        this.put("fNkeys", nKeys);
        this.keys = new TKey[nKeys];
        for (int i = 0; i < nKeys; ++i) {
            this.keys[i] = (TKey)in.readObject("TKey");
            this.hash.put(this.keys[i].getName(), this.keys[i]);
            this.hashT.put(this.keys[i].getTitle(), this.keys[i]);
        }
        this.put("fKeys", this.keys);
    }

    public int nKeys() {
        return this.keys.length;
    }

    public TKey getKey(int index) {
        return this.keys[index];
    }

    public TKey getKey(String name) {
        TKey key = (TKey)this.hash.get(name);
        if (key != null) {
            return key;
        }
        throw new RuntimeException("Key " + name + " not found in " + this.header.getName());
    }

    public TKey getKeyForTitle(String title) {
        TKey key = (TKey)this.hashT.get(title);
        if (key != null) {
            return key;
        }
        throw new RuntimeException("Key titled " + title + " not found in " + this.header.getTitle());
    }
}

