/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.reps;

import hep.rootio.NameMangler;
import hep.rootio.RootClass;
import hep.rootio.RootClassFactory;
import hep.rootio.RootClassNotFound;
import hep.rootio.RootInput;
import hep.rootio.RootObjectRepresentation;
import hep.rootio.implementation.HollowRootObject;
import hep.rootio.implementation.SpecificRootObject;
import hep.rootio.interfaces.TClonesArray;
import hep.rootio.reps.TBranch;
import hep.rootio.reps.TObjArray;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Hashtable;

public class TBranchClones
extends SpecificRootObject {
    private RootClass objectClass;
    private TBranch count;
    private Hashtable map;
    private Hashtable mangledMap;
    private static final NameMangler nameMangler = NameMangler.instance();

    @Override
    public void readMembers(RootInput in, int v) throws IOException {
        super.readMembers(in, v);
        this.count = (TBranch)this.get("fBranchCount");
        try {
            RootClassFactory cf = in.getFactory();
            this.objectClass = cf.create(this.get("fClassName").toString());
        }
        catch (RootClassNotFound x) {
            throw new IOException("Could not find BranchClones class " + x.getClassName());
        }
    }

    public int getNEntries() {
        return ((Number)this.get("fEntries")).intValue();
    }

    public Object getEntry(int index) throws IOException {
        int l = (Integer)this.count.getEntry(index);
        return new HollowArray(l, index, this.objectClass, this);
    }

    public RootObjectRepresentation getBranchForName(String name) {
        if (this.map == null) {
            this.buildMap();
        }
        return (RootObjectRepresentation)this.map.get(name);
    }

    public RootObjectRepresentation getBranchForMangledName(String name) {
        if (this.map == null) {
            this.buildMap();
        }
        return (RootObjectRepresentation)this.mangledMap.get(name);
    }

    private void buildMap() {
        this.map = new Hashtable();
        this.mangledMap = new Hashtable();
        TObjArray branches = (TObjArray)this.get("fBranches");
        int size = branches.size();
        for (int i = 0; i < size; ++i) {
            RootObjectRepresentation b = branches.elementAt(i);
            String bName = b.get("fName").toString();
            int pos = bName.indexOf(91);
            if (pos > 0) {
                bName = bName.substring(0, pos);
            }
            if ((pos = bName.indexOf(46)) > 0) {
                bName = bName.substring(pos + 1);
            }
            this.map.put(bName, b);
            this.mangledMap.put(nameMangler.mangleMember(bName), b);
        }
    }

    static class HollowArray
    extends AbstractList
    implements TClonesArray {
        private int size;
        private int hollowIndex;
        private RootClass objectClass;
        private TBranchClones branch;

        @Override
        public int size() {
            return this.size;
        }

        public Object get(int cloneIndex) {
            HollowRootObject ho = (HollowRootObject)this.objectClass.newInstance();
            ho.setHollow((hep.rootio.interfaces.TBranch)this.branch.getProxy());
            ho.setHollowIndex(this.hollowIndex);
            ho.setCloneIndex(cloneIndex);
            return ho.getProxy();
        }

        @Override
        public int getLowerBound() {
            return 0;
        }

        @Override
        public int getUpperBound() {
            return this.size - 1;
        }

        @Override
        public Object getElementAt(int index) {
            return this.get(index);
        }

        HollowArray(int size, int hollowIndex, RootClass objectClass, TBranchClones branch) {
            this.size = size;
            this.objectClass = objectClass;
            this.hollowIndex = hollowIndex;
            this.branch = branch;
        }
    }
}

