/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.reps;

import hep.rootio.RootInput;
import hep.rootio.RootObjectRepresentation;
import hep.rootio.implementation.Leaf;
import hep.rootio.implementation.RootByteArrayInputStream;
import hep.rootio.implementation.RootInputStream;
import hep.rootio.implementation.SpecificRootObject;
import hep.rootio.reps.TKey;
import java.io.IOException;

public class TBasket
extends SpecificRootObject {
    private int curIndex = -2;
    private Object curValue = null;
    private RootInputStream data;
    private int fKeylen;
    private int fNevBufSize;
    private int[] fEntryOffset;
    static final int kDisplacementMask = -16777216;

    @Override
    public void read(RootInput in) throws IOException {
        RootObjectRepresentation[] superClasses = this.getSuperClasses();
        TKey key = (TKey)superClasses[0];
        key.read(in);
        int v = in.readVersion(this);
        this.readMembers(in, v);
        in.checkLength(this);
        this.fKeylen = (Integer)this.get("fKeylen");
        if (this.data == null) {
            this.data = key.getData();
        }
    }

    void readEntryOffsets(int len) throws IOException {
        int last = (Integer)this.get("fLast");
        this.data.setPosition(last);
        this.fEntryOffset = new int[len];
        this.data.readArray(this.fEntryOffset);
        this.put("fEntryOffset", this.fEntryOffset);
    }

    @Override
    public void readMembers(RootInput in, int v) throws IOException {
        int i;
        int l;
        int i2;
        int fBufferSize = in.readInt();
        this.fNevBufSize = in.readInt();
        this.put("fNevBufSize", this.fNevBufSize);
        int fNevBuf = in.readInt();
        this.put("fNevBuf", fNevBuf);
        int fLast = in.readInt();
        this.put("fLast", fLast);
        if (fLast > fBufferSize) {
            fBufferSize = fLast;
        }
        this.put("fBufferSize", fBufferSize);
        byte flag = in.readByte();
        if (flag == 0) {
            return;
        }
        if (flag % 10 != 2) {
            this.fEntryOffset = new int[this.fNevBufSize];
            if (fNevBuf != 0) {
                int l2 = in.readInt();
                for (i2 = 0; i2 < l2; ++i2) {
                    this.fEntryOffset[i2] = in.readInt();
                }
            }
            if (20 < flag && flag < 40) {
                int i3 = 0;
                while (i3 < fNevBuf) {
                    int n = i3++;
                    this.fEntryOffset[n] = this.fEntryOffset[n] & 0xFFFFFF;
                }
            }
            this.put("fEntryOffset", this.fEntryOffset);
            if (flag > 40) {
                int[] fDisplacement = new int[this.fNevBufSize];
                l = in.readInt();
                for (i = 0; i < l; ++i) {
                    fDisplacement[i] = in.readInt();
                }
                this.put("fDisplacement", fDisplacement);
            }
        }
        if (flag == 1 || flag > 10) {
            byte[] buf = new byte[fBufferSize];
            if (v > 1) {
                for (i2 = 0; i2 < fLast; ++i2) {
                    buf[i2] = in.readByte();
                }
            } else {
                l = in.readInt();
                for (i = 0; i < l; ++i) {
                    buf[i] = in.readByte();
                }
            }
            this.put("fBufferRef", buf);
            this.data = new RootInputStream(new RootByteArrayInputStream(buf, 0), in.getRAF());
        }
    }

    Object getEntry(int index, int offset, Leaf leaf) throws IOException {
        int i = index - offset;
        if (i == this.curIndex) {
            return this.curValue;
        }
        if (i == this.curIndex + 1) {
            ++this.curIndex;
        } else if (this.fEntryOffset == null) {
            this.data.setPosition(this.fKeylen + i * this.fNevBufSize);
            this.curIndex = i;
        } else {
            this.data.setPosition(this.fEntryOffset[i]);
            this.curIndex = i;
        }
        this.curValue = leaf.readData(this.data, index);
        return this.curValue;
    }
}

