/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.implementation;

import hep.rootio.RootFileReader;
import hep.rootio.RootObjectRepresentation;
import hep.rootio.implementation.GenericRootClass;
import hep.rootio.implementation.SpecificRootObject;
import hep.rootio.implementation.StreamerInfo;
import java.lang.reflect.Method;

public class SpecificRootClass
extends GenericRootClass {
    private static final Class[] noArgc = new Class[0];
    private static final Object[] noArgs = new Object[0];
    private Class javaClass;
    private String javaType;

    SpecificRootClass(Class c, String name, StreamerInfo info, RootFileReader rfr) {
        super(name, info, rfr);
        if (!SpecificRootObject.class.isAssignableFrom(c)) {
            throw new RuntimeException("RootClass " + c.getName() + " is not a RootObjectRepresentation");
        }
        this.javaClass = c;
        try {
            Method m = c.getMethod("getJavaType", noArgc);
            if (m.getReturnType() != String.class) {
                throw new RuntimeException("Incorrect return type for getJavaType()");
            }
            if ((m.getModifiers() & 8) == 0) {
                throw new RuntimeException("getJavaType() method should be static");
            }
            this.javaType = (String)m.invoke(null, noArgs);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public RootObjectRepresentation newInstance() {
        try {
            SpecificRootObject rep = (SpecificRootObject)this.javaClass.newInstance();
            rep.init(this, this.streamerInfo);
            return rep;
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not create instance of " + this.javaClass);
        }
    }

    @Override
    public String getJavaType() {
        if (this.javaType != null) {
            return this.javaType;
        }
        return super.getJavaType();
    }
}

