/*
 * Decompiled with CFR 0.152.
 */
package hep.rootio.implementation;

import hep.rootio.NameMangler;
import hep.rootio.RootClass;
import hep.rootio.RootClassFactory;
import hep.rootio.RootClassNotFound;
import hep.rootio.RootFileReader;
import hep.rootio.RootInput;
import hep.rootio.RootMember;
import hep.rootio.RootObjectRepresentation;
import hep.rootio.implementation.GenericRootObject;
import hep.rootio.implementation.StreamerInfo;
import hep.rootio.interfaces.RootObject;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Hashtable;
import java.util.Vector;

public class GenericRootClass
implements RootClass {
    private Constructor proxyConstructor;
    protected StreamerInfo streamerInfo;
    private String name;
    private Hashtable methodMap = new Hashtable();
    private static final NameMangler nameMangler = NameMangler.instance();
    private RootFileReader rfr;

    public GenericRootClass(String name, StreamerInfo info, RootFileReader rfr) {
        this.streamerInfo = info;
        this.name = name;
        this.rfr = rfr;
    }

    @Override
    public void resolve(RootClassFactory factory) throws RootClassNotFound {
        this.streamerInfo.resolve(factory);
    }

    @Override
    public String getClassName() {
        return this.name;
    }

    @Override
    public RootObjectRepresentation newInstance() {
        GenericRootObject gen = new GenericRootObject();
        gen.init(this, this.streamerInfo);
        return gen;
    }

    @Override
    public Object read(RootInput in) throws IOException {
        RootObjectRepresentation obj = this.newInstance();
        obj.read(in);
        return obj;
    }

    @Override
    public RootClass[] getSuperClasses() {
        return this.streamerInfo.getSuperClasses();
    }

    public String toString() {
        return "RootClass: " + this.getClassName();
    }

    @Override
    public boolean instanceOf(RootClass superClass) {
        if (superClass == this) {
            return true;
        }
        RootClass[] classes = this.getSuperClasses();
        for (int i = 0; i < classes.length; ++i) {
            if (!classes[i].instanceOf(superClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public RootMember[] getMembers() {
        return this.streamerInfo.getMembers();
    }

    @Override
    public String getJavaType() {
        return nameMangler.mangleClass(this.name);
    }

    private void addSuperClasses(Vector interFaces, RootClass klass, ClassLoader classLoader) {
        try {
            Class<?> k = Class.forName(klass.getJavaType(), true, classLoader);
            if (interFaces.contains(k)) {
                return;
            }
            if (!k.isInterface() || !RootObject.class.isAssignableFrom(k)) {
                throw new RuntimeException("Invalid proxy class " + k);
            }
            interFaces.add(k);
        }
        catch (ClassNotFoundException k) {
            // empty catch block
        }
        RootClass[] superClasses = klass.getSuperClasses();
        for (int i = 0; i < superClasses.length; ++i) {
            this.addSuperClasses(interFaces, superClasses[i], classLoader);
        }
    }

    public RootObject createProxy(InvocationHandler object) {
        try {
            ClassLoader classLoader = this.rfr.getClassLoader();
            if (this.proxyConstructor == null || this.proxyConstructor.getClass().getClassLoader() != classLoader) {
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                }
                Vector<Class<RootObject>> interFaces = new Vector<Class<RootObject>>();
                interFaces.add(RootObject.class);
                this.addSuperClasses(interFaces, this, classLoader);
                Object[] iClass = new Class[interFaces.size()];
                interFaces.copyInto(iClass);
                Class<?> proxyClass = Proxy.getProxyClass(classLoader, iClass);
                this.proxyConstructor = proxyClass.getConstructor(InvocationHandler.class);
            }
            return (RootObject)this.proxyConstructor.newInstance(object);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Unable to create proxy for " + this.getClassName());
        }
    }

    @Override
    public int getVersion() {
        return this.streamerInfo.getVersion();
    }

    @Override
    public int getCheckSum() {
        return this.streamerInfo.getCheckSum();
    }

    Hashtable getMethodMap() {
        return this.methodMap;
    }

    @Override
    public boolean instanceOf(String className) {
        if (this.name.equals(className)) {
            return true;
        }
        RootClass[] sups = this.getSuperClasses();
        for (int i = 0; i < sups.length; ++i) {
            if (!sups[i].instanceOf(className)) continue;
            return true;
        }
        return false;
    }
}

