/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.math;

import java.util.Arrays;
import jdistlib.math.MathFunctions;

public class Bessel {
    private static final double nsig_BESS = 16.0;
    private static final double ensig_BESS = 1.0E16;
    private static final double rtnsig_BESS = 1.0E-4;
    private static final double enmten_BESS = 8.9E-308;
    private static final double enten_BESS = 1.0E308;
    private static final double exparg_BESS = 709.0;
    private static final double xlrg_BESS_IJ = 100000.0;
    private static final double xlrg_BESS_Y = 1.0E8;
    private static final double thresh_BESS_Y = 16.0;
    private static final double xmax_BESS_K = 705.342;
    private static final double sqxmin_BESS_K = 1.49E-154;
    private static final double M_eps_sinc = 2.149E-8;

    public static final double j(double x, double alpha) {
        if (Double.isNaN(x) || Double.isNaN(alpha)) {
            return x + alpha;
        }
        if (x < 0.0) {
            return Double.NaN;
        }
        int na = (int)Math.floor(alpha);
        if (na < 0) {
            return alpha - (double)na == 0.5 ? 0.0 : Bessel.j(x, -alpha) * MathFunctions.cospi(alpha) + (alpha == (double)na ? 0.0 : Bessel.y(x, -alpha) * MathFunctions.sinpi(alpha));
        }
        int nb = 1 + na;
        double[] by = new double[nb];
        int ncalc = Bessel.j_internal(x, alpha -= (double)(nb - 1), by);
        if (ncalc != nb) {
            if (ncalc < 0) {
                System.err.println(String.format("bessel_j(%g): ncalc (=%ld) != nb (=%ld); alpha=%g. Arg. out of range?", x, ncalc, nb, alpha));
            } else {
                System.err.println(String.format("bessel_j(%g,nu=%g): precision lost in result", x, alpha + (double)nb - 1.0));
            }
        }
        return by[nb - 1];
    }

    public static final double y(double x, double alpha) {
        if (Double.isNaN(x) || Double.isNaN(alpha)) {
            return x + alpha;
        }
        if (x < 0.0) {
            return Double.NaN;
        }
        int na = (int)Math.floor(alpha);
        if (na < 0) {
            return alpha - (double)na == 0.5 ? 0.0 : Bessel.y(x, -alpha) * MathFunctions.cospi(alpha) + (alpha == (double)na ? 0.0 : Bessel.j(x, -alpha) * MathFunctions.sinpi(alpha));
        }
        int nb = 1 + na;
        double[] by = new double[nb];
        int ncalc = Bessel.y_internal(x, alpha -= (double)(nb - 1), by);
        if (ncalc != nb) {
            if (ncalc == -1) {
                return Double.POSITIVE_INFINITY;
            }
            if (ncalc < -1) {
                System.err.println(String.format("bessel_y(%g): ncalc (=%ld) != nb (=%ld); alpha=%g. Arg. out of range?", x, ncalc, nb, alpha));
            } else {
                System.err.println(String.format("bessel_y(%g,nu=%g): precision lost in result", x, alpha + (double)nb - 1.0));
            }
        }
        return by[nb - 1];
    }

    public static final double i(double x, double alpha, boolean expo) {
        if (Double.isNaN(x) || Double.isNaN(alpha)) {
            return x + alpha;
        }
        if (x < 0.0) {
            return Double.NaN;
        }
        int na = (int)Math.floor(alpha);
        if (alpha < 0.0) {
            return Bessel.i(x, -alpha, expo) + (alpha == (double)na ? 0.0 : Bessel.k(x, -alpha, expo) * (!expo ? 2.0 : 2.0 * Math.exp(-2.0 * x)) / Math.PI * MathFunctions.sinpi(-alpha));
        }
        int nb = 1 + na;
        double[] bi = new double[nb];
        int ncalc = Bessel.i_internal(x, alpha -= (double)(nb - 1), expo, bi);
        if (ncalc != nb) {
            if (ncalc < 0) {
                System.err.println(String.format("bessel_i(%g): ncalc (=%ld) != nb (=%ld); alpha=%g. Arg. out of range?", x, ncalc, nb, alpha));
            } else {
                System.err.println(String.format("bessel_i(%g,nu=%g): precision lost in result", x, alpha + (double)nb - 1.0));
            }
        }
        return bi[nb - 1];
    }

    public static final double k(double x, double alpha, boolean expo) {
        double[] bk;
        int nb;
        int ncalc;
        if (Double.isNaN(x) || Double.isNaN(alpha)) {
            return x + alpha;
        }
        if (x < 0.0) {
            return Double.NaN;
        }
        if (alpha < 0.0) {
            alpha = -alpha;
        }
        if ((ncalc = Bessel.k_internal(x, alpha -= (double)((nb = 1 + (int)Math.floor(alpha)) - 1), expo, bk = new double[nb])) != nb) {
            if (ncalc < 0) {
                System.err.println(String.format("bessel_k(%g): ncalc (=%ld) != nb (=%ld); alpha=%g. Arg. out of range?", x, ncalc, nb, alpha));
            } else {
                System.err.println(String.format("bessel_k(%g,nu=%g): precision lost in result", x, alpha + (double)nb - 1.0));
            }
        }
        return bk[nb - 1];
    }

    private static final int j_internal(double x, double alpha, double[] b) {
        int ncalc;
        block42: {
            double alp2em;
            double alpem;
            double sum;
            long l;
            double bb;
            double pold;
            long nend;
            long intx;
            double twonu;
            double nu;
            int nb;
            block43: {
                double[] fact;
                block41: {
                    double pi2 = 0.6366197723675814;
                    double twopi1 = 6.28125;
                    double twopi2 = 0.001935307179586477;
                    fact = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0, 3628800.0, 3.99168E7, 4.790016E8, 6.2270208E9, 8.71782912E10, 1.307674368E12, 2.0922789888E13, 3.55687428096E14, 6.402373705728E15, 1.21645100408832E17, 2.43290200817664E18, 5.109094217170944E19, 1.1240007277776077E21, 2.585201673888498E22, 6.204484017332394E23};
                    nb = b.length;
                    nu = alpha;
                    twonu = nu + nu;
                    if (nb <= 0 || x < 0.0 || nu < 0.0 || nu > 1.0) {
                        b[0] = 0.0;
                        return Math.min(nb, 0) - 1;
                    }
                    ncalc = nb;
                    Arrays.fill(b, 0.0);
                    if (x > 100000.0) {
                        return ncalc;
                    }
                    intx = (long)x;
                    if (!(x < 1.0E-4)) break block41;
                    double alpem2 = 1.0 + nu;
                    double halfx = x > 8.9E-308 ? 0.5 * x : 0.0;
                    double aa = nu != 0.0 ? Math.pow(halfx, nu) / (nu * MathFunctions.gamma_cody(nu)) : 1.0;
                    double bb2 = x + 1.0 > 1.0 ? -halfx * halfx : 0.0;
                    b[0] = aa + aa * bb2 / alpem2;
                    if (x != 0.0 && b[0] == 0.0) {
                        ncalc = 0;
                    }
                    if (nb == 1) break block42;
                    if (x <= 0.0) {
                        for (int n = 1; n < nb; ++n) {
                            b[n] = 0.0;
                        }
                    } else {
                        double tover = bb2 == 0.0 ? 1.78E-307 / x : 8.9E-308 / bb2;
                        double cc = halfx;
                        for (int n = 1; n < nb; ++n) {
                            aa /= alpem2;
                            if ((aa *= cc) <= tover * (alpem2 += 1.0)) {
                                aa = 0.0;
                            }
                            b[n] = aa + aa * bb2 / alpem2;
                            if (b[n] != 0.0 || ncalc < n) continue;
                            ncalc = n;
                        }
                    }
                    break block42;
                }
                if (!(x > 25.0) || (long)nb > intx + 1L) break block43;
                double xc = Math.sqrt(0.6366197723675814 / x);
                double xin = 1.0 / (64.0 * x * x);
                long m = x >= 130.0 ? 4L : (x >= 35.0 ? 8L : 11L);
                double xm = 4.0 * (double)m;
                double t = MathFunctions.trunc(x / (Math.PI * 2) + 0.5);
                double z = x - t * 6.28125 - t * 0.001935307179586477 - (nu + 0.5) / 0.6366197723675814;
                double vsin = Math.sin(z);
                double vcos = Math.cos(z);
                double gnu = twonu;
                for (int i = 0; i < 2; ++i) {
                    long k;
                    double s = (xm - 1.0 - gnu) * (xm - 1.0 + gnu) * xin * 0.5;
                    t = (gnu - (xm - 3.0)) * (gnu + (xm - 3.0));
                    double t1 = (gnu - (xm + 1.0)) * (gnu + (xm + 1.0));
                    double capp = s * t / fact[(int)k];
                    double capq = s * t1 / fact[(int)k + 1];
                    double xk = xm;
                    for (k = m + m; k >= 4L; k -= 2L) {
                        s = ((xk -= 4.0) - 1.0 - gnu) * (xk - 1.0 + gnu);
                        t1 = t;
                        t = (gnu - (xk - 3.0)) * (gnu + (xk - 3.0));
                        capp = (capp + 1.0 / fact[(int)k - 2]) * s * t * xin;
                        capq = (capq + 1.0 / fact[(int)k - 1]) * s * t1 * xin;
                    }
                    capq = (capq + 1.0) * (gnu * gnu - 1.0) * (0.125 / x);
                    b[i] = xc * ((capp += 1.0) * vcos - capq * vsin);
                    if (nb == 1) {
                        return ncalc;
                    }
                    t = vsin;
                    vsin = -vcos;
                    vcos = t;
                    gnu += 2.0;
                }
                if (nb <= 2) break block42;
                gnu = twonu + 2.0;
                int j = 2;
                while (j < nb) {
                    b[j] = gnu * b[j - 1] / x - b[j - 2];
                    ++j;
                    gnu += 2.0;
                }
                break block42;
            }
            long nbmx = (long)nb - intx;
            long n = intx + 1L;
            double en = (double)(n + n) + twonu;
            double plast = 1.0;
            double p = en / x;
            double test = 2.0E16;
            boolean skip_to_L190 = false;
            if (nbmx >= 3L) {
                double tover = 1.0E292;
                long nstart = intx + 2L;
                nend = nb - 1;
                en = (double)(nstart + nstart) - 2.0 + twonu;
                long k = nstart;
                while (k <= nend) {
                    n = k++;
                    plast = p;
                    pold = plast;
                    if (!((p = (en += 2.0) * plast / x - pold) > tover)) continue;
                    tover = 1.0E308;
                    double psave = p /= tover;
                    double psavel = plast /= tover;
                    nstart = n + 1L;
                    do {
                        ++n;
                    } while ((p = (en += 2.0) * (plast = p) / x - (pold = plast)) <= 1.0);
                    bb = en / x;
                    test = pold * plast * (0.5 - 0.5 / (bb * bb));
                    test /= 1.0E16;
                    p = plast * tover;
                    en -= 2.0;
                    nend = Math.min((long)nb, --n);
                    for (l = nstart; l <= nend; ++l) {
                        psavel = psave;
                        pold = psavel;
                        if (!((psave = en * psavel / x - pold) * psavel > test)) continue;
                        ncalc = (int)(l - 1L);
                        skip_to_L190 = true;
                        break;
                    }
                    if (!skip_to_L190) {
                        ncalc = (int)nend;
                    }
                    skip_to_L190 = true;
                    break;
                }
                if (!skip_to_L190) {
                    n = nend;
                    en = (double)(n + n) + twonu;
                    test = Math.max(test, Math.sqrt(plast * 1.0E16) * Math.sqrt(p + p));
                }
            }
            if (!skip_to_L190) {
                do {
                    ++n;
                } while ((p = (en += 2.0) * (plast = p) / x - (pold = plast)) < test);
            }
            skip_to_L190 = false;
            en += 2.0;
            bb = 0.0;
            double aa = 1.0 / p;
            long m = ++n / 2L;
            double em = m;
            if ((m = (n << 1) - (m << 2)) == 0L) {
                sum = 0.0;
            } else {
                alpem = em - 1.0 + nu;
                alp2em = em + em + nu;
                sum = aa * alpem * alp2em / em;
            }
            nend = n - (long)nb;
            for (l = 1L; l <= nend; ++l) {
                --n;
                double cc = bb;
                bb = aa;
                aa = (en -= 2.0) * bb / x - cc;
                long l2 = m = m != 0L ? 0L : 2L;
                if (m == 0L) continue;
                alp2em = (em -= 1.0) + em + nu;
                if (n == 1L) break;
                alpem = em - 1.0 + nu;
                if (alpem == 0.0) {
                    alpem = 1.0;
                }
                sum = (sum + aa * alp2em) * alpem / em;
            }
            b[(int)(n - 1L)] = aa;
            boolean skip_to_L250 = false;
            boolean skip_to_L240 = false;
            if (nend >= 0L) {
                if (nb <= 1) {
                    alp2em = nu + 1.0 == 1.0 ? 1.0 : nu;
                    sum += b[0] * alp2em;
                    skip_to_L250 = true;
                } else {
                    b[(int)(--n - 1L)] = (en -= 2.0) * aa / x - bb;
                    if (n != 1L) {
                        long l3 = m = m != 0L ? 0L : 2L;
                        if (m != 0L) {
                            alp2em = (em -= 1.0) + em + nu;
                            alpem = em - 1.0 + nu;
                            if (alpem == 0.0) {
                                alpem = 1.0;
                            }
                            sum = (sum + b[(int)(n - 1L)] * alp2em) * alpem / em;
                        }
                    } else {
                        skip_to_L240 = true;
                    }
                }
            }
            if (!skip_to_L240 && !skip_to_L250) {
                --n;
                while (n >= 2L) {
                    b[(int)(n - 1L)] = (en -= 2.0) * b[(int)n] / x - b[(int)(n + 1L)];
                    long l4 = m = m != 0L ? 0L : 2L;
                    if (m != 0L) {
                        alp2em = (em -= 1.0) + em + nu;
                        alpem = em - 1.0 + nu;
                        if (alpem == 0.0) {
                            alpem = 1.0;
                        }
                        sum = (sum + b[(int)(n - 1L)] * alp2em) * alpem / em;
                    }
                    --n;
                }
                b[0] = 2.0 * (nu + 1.0) * b[1] / x - b[2];
            }
            skip_to_L240 = false;
            if (!skip_to_L250) {
                if ((alp2em = (em -= 1.0) + em + nu) == 0.0) {
                    alp2em = 1.0;
                }
                sum += b[0] * alp2em;
            }
            skip_to_L250 = false;
            if (Math.abs(nu) > 1.0E-15) {
                sum *= MathFunctions.gamma_cody(nu) * Math.pow(0.5 * x, -nu);
            }
            aa = 8.9E-308;
            if (sum > 1.0) {
                aa *= sum;
            }
            for (int nn = 0; nn < nb; ++nn) {
                if (Math.abs(b[nn]) < aa) {
                    b[nn] = 0.0;
                    continue;
                }
                int n2 = nn;
                b[n2] = b[n2] / sum;
            }
        }
        return ncalc;
    }

    private static final int y_internal(double x, double alpha, double[] by) {
        int ncalc;
        double fivpi = Math.PI * 5;
        double pim5 = 0.7079632679489662;
        double[] ch = new double[]{-6.773524182239884E-24, -6.145518011604988E-23, 2.9017595056104746E-21, 1.36394179190731E-19, 2.3826220476859634E-18, -9.064290795755071E-18, -1.4943667065169001E-15, -3.391907830536221E-14, -1.702377664251273E-13, 9.160975093876865E-12, 2.42309579004827E-10, 1.7451364971382985E-9, -3.3126119768180853E-8, -8.659207996139126E-7, -4.9717367041957395E-6, 7.630959758590813E-5, 0.0012719271366545622, 0.0017063050710955563, -0.07685284084478668, -0.28387654227602355, 0.9218702936504527};
        int nb = by.length;
        double ya1 = 0.0;
        double ya = 0.0;
        double en1 = 0.0;
        double ex = x;
        double nu = alpha;
        if (nb > 0 && 0.0 <= nu && nu < 1.0) {
            double h;
            double r;
            double q;
            double g;
            double aye;
            int i;
            double s;
            double en;
            double c;
            double e;
            double f;
            double d;
            double b;
            double p;
            if (ex < Double.MIN_NORMAL || ex > 1.0E8) {
                int ncalc2 = nb;
                if (ex > 1.0E8) {
                    by[0] = 0.0;
                } else if (ex < Double.MIN_NORMAL) {
                    by[0] = Double.NEGATIVE_INFINITY;
                }
                for (int i2 = 0; i2 < nb; ++i2) {
                    by[i2] = by[0];
                }
                return ncalc2;
            }
            double xna = MathFunctions.trunc(nu + 0.5);
            long na = (long)xna;
            if (na == 1L) {
                nu -= xna;
            }
            if (nu == -0.5) {
                p = 0.7978845608028654 / Math.sqrt(ex);
                ya = p * Math.sin(ex);
                ya1 = -p * Math.cos(ex);
            } else if (ex < 3.0) {
                double x2;
                b = ex * 0.5;
                d = -Math.log(b);
                f = nu * d;
                e = Math.pow(b, -nu);
                c = Math.abs(nu) < 2.149E-8 ? 0.3183098861837907 : nu / MathFunctions.sinpi(nu);
                if (Math.abs(f) < 1.0) {
                    x2 = f * f;
                    en = 19.0;
                    s = 1.0;
                    for (i = 1; i <= 9; ++i) {
                        s = s * x2 / en / (en - 1.0) + 1.0;
                        en -= 2.0;
                    }
                } else {
                    s = (e - 1.0 / e) * 0.5 / f;
                }
                x2 = nu * nu * 8.0;
                aye = ch[0];
                double even = 0.0;
                double alfa = ch[1];
                double odd = 0.0;
                for (i = 3; i <= 19; i += 2) {
                    even = -(aye + aye + even);
                    aye = -even * x2 - aye + ch[i - 1];
                    odd = -(alfa + alfa + odd);
                    alfa = -odd * x2 - alfa + ch[i];
                }
                even = (even * 0.5 + aye) * x2 - aye + ch[20];
                odd = (odd + alfa) * 2.0;
                double gamma = odd * nu + even;
                g = e * gamma;
                e = (e + 1.0 / e) * 0.5;
                f = 2.0 * c * (odd * e + even * s * d);
                e = nu * nu;
                p = g * c;
                q = 0.3183098861837907 / g;
                c = nu * 1.5707963267948966;
                r = Math.abs(c) < 2.149E-8 ? 1.0 : MathFunctions.sinpi(nu / 2.0) / c;
                r = Math.PI * c * r * r;
                c = 1.0;
                d = -b * b;
                h = 0.0;
                ya = f + r * q;
                ya1 = p;
                en = 1.0;
                while (Math.abs(g / (1.0 + Math.abs(ya))) + Math.abs(h / (1.0 + Math.abs(ya1))) > 2.220446049250313E-16) {
                    f = (f * en + p + q) / (en * en - e);
                    g = (c *= d / en) * (f + r * (q /= en + nu));
                    h = c * (p /= en - nu) - en * g;
                    ya += g;
                    ya1 += h;
                    en += 1.0;
                }
                ya = -ya;
                ya1 = -ya1 / b;
            } else if (ex < 16.0) {
                c = (0.5 - nu) * (0.5 + nu);
                b = ex + ex;
                e = ex * 0.3183098861837907 * MathFunctions.cospi(nu) / 2.220446049250313E-16;
                e *= e;
                p = 1.0;
                q = -ex;
                s = r = 1.0 + ex * ex;
                en = 2.0;
                while (r * en * en < e) {
                    en1 = en + 1.0;
                    d = (en - 1.0 + c / en) / s;
                    p = (en + en - p * d) / en1;
                    q = (-b + q * d) / en1;
                    s = p * p + q * q;
                    r *= s;
                    en = en1;
                }
                p = f = p / s;
                q = g = -q / s;
                en -= 1.0;
                while (en > 0.0) {
                    r = en1 * (2.0 - p) - 2.0;
                    s = b + en1 * q;
                    d = (en - 1.0 + c / en) / (r * r + s * s);
                    p = d * r;
                    q = d * s;
                    e = f + 1.0;
                    f = p * e - g * q;
                    g = q * e + p * g;
                    en1 = en;
                    en -= 1.0;
                }
                f = 1.0 + f;
                d = f * f + g * g;
                double pa = f / d;
                double qa = -g / d;
                d = nu + 0.5 - p;
                double pa1 = (pa * (q += ex) - qa * d) / ex;
                double qa1 = (qa * q + pa * d) / ex;
                b = ex - 1.5707963267948966 * (nu + 0.5);
                c = Math.cos(b);
                s = Math.sin(b);
                d = 0.7978845608028654 / Math.sqrt(ex);
                ya = d * (pa * s + qa * c);
                ya1 = d * (qa1 * s - pa1 * c);
            } else {
                double sinmu;
                double cosmu;
                na = 0L;
                double d1 = MathFunctions.trunc(ex / (Math.PI * 5));
                i = (int)d1;
                double dmu = ex - 15.0 * d1 - d1 * 0.7079632679489662 - (alpha + 0.5) * 1.5707963267948966;
                if (i - (i / 2 << 1) == 0) {
                    cosmu = Math.cos(dmu);
                    sinmu = Math.sin(dmu);
                } else {
                    cosmu = -Math.cos(dmu);
                    sinmu = -Math.sin(dmu);
                }
                double ddiv = 8.0 * ex;
                dmu = alpha;
                double den = Math.sqrt(ex);
                for (long k = 1L; k <= 2L; ++k) {
                    double q0;
                    p = cosmu;
                    cosmu = sinmu;
                    sinmu = -p;
                    d1 = (2.0 * dmu - 1.0) * (2.0 * dmu + 1.0);
                    double d2 = 0.0;
                    double div = ddiv;
                    p = 0.0;
                    q = 0.0;
                    double term = q0 = d1 / div;
                    for (i = 2; i <= 20; ++i) {
                        term = -term * (d1 -= (d2 += 8.0)) / (div += ddiv);
                        p += term;
                        q += (term *= (d1 -= (d2 += 8.0)) / (div += ddiv));
                        if (Math.abs(term) <= 2.220446049250313E-16) break;
                    }
                    p += 1.0;
                    q += q0;
                    if (k == 1L) {
                        ya = 0.7978845608028654 * (p * cosmu - q * sinmu) / den;
                    } else {
                        ya1 = 0.7978845608028654 * (p * cosmu - q * sinmu) / den;
                    }
                    dmu += 1.0;
                }
            }
            if (na == 1L) {
                h = 2.0 * (nu + 1.0) / ex;
                if (h > 1.0 && Math.abs(ya1) > Double.MAX_VALUE / h) {
                    h = 0.0;
                    ya = 0.0;
                }
                h = h * ya1 - ya;
                ya = ya1;
                ya1 = h;
            }
            by[0] = ya;
            ncalc = 1;
            if (nb > 1) {
                by[1] = ya1;
                if (ya1 != 0.0) {
                    aye = 1.0 + alpha;
                    double twobyx = 2.0 / ex;
                    ncalc = 2;
                    for (i = 2; i < nb && !(twobyx < 1.0 ? Math.abs(by[i - 1]) * twobyx >= Double.MAX_VALUE / aye : Math.abs(by[i - 1]) >= Double.MAX_VALUE / aye / twobyx); ++i) {
                        by[i] = twobyx * aye * by[i - 1] - by[i - 2];
                        aye += 1.0;
                        ++ncalc;
                    }
                }
            }
            for (i = ncalc; i < nb; ++i) {
                by[i] = Double.NEGATIVE_INFINITY;
            }
        } else {
            by[0] = 0.0;
            ncalc = Math.min(nb, 0) - 1;
        }
        return ncalc;
    }

    private static final int i_internal(double x, double alpha, boolean expo, double[] bi) {
        double const__ = 1.585;
        int nb = bi.length;
        int ncalc = 0;
        int ize = expo ? 2 : 1;
        double nu = alpha;
        double twonu = nu + nu;
        if (nb > 0 && x >= 0.0 && 0.0 <= nu && nu < 1.0) {
            ncalc = nb;
            if (ize == 1 && x > 709.0) {
                Arrays.fill(bi, Double.POSITIVE_INFINITY);
                return ncalc;
            }
            if (ize == 2 && x > 100000.0) {
                Arrays.fill(bi, 0.0);
                return ncalc;
            }
            long intx = (long)x;
            if (x >= 1.0E-4) {
                long l;
                double bb;
                double pold;
                long nend;
                long nbmx = (long)nb - intx;
                long n = intx + 1L;
                double en = (double)(n + n) + twonu;
                double plast = 1.0;
                double p = en / x;
                double test = 2.0E16;
                test = (double)(intx << 1) > 80.0 ? Math.sqrt(test * p) : (test /= Math.pow(1.585, intx));
                boolean skip_to_L120 = false;
                if (nbmx >= 3L) {
                    double tover = 1.0E292;
                    long nstart = intx + 2L;
                    nend = nb - 1;
                    long k = nstart;
                    while (k <= nend) {
                        n = k++;
                        plast = p;
                        pold = plast;
                        if (!((p = (en += 2.0) * plast / x + pold) > tover)) continue;
                        tover = 1.0E308;
                        double psave = p /= tover;
                        double psavel = plast /= tover;
                        nstart = n + 1L;
                        do {
                            ++n;
                        } while ((p = (en += 2.0) * (plast = p) / x + (pold = plast)) <= 1.0);
                        bb = en / x;
                        test = pold * plast / 1.0E16;
                        test *= 0.5 - 0.5 / (bb * bb);
                        p = plast * tover;
                        en -= 2.0;
                        nend = Math.min((long)nb, --n);
                        boolean skip_to_L90 = false;
                        for (l = nstart; l <= nend; ++l) {
                            ncalc = (int)l;
                            psavel = psave;
                            pold = psavel;
                            if (!((psave = en * psavel / x + pold) * psavel > test)) continue;
                            skip_to_L90 = true;
                            break;
                        }
                        if (!skip_to_L90) {
                            ncalc = (int)(nend + 1L);
                        }
                        skip_to_L90 = false;
                        --ncalc;
                        skip_to_L120 = true;
                        break;
                    }
                    if (!skip_to_L120) {
                        n = nend;
                        en = (double)(n + n) + twonu;
                        test = Math.max(test, Math.sqrt(plast * 1.0E16) * Math.sqrt(p + p));
                    }
                }
                if (!skip_to_L120) {
                    do {
                        ++n;
                    } while ((p = (en += 2.0) * (plast = p) / x + (pold = plast)) < test);
                }
                skip_to_L120 = false;
                en += 2.0;
                bb = 0.0;
                double aa = 1.0 / p;
                double em = (double)(++n) - 1.0;
                double empal = em + nu;
                double emp2al = em - 1.0 + twonu;
                double sum = aa * empal * emp2al / em;
                nend = n - (long)nb;
                boolean skip_to_L220 = false;
                boolean skip_to_L230 = false;
                if (nend < 0L) {
                    bi[(int)(n - 1L)] = aa;
                    nend = -nend;
                    for (l = 1L; l <= nend; ++l) {
                        bi[(int)(n + l - 1L)] = 0.0;
                    }
                } else {
                    if (nend > 0L) {
                        for (l = 1L; l <= nend; ++l) {
                            --n;
                            en -= 2.0;
                            double cc = bb;
                            bb = aa;
                            if (nend > 100L && aa > 1.0E200) {
                                cc = MathFunctions.ldexp(cc, -900);
                                bb = MathFunctions.ldexp(bb, -900);
                                sum = MathFunctions.ldexp(sum, -900);
                            }
                            aa = en * bb / x + cc;
                            em -= 1.0;
                            emp2al -= 1.0;
                            if (n == 1L) break;
                            if (n == 2L) {
                                emp2al = 1.0;
                            }
                            sum = (sum + aa * (empal -= 1.0)) * emp2al / em;
                        }
                    }
                    bi[(int)(n - 1L)] = aa;
                    if (nb <= 1) {
                        sum = sum + sum + aa;
                        skip_to_L230 = true;
                    } else {
                        bi[(int)(--n - 1L)] = (en -= 2.0) * aa / x + bb;
                        if (n != 1L) {
                            emp2al = n == 2L ? 1.0 : (emp2al -= 1.0);
                            sum = (sum + bi[(int)(n - 1L)] * (empal -= 1.0)) * emp2al / (em -= 1.0);
                        } else {
                            skip_to_L220 = true;
                        }
                    }
                }
                if (!skip_to_L220 && !skip_to_L230) {
                    nend = n - 2L;
                    if (nend > 0L) {
                        for (l = 1L; l <= nend; ++l) {
                            bi[(int)(--n - 1L)] = (en -= 2.0) * bi[(int)n] / x + bi[(int)n + 1];
                            emp2al = n == 2L ? 1.0 : (emp2al -= 1.0);
                            sum = (sum + bi[(int)(n - 1L)] * (empal -= 1.0)) * emp2al / (em -= 1.0);
                        }
                    }
                    bi[0] = 2.0 * empal * bi[1] / x + bi[2];
                }
                skip_to_L220 = false;
                if (!skip_to_L230) {
                    sum = sum + sum + bi[0];
                }
                skip_to_L230 = false;
                if (nu != 0.0) {
                    sum *= MathFunctions.gamma_cody(1.0 + nu) * Math.pow(x * 0.5, -nu);
                }
                if (ize == 1) {
                    sum *= Math.exp(-x);
                }
                aa = 8.9E-308;
                if (sum > 1.0) {
                    aa *= sum;
                }
                for (n = 1L; n <= (long)nb; ++n) {
                    if (bi[(int)(n - 1L)] < aa) {
                        bi[(int)(n - 1L)] = 0.0;
                        continue;
                    }
                    int n2 = (int)(n - 1L);
                    bi[n2] = bi[n2] / sum;
                }
                return ncalc;
            }
            double aa = 1.0;
            double empal = 1.0 + nu;
            double halfx = 0.5 * x;
            if (nu != 0.0) {
                aa = Math.pow(halfx, nu) / MathFunctions.gamma_cody(empal);
            }
            if (ize == 2) {
                aa *= Math.exp(-x);
            }
            double bb = halfx * halfx;
            bi[0] = aa + aa * bb / empal;
            if (x != 0.0 && bi[0] == 0.0) {
                ncalc = 0;
            }
            if (nb > 1) {
                if (x == 0.0) {
                    for (long n = 2L; n <= (long)nb; ++n) {
                        bi[(int)(n - 1L)] = 0.0;
                    }
                } else {
                    double cc = halfx;
                    double tover = 1.78E-307 / x;
                    if (bb != 0.0) {
                        tover = 8.9E-308 / bb;
                    }
                    for (long n = 2L; n <= (long)nb; ++n) {
                        aa /= empal;
                        if ((aa *= cc) <= tover * (empal += 1.0)) {
                            aa = 0.0;
                            bi[(int)(n - 1L)] = 0.0;
                        } else {
                            bi[(int)(n - 1L)] = aa + aa * bb / empal;
                        }
                        if (bi[(int)(n - 1L)] != 0.0 || (long)ncalc <= n) continue;
                        ncalc = (int)(n - 1L);
                    }
                }
            }
        } else {
            ncalc = Math.min(nb, 0) - 1;
        }
        return ncalc;
    }

    private static final int k_internal(double x, double alpha, boolean expo, double[] bk) {
        double a = 0.11593151565841245;
        double[] p = new double[]{0.8056298756904329, 20.404550020536515, 157.7056051066762, 536.6711164692075, 900.3827592912887, 730.9238866506604, 229.29930150942513, 0.8224670334241132};
        double[] q = new double[]{29.460198624785043, 277.5778685102212, 1206.7032559102745, 2762.9144415979154, 3443.740505065646, 2210.6319011337864, 572.2673383598922};
        double[] r = new double[]{-0.48672575865218404, 13.079485869097804, -101.96490580880537, 347.65409106507815, 3.495898124521935E-4};
        double[] s = new double[]{-25.57910550997646, 212.57260432226545, -610.6901868494411, 422.6966880577776};
        double[] t = new double[]{1.6125990452916364E-10, 2.5051878502858254E-8, 2.7557319615147965E-6, 1.9841269840928374E-4, 0.008333333333333475, 0.16666666666666666};
        double[] estm = new double[]{52.0583, 5.7607, 2.7782, 14.4303, 185.3004, 9.3715};
        double[] estf = new double[]{41.8341, 7.1075, 6.4306, 42.511, 1.35633, 84.5096, 20.0};
        double wminf = 0.0;
        double bk1 = 0.0;
        double bk2 = 0.0;
        int nb = bk.length;
        int ize = expo ? 2 : 1;
        long ii = 0L;
        double ex = x;
        double nu = alpha;
        int ncalc = Math.min(nb, 0) - 2;
        if (nb > 0 && 0.0 <= nu && nu < 1.0) {
            long m;
            double f2;
            double ratio;
            double p0;
            double f0;
            double f1;
            int i;
            double t1;
            double d2;
            double d1;
            if (ex <= 0.0 || ize == 1 && ex > 705.342) {
                if (ex <= 0.0) {
                    if (ex < 0.0) {
                        throw new RuntimeException("K_bessel");
                    }
                    Arrays.fill(bk, Double.POSITIVE_INFINITY);
                } else {
                    Arrays.fill(bk, 0.0);
                }
                return nb;
            }
            int k = 0;
            if (nu < 1.49E-154) {
                nu = 0.0;
            } else if (nu > 0.5) {
                k = 1;
                nu -= 1.0;
            }
            double twonu = nu + nu;
            long iend = nb + k - 1;
            double c = nu * nu;
            double d3 = -c;
            if (ex <= 1.0) {
                d1 = 0.0;
                d2 = p[0];
                t1 = 1.0;
                double t2 = q[0];
                for (i = 2; i <= 7; i += 2) {
                    d1 = c * d1 + p[i - 1];
                    d2 = c * d2 + p[i];
                    t1 = c * t1 + q[i - 1];
                    t2 = c * t2 + q[i];
                }
                d1 = nu * d1;
                t1 = nu * t1;
                f1 = Math.log(ex);
                f0 = 0.11593151565841245 + nu * (p[7] - nu * (d1 + d2) / (t1 + t2)) - f1;
                double q0 = Math.exp(-nu * (0.11593151565841245 - nu * (p[7] + nu * (d1 - d2) / (t1 - t2)) - f1));
                f1 = nu * f0;
                p0 = Math.exp(f1);
                d1 = r[4];
                t1 = 1.0;
                for (i = 0; i < 4; ++i) {
                    d1 = c * d1 + r[i];
                    t1 = c * t1 + s[i];
                }
                if (Math.abs(f1) <= 0.5) {
                    f1 *= f1;
                    d2 = 0.0;
                    for (i = 0; i < 6; ++i) {
                        d2 = f1 * d2 + t[i];
                    }
                    d2 = f0 + f0 * f1 * d2;
                } else {
                    d2 = Math.sinh(f1) / nu;
                }
                f0 = d2 - nu * d1 / (t1 * p0);
                if (ex <= 1.0E-10) {
                    bk[0] = f0 + ex * f0;
                    if (ize == 1) {
                        bk[0] = bk[0] - ex * bk[0];
                    }
                    ratio = p0 / f0;
                    c = ex * Double.MAX_VALUE;
                    if (k != 0) {
                        ncalc = -1;
                        if (bk[0] >= c / ratio) {
                            return ncalc;
                        }
                        bk[0] = ratio * bk[0] / ex;
                        ratio = twonu += 2.0;
                    }
                    ncalc = 1;
                    if (nb == 1) {
                        return ncalc;
                    }
                    ncalc = -1;
                    for (i = 1; i < nb; ++i) {
                        if (ratio >= c) {
                            return ncalc;
                        }
                        bk[i] = ratio / ex;
                        ratio = twonu += 2.0;
                    }
                    for (i = ncalc = 1; i < nb; ++i) {
                        int n = i;
                        bk[n] = bk[n] * bk[i - 1];
                        ++ncalc;
                    }
                } else {
                    c = 1.0;
                    double x2by4 = ex * ex / 4.0;
                    p0 = 0.5 * p0;
                    q0 = 0.5 * q0;
                    d1 = -1.0;
                    d2 = 0.0;
                    bk1 = 0.0;
                    bk2 = 0.0;
                    f1 = f0;
                    f2 = p0;
                    do {
                        d3 = (d1 += 2.0) + d3;
                        c = x2by4 * c / (d2 += 1.0);
                        f0 = (d2 * f0 + p0 + q0) / d3;
                        q0 /= d2 + nu;
                        t1 = c * f0;
                        t2 = c * ((p0 /= d2 - nu) - d2 * f0);
                    } while (Math.abs(t1 / (f1 + (bk1 += t1))) > 2.220446049250313E-16 || Math.abs(t2 / (f2 + (bk2 += t2))) > 2.220446049250313E-16);
                    bk1 = f1 + bk1;
                    bk2 = 2.0 * (f2 + bk2) / ex;
                    if (ize == 2) {
                        d1 = Math.exp(ex);
                        bk1 *= d1;
                        bk2 *= d1;
                    }
                    wminf = estf[0] * ex + estf[1];
                }
            } else {
                if (2.220446049250313E-16 * ex > 1.0) {
                    ncalc = nb;
                    bk1 = 1.0 / (0.7978845608028654 * Math.sqrt(ex));
                    for (int i2 = 0; i2 < nb; ++i2) {
                        bk[i2] = bk1;
                    }
                    return ncalc;
                }
                double twox = ex + ex;
                double blpha = 0.0;
                ratio = 0.0;
                if (ex <= 4.0) {
                    d2 = MathFunctions.trunc(estm[0] / ex + estm[1]);
                    m = (long)d2;
                    d1 = d2 + d2;
                    d2 -= 0.5;
                    d2 *= d2;
                    i = 2;
                    while ((long)i <= m) {
                        ratio = (d3 + (d2 -= (d1 -= 2.0))) / (twox + d1 - ratio);
                        ++i;
                    }
                    d2 = MathFunctions.trunc(estm[2] * ex + estm[3]);
                    m = (long)d2;
                    c = Math.abs(nu);
                    d3 = c + c;
                    d1 = d3 - 1.0;
                    f1 = Double.MIN_NORMAL;
                    f0 = (2.0 * (c + d2) / ex + 0.5 * ex / (c + d2 + 1.0)) * Double.MIN_NORMAL;
                    i = 3;
                    while ((long)i <= m) {
                        f2 = (d3 + (d2 -= 1.0) + d2) * f0;
                        blpha = (1.0 + d1 / d2) * (f2 + blpha);
                        f2 = f2 / ex + f1;
                        f1 = f0;
                        f0 = f2;
                        ++i;
                    }
                    f1 = (d3 + 2.0) * f0 / ex + f1;
                    d1 = 0.0;
                    t1 = 1.0;
                    for (i = 1; i <= 7; ++i) {
                        d1 = c * d1 + p[i - 1];
                        t1 = c * t1 + q[i - 1];
                    }
                    p0 = Math.exp(c * (0.11593151565841245 + c * (p[7] - c * d1 / t1) - Math.log(ex))) / ex;
                    f2 = (c + 0.5 - ratio) * f1 / ex;
                    bk1 = p0 + (d3 * f0 - f2 + f0 + blpha) / (f2 + f1 + f0) * p0;
                    if (ize == 1) {
                        bk1 *= Math.exp(-ex);
                    }
                    wminf = estf[2] * ex + estf[3];
                } else {
                    double dm = MathFunctions.trunc(estm[4] / ex + estm[5]);
                    m = (long)dm;
                    d2 = dm - 0.5;
                    d2 *= d2;
                    d1 = dm + dm;
                    i = 2;
                    while ((long)i <= m) {
                        ratio = (d3 + (d2 -= (d1 -= 2.0))) / (twox + d1 - ratio);
                        blpha = (ratio + ratio * blpha) / (dm -= 1.0);
                        ++i;
                    }
                    bk1 = 1.0 / ((0.7978845608028654 + 0.7978845608028654 * blpha) * Math.sqrt(ex));
                    if (ize == 1) {
                        bk1 *= Math.exp(-ex);
                    }
                    wminf = estf[4] * (ex - Math.abs(ex - estf[6])) + estf[5];
                }
                bk2 = bk1 + bk1 * (nu + 0.5 - ratio) / ex;
            }
            ncalc = nb;
            bk[0] = bk1;
            if (iend == 0L) {
                return ncalc;
            }
            int j = 1 - k;
            if (j >= 0) {
                bk[j] = bk2;
            }
            if (iend == 1L) {
                return ncalc;
            }
            m = Math.min((long)(wminf - nu), iend);
            i = 2;
            while ((long)i <= m) {
                t1 = bk1;
                bk1 = bk2;
                if (ex < 1.0 ? bk1 >= Double.MAX_VALUE / twonu * ex : bk1 / ex >= Double.MAX_VALUE / (twonu += 2.0)) break;
                bk2 = twonu / ex * bk1 + t1;
                ii = i;
                if (++j >= 0) {
                    bk[j] = bk2;
                }
                ++i;
            }
            if ((m = ii) == iend) {
                return ncalc;
            }
            ratio = bk2 / bk1;
            long mplus1 = m + 1L;
            ncalc = -1;
            i = (int)mplus1;
            while ((long)i <= iend) {
                ratio = (twonu += 2.0) / ex + 1.0 / ratio;
                if (++j >= 1) {
                    bk[j] = ratio;
                } else {
                    if (bk2 >= Double.MAX_VALUE / ratio) {
                        return ncalc;
                    }
                    bk2 *= ratio;
                }
                ++i;
            }
            ncalc = (int)Math.max(1L, mplus1 - (long)k);
            if (ncalc == 1) {
                bk[0] = bk2;
            }
            if (nb == 1) {
                return ncalc;
            }
            for (i = ncalc; i < nb; ++i) {
                int n = i;
                bk[n] = bk[n] * bk[i - 1];
                ++ncalc;
            }
        }
        return ncalc;
    }
}

