/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.generic.GenericDistribution;
import jdistlib.rng.RandomEngine;

public class Logarithmic
extends GenericDistribution {
    protected double mu;

    public static final double density(double x, double mu, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(mu)) {
            return x + mu;
        }
        if (mu <= 0.0 || mu >= 1.0) {
            return Double.NaN;
        }
        double logfy = x * Math.log(mu) - Math.log(x) - Math.log(-Math.log(1.0 - mu));
        return give_log ? logfy : Math.exp(logfy);
    }

    public static final double cumulative(double q, double mu, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(q) || Double.isNaN(mu)) {
            return q + mu;
        }
        if (mu <= 0.0 || mu >= 1.0 || q <= 0.0) {
            return Double.NaN;
        }
        double sum = 0.0;
        int i = 1;
        while ((double)i <= q) {
            sum += Math.exp((double)i * Math.log(mu) - Math.log(i) - Math.log(-Math.log(1.0 - mu)));
            ++i;
        }
        sum = lower_tail ? sum : 1.0 - sum;
        return log_p ? Math.log(sum) : sum;
    }

    public static final double quantile(double p, double mu, boolean lower_tail, boolean log_p) {
        return Logarithmic.quantile(p, mu, lower_tail, log_p, 10000);
    }

    public static final double quantile(double p, double mu, boolean lower_tail, boolean log_p, int max_value) {
        if (Double.isNaN(p) || Double.isNaN(mu)) {
            return p + mu;
        }
        if (mu <= 0.0 || mu >= 1.0) {
            return Double.NaN;
        }
        if (p < 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p > 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        p = log_p ? Math.exp(p) : p;
        p = lower_tail ? p : 1.0 - p;
        double sum = 0.0;
        for (int i = 0; i < max_value; ++i) {
            if (!(p <= (sum += Math.exp((double)i * Math.log(mu) - Math.log(i) - Math.log(-Math.log(1.0 - mu)))))) continue;
            return i;
        }
        return Double.NaN;
    }

    public static final double random(double mu, RandomEngine random) {
        double u1 = random.nextDouble();
        u1 = (double)((int)(1.34217728E8 * u1)) + random.nextDouble();
        u1 = Logarithmic.quantile(u1 / 1.34217728E8, mu, true, false);
        return u1;
    }

    public static final double[] random(int n, double mu, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = Logarithmic.random(mu, random);
        }
        return rand;
    }

    public Logarithmic(double mu) {
        this.mu = mu;
    }

    @Override
    public double density(double x, boolean log) {
        return Logarithmic.density(x, this.mu, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Logarithmic.cumulative(p, this.mu, lower_tail, log_p);
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Logarithmic.quantile(q, this.mu, lower_tail, log_p);
    }

    @Override
    public double random() {
        return Logarithmic.random(this.mu, this.random);
    }
}

