/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.ser;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.joda.beans.ser.DefaultDeserializer;
import org.joda.beans.ser.SerDeserializer;
import org.joda.beans.ser.SerDeserializerProvider;

public final class SerDeserializers {
    public static final SerDeserializers INSTANCE = new SerDeserializers();
    private final ConcurrentMap<Class<?>, SerDeserializer> deserializers = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<SerDeserializerProvider> providers = new CopyOnWriteArrayList();

    public SerDeserializers() {
    }

    public SerDeserializers(SerDeserializerProvider ... providers) {
        this.providers.addAll(Arrays.asList(providers));
    }

    public SerDeserializers register(Class<?> type, SerDeserializer deserializer) {
        this.deserializers.put(type, deserializer);
        return this;
    }

    public ConcurrentMap<Class<?>, SerDeserializer> getDeserializers() {
        return this.deserializers;
    }

    public SerDeserializers registerProvider(SerDeserializerProvider provider) {
        this.providers.add(provider);
        return this;
    }

    public SerDeserializer findDeserializer(Class<?> type) {
        SerDeserializer deser = (SerDeserializer)this.deserializers.get(type);
        if (deser != null) {
            return deser;
        }
        for (SerDeserializerProvider provider : this.providers) {
            deser = provider.findDeserializer(type);
            if (deser == null) continue;
            return deser;
        }
        return DefaultDeserializer.INSTANCE;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

