/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.integrate.mongo;

import com.mongodb.DBObject;
import java.util.Map;
import java.util.Set;
import org.joda.beans.Bean;

public class BeanMongoDBObject
implements DBObject {
    private final Bean bean;
    private boolean partial;

    public BeanMongoDBObject(Bean bean) {
        this.bean = bean;
    }

    public boolean containsField(String name) {
        return this.bean.propertyNames().contains(name);
    }

    @Deprecated
    public boolean containsKey(String name) {
        return this.containsField(name);
    }

    public Object get(String name) {
        return this.bean.property(name).get();
    }

    public Object put(String name, Object value) {
        return this.bean.property(name).put(value);
    }

    public void putAll(DBObject object) {
        for (String name : object.keySet()) {
            this.put(name, object.get(name));
        }
    }

    public void putAll(Map map) {
        Map castMap = map;
        for (Map.Entry entry : castMap.entrySet()) {
            this.put(entry.getKey().toString(), map.get(entry.getValue()));
        }
    }

    public Object removeField(String name) {
        throw new UnsupportedOperationException("Remove unsupported");
    }

    public Set<String> keySet() {
        return this.bean.propertyNames();
    }

    public Map toMap() {
        return this.bean.metaBean().createPropertyMap(this.bean).flatten();
    }

    public boolean isPartialObject() {
        return this.partial;
    }

    public void markAsPartialObject() {
        this.partial = true;
    }
}

