/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.integrate.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.factories.ReflectionSerializerFactory;
import com.esotericsoftware.kryo.factories.SerializerFactory;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import org.joda.beans.Bean;
import org.joda.beans.ser.JodaBeanSer;

public final class KryoJodaBeanSerializer
implements SerializerFactory {
    private final SerializerFactory defaultSerializerFactory;

    public KryoJodaBeanSerializer() {
        this(FieldSerializer.class);
    }

    public KryoJodaBeanSerializer(Class<? extends Serializer> defaultSerializerType) {
        this.defaultSerializerFactory = new ReflectionSerializerFactory(defaultSerializerType);
    }

    public KryoJodaBeanSerializer(SerializerFactory defaultSerializerFactory) {
        this.defaultSerializerFactory = defaultSerializerFactory;
    }

    public Serializer makeSerializer(Kryo kryo, Class<?> type) {
        return new JodaBeanSerializer(this.defaultSerializerFactory.makeSerializer(kryo, type));
    }

    final class JodaBeanSerializer<T>
    extends Serializer<T> {
        private final Serializer<T> defaultSerializer;

        JodaBeanSerializer(Serializer<T> defaultSerializer) {
            this.defaultSerializer = defaultSerializer;
        }

        public void write(Kryo kryo, Output output, T object) {
            if (object instanceof Bean) {
                byte[] bytes = JodaBeanSer.COMPACT.binWriter().write((Bean)object, false);
                output.writeVarInt(bytes.length, true);
                output.write(bytes);
            } else {
                this.defaultSerializer.write(kryo, output, object);
            }
        }

        public T read(Kryo kryo, Input input, Class<T> type) {
            if (Bean.class.isAssignableFrom(type)) {
                int len = input.readVarInt(true);
                byte[] bytes = input.readBytes(len);
                return JodaBeanSer.COMPACT.binReader().read(bytes, type);
            }
            return (T)this.defaultSerializer.read(kryo, input, type);
        }
    }
}

