/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl.reflection;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.joda.beans.Bean;
import org.joda.beans.MetaBean;
import org.joda.beans.Property;
import org.joda.beans.PropertyStyle;
import org.joda.beans.impl.BasicMetaProperty;
import org.joda.beans.impl.BasicProperty;

public final class ReflectiveMetaProperty<P>
extends BasicMetaProperty<P> {
    private volatile MetaBean metaBean;
    private final Class<?> declaringType;
    private final Class<P> propertyType;
    private final Method readMethod;
    private final Method writeMethod;

    public static <P> ReflectiveMetaProperty<P> of(Class<? extends Bean> beanType, String propertyName) {
        return new ReflectiveMetaProperty<P>(beanType, propertyName);
    }

    private ReflectiveMetaProperty(Class<? extends Bean> beanType, String propertyName) {
        super(propertyName);
        PropertyDescriptor descriptor;
        try {
            descriptor = new PropertyDescriptor(propertyName, beanType);
        }
        catch (IntrospectionException ex) {
            throw new NoSuchFieldError("Invalid property: " + propertyName + ": " + ex.getMessage());
        }
        Method readMethod = descriptor.getReadMethod();
        Method writeMethod = descriptor.getWriteMethod();
        if (readMethod == null && writeMethod == null) {
            throw new NoSuchFieldError("Invalid property: " + propertyName + ": Both read and write methods are missing");
        }
        this.declaringType = readMethod != null ? readMethod.getDeclaringClass() : writeMethod.getDeclaringClass();
        this.propertyType = descriptor.getPropertyType();
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
    }

    void setMetaBean(MetaBean metaBean) {
        this.metaBean = metaBean;
    }

    @Override
    public Property<P> createProperty(Bean bean) {
        return BasicProperty.of(bean, this);
    }

    @Override
    public MetaBean metaBean() {
        return this.metaBean;
    }

    @Override
    public Class<?> declaringType() {
        return this.declaringType;
    }

    @Override
    public Class<P> propertyType() {
        return this.propertyType;
    }

    @Override
    public Type propertyGenericType() {
        if (this.readMethod != null) {
            return this.readMethod.getGenericReturnType();
        }
        return this.writeMethod.getGenericParameterTypes()[0];
    }

    @Override
    public PropertyStyle style() {
        return this.readMethod == null ? PropertyStyle.WRITE_ONLY : (this.writeMethod == null ? PropertyStyle.READ_ONLY : PropertyStyle.READ_WRITE);
    }

    @Override
    public List<Annotation> annotations() {
        if (this.readMethod != null) {
            return Arrays.asList(this.readMethod.getDeclaredAnnotations());
        }
        return Arrays.asList(this.writeMethod.getDeclaredAnnotations());
    }

    @Override
    public P get(Bean bean) {
        if (!this.style().isReadable()) {
            throw new UnsupportedOperationException("Property cannot be read: " + this.name());
        }
        try {
            return (P)this.readMethod.invoke((Object)bean, (Object[])null);
        }
        catch (IllegalArgumentException ex) {
            throw new UnsupportedOperationException("Property cannot be read: " + this.name(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedOperationException("Property cannot be read: " + this.name(), ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void set(Bean bean, Object value) {
        if (!this.style().isWritable()) {
            throw new UnsupportedOperationException("Property cannot be written: " + this.name());
        }
        try {
            this.writeMethod.invoke((Object)bean, value);
        }
        catch (IllegalArgumentException ex) {
            if (value == null && this.writeMethod.getParameterTypes()[0].isPrimitive()) {
                throw new NullPointerException("Property cannot be written: " + this.name() + ": Cannot store null in primitive");
            }
            if (!this.propertyType.isInstance(value)) {
                throw new ClassCastException("Property cannot be written: " + this.name() + ": Invalid type: " + value.getClass().getName());
            }
            throw new UnsupportedOperationException("Property cannot be written: " + this.name(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedOperationException("Property cannot be written: " + this.name(), ex);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex);
        }
    }
}

