/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;

public class BufferingBeanBuilder<T extends Bean>
implements BeanBuilder<T> {
    private final MetaBean metaBean;
    private final ConcurrentMap<MetaProperty<?>, Object> buffer = new ConcurrentHashMap();

    public static BufferingBeanBuilder<?> of(MetaBean metaBean) {
        return new BufferingBeanBuilder(metaBean);
    }

    public BufferingBeanBuilder(MetaBean metaBean) {
        if (metaBean == null) {
            throw new NullPointerException("MetaBean must not be null");
        }
        this.metaBean = metaBean;
    }

    public MetaBean getMetaBean() {
        return this.metaBean;
    }

    public ConcurrentMap<MetaProperty<?>, Object> getBuffer() {
        return this.buffer;
    }

    @Override
    public Object get(String propertyName) {
        return this.get(this.getMetaBean().metaProperty(propertyName));
    }

    @Override
    public Object get(MetaProperty<?> metaProperty) {
        return this.getBuffer().get(metaProperty);
    }

    @Override
    public BeanBuilder<T> set(String propertyName, Object value) {
        return this.set(this.getMetaBean().metaProperty(propertyName), value);
    }

    @Override
    public BeanBuilder<T> set(MetaProperty<?> metaProperty, Object value) {
        this.getBuffer().put(metaProperty, value);
        return this;
    }

    @Override
    public BeanBuilder<T> setString(String propertyName, String value) {
        return this.setString(this.getMetaBean().metaProperty(propertyName), value);
    }

    @Override
    public BeanBuilder<T> setString(MetaProperty<?> metaProperty, String value) {
        Object object = JodaBeanUtils.stringConverter().convertFromString(metaProperty.propertyType(), value);
        return this.set(metaProperty, object);
    }

    @Override
    public BeanBuilder<T> setAll(Map<String, ? extends Object> propertyValueMap) {
        for (Map.Entry<String, ? extends Object> entry : propertyValueMap.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public T build() {
        BeanBuilder<? extends Bean> builder = this.getMetaBean().builder();
        for (Map.Entry entry : this.getBuffer().entrySet()) {
            builder.set((MetaProperty)entry.getKey(), entry.getValue());
        }
        return (T)builder.build();
    }

    public String toString() {
        return "BeanBuilder for " + this.metaBean.beanName();
    }
}

