/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.util;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.jplot2d.util.NumberUtils;

public class LineHatchPaint
implements Paint {
    private static final double EPSILON = Math.pow(10.0, -14.0);
    private static final Color DEFAULT_COLOR = Color.BLACK;
    private final Color color;
    private final BasicStroke stroke;
    private final double angle;
    private final double spacing;
    private final Comparator<Point2D> pointComparator;

    public LineHatchPaint(double angle) {
        this(0.0f, angle, 6.0);
    }

    public LineHatchPaint(float width, double angle, double spacing) {
        this(DEFAULT_COLOR, new BasicStroke(width), angle, spacing);
    }

    public LineHatchPaint(Color color, BasicStroke stroke, double angle, double spacing) {
        this.color = color;
        this.stroke = stroke;
        this.angle = angle;
        this.spacing = spacing;
        angle %= 360.0;
        if (angle < 0.0) {
            angle += 360.0;
        }
        this.pointComparator = 45.0 < angle && angle < 135.0 ? PointComparatorNY.getInstance() : (225.0 < angle && angle < 315.0 ? PointComparatorY.getInstance() : (135.0 <= angle && angle <= 225.0 ? PointComparatorNX.getInstance() : PointComparatorX.getInstance()));
    }

    public Color getColor() {
        return this.color;
    }

    public BasicStroke getStroke() {
        return this.stroke;
    }

    public double getAngle() {
        return this.angle;
    }

    public double getSpacing() {
        return this.spacing;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTransparency() {
        throw new UnsupportedOperationException();
    }

    public Shape[] calcHatchShapes(Shape shape, Rectangle2D clip, double scale) {
        Line2D[] clippedLines = LineHatchPaint.calcHatchLinesClipped(this, clip, scale);
        ArrayList<Line2D> result = new ArrayList<Line2D>();
        for (Line2D line : clippedLines) {
            Line2D[] ilines = this.calcLineSegInside(line, shape);
            result.addAll(Arrays.asList(ilines));
        }
        return result.toArray(new Shape[result.size()]);
    }

    public static Line2D[] calcHatchLinesClipped(LineHatchPaint lhp, Rectangle2D clip, double scale) {
        double anglex = lhp.getAngle() % 180.0;
        if (anglex > 90.0) {
            anglex = 180.0 - anglex;
        } else if (anglex < -90.0) {
            anglex += 180.0;
        } else if (anglex < 0.0) {
            anglex = -anglex;
        }
        double diagonalLength = Math.hypot(clip.getHeight(), clip.getWidth());
        double diagonalAngle = Math.atan(clip.getHeight() / clip.getWidth());
        double halfLength = diagonalLength / 2.0 * Math.cos((anglex *= Math.PI / 180) - diagonalAngle);
        double halfRange = diagonalLength / 2.0 * Math.sin(anglex + diagonalAngle);
        double spacing = lhp.getSpacing() * scale;
        int halfn = (int)(halfRange / spacing);
        Line2D[] result = new Line2D[2 * halfn + 1];
        double angle = -lhp.getAngle() * Math.PI / 180.0;
        double a0x = clip.getCenterX() - halfLength * Math.cos(angle);
        double a0y = clip.getCenterY() - halfLength * Math.sin(angle);
        double b0x = clip.getCenterX() + halfLength * Math.cos(angle);
        double b0y = clip.getCenterY() + halfLength * Math.sin(angle);
        for (int i = 0; i < result.length; ++i) {
            double aix = a0x - (double)(i - halfn) * spacing * Math.sin(angle);
            double aiy = a0y + (double)(i - halfn) * spacing * Math.cos(angle);
            double bix = b0x - (double)(i - halfn) * spacing * Math.sin(angle);
            double biy = b0y + (double)(i - halfn) * spacing * Math.cos(angle);
            result[i] = new Line2D.Double(aix, aiy, bix, biy);
        }
        return result;
    }

    private Line2D[] calcLineSegInside(Line2D line, Shape shape) {
        HashSet<Point2D> inersects = new HashSet<Point2D>();
        inersects.add(line.getP1());
        inersects.add(line.getP2());
        double[] segCoords = new double[6];
        double[] inersectCoords = new double[2];
        double lastMoveX = 0.0;
        double prex = 0.0;
        double lastMoveY = 0.0;
        double prey = 0.0;
        PathIterator pi = shape.getPathIterator(null);
        while (!pi.isDone()) {
            int segType = pi.currentSegment(segCoords);
            switch (segType) {
                case 0: {
                    lastMoveX = prex = segCoords[0];
                    lastMoveY = prey = segCoords[1];
                    break;
                }
                case 1: {
                    if (segCoords[0] == lastMoveX && segCoords[1] == lastMoveY) break;
                    boolean its = LineHatchPaint.intersectLines(line, prex, prey, segCoords[0], segCoords[1], inersectCoords);
                    if (its) {
                        inersects.add(new Point2D.Double(inersectCoords[0], inersectCoords[1]));
                    }
                    prex = segCoords[0];
                    prey = segCoords[1];
                    break;
                }
                case 2: {
                    boolean itqs = LineHatchPaint.intersectLines(line, prex, prey, segCoords[2], segCoords[3], inersectCoords);
                    if (itqs) {
                        inersects.add(new Point2D.Double(inersectCoords[0], inersectCoords[1]));
                    }
                    prex = segCoords[2];
                    prey = segCoords[3];
                    break;
                }
                case 3: {
                    boolean itcs = LineHatchPaint.intersectLines(line, prex, prey, segCoords[4], segCoords[5], inersectCoords);
                    if (itcs) {
                        inersects.add(new Point2D.Double(inersectCoords[0], inersectCoords[1]));
                    }
                    prex = segCoords[4];
                    prey = segCoords[5];
                    break;
                }
                case 4: {
                    boolean its;
                    if (prex == lastMoveX && prey == lastMoveY || !(its = LineHatchPaint.intersectLines(line, prex, prey, lastMoveX, lastMoveY, inersectCoords))) break;
                    inersects.add(new Point2D.Double(inersectCoords[0], inersectCoords[1]));
                }
            }
            pi.next();
        }
        Point2D[] ips = inersects.toArray(new Point2D[inersects.size()]);
        Arrays.sort(ips, this.pointComparator);
        ArrayList<Line2D.Double> result = new ArrayList<Line2D.Double>();
        int i = 0;
        for (int j = 1; j < ips.length; ++j) {
            double y;
            double x = (ips[i].getX() + ips[j].getX()) / 2.0;
            if (shape.contains(x, y = (ips[i].getY() + ips[j].getY()) / 2.0)) {
                result.add(new Line2D.Double(ips[i], ips[j]));
            }
            ++i;
        }
        return result.toArray(new Line2D[result.size()]);
    }

    public static boolean intersectLines(Line2D line, double x3, double y3, double x4, double y4, double[] point) {
        double x;
        double y;
        double dxa = line.getX1() - line.getX2();
        double dya = line.getY1() - line.getY2();
        double dxb = x3 - x4;
        double dyb = y3 - y4;
        double ca = line.getX1() * line.getY2() - line.getY1() * line.getX2();
        double cb = x3 * y4 - y3 * x4;
        double coefParallel = dxa * dyb - dya * dxb;
        if (NumberUtils.approximate(x3, x4, 4) && NumberUtils.approximate(y3, y4, 4) && NumberUtils.approximate(dxa * (y = (y3 + y4) / 2.0) - dya * (x = (x3 + x4) / 2.0), ca, 4)) {
            point[0] = x;
            point[1] = y;
            return true;
        }
        if (Math.abs(coefParallel) < EPSILON) {
            return false;
        }
        if (NumberUtils.approximate(line.getX1(), line.getX2(), 4)) {
            point[0] = (line.getX1() + line.getX2()) / 2.0;
            point[1] = (point[0] * dyb + cb) / dxb;
            return LineHatchPaint.approxBetween(line.getY1(), line.getY2(), point[1]) && LineHatchPaint.approxBetween(x3, x4, point[0]);
        }
        if (NumberUtils.approximate(line.getY1(), line.getY2(), 4)) {
            point[1] = (line.getY1() + line.getY2()) / 2.0;
            point[0] = (point[1] * dxb - cb) / dyb;
            return LineHatchPaint.approxBetween(line.getX1(), line.getX2(), point[0]) && LineHatchPaint.approxBetween(y3, y4, point[1]);
        }
        point[0] = (ca * dxb - dxa * cb) / coefParallel;
        point[1] = (ca * dyb - dya * cb) / coefParallel;
        boolean inlineA = false;
        boolean inlineB = false;
        inlineA = Math.abs(dxa) > Math.abs(dya) ? LineHatchPaint.approxBetween(line.getX1(), line.getX2(), point[0]) : LineHatchPaint.approxBetween(line.getY1(), line.getY2(), point[1]);
        inlineB = Math.abs(dxb) > Math.abs(dyb) ? LineHatchPaint.approxBetween(x3, x4, point[0]) : LineHatchPaint.approxBetween(y3, y4, point[1]);
        return inlineA && inlineB;
    }

    public static boolean approxBetween(double a, double b, double v) {
        if (a > b ? a >= v && v >= b : a <= v && v <= b) {
            return true;
        }
        return NumberUtils.approximate(a, v, 4) || NumberUtils.approximate(b, v, 4);
    }

    public static final class PointComparatorNY
    implements Comparator<Point2D> {
        private static Comparator<Point2D> instance = new PointComparatorNY();

        public static Comparator<Point2D> getInstance() {
            return instance;
        }

        @Override
        public int compare(Point2D p1, Point2D p2) {
            double d = p1.getY() - p2.getY();
            if (d > 0.0) {
                return -1;
            }
            if (d < 0.0) {
                return 1;
            }
            return 0;
        }
    }

    public static final class PointComparatorY
    implements Comparator<Point2D> {
        private static Comparator<Point2D> instance = new PointComparatorY();

        public static Comparator<Point2D> getInstance() {
            return instance;
        }

        @Override
        public int compare(Point2D p1, Point2D p2) {
            double d = p1.getY() - p2.getY();
            if (d > 0.0) {
                return 1;
            }
            if (d < 0.0) {
                return -1;
            }
            return 0;
        }
    }

    public static final class PointComparatorNX
    implements Comparator<Point2D> {
        private static Comparator<Point2D> instance = new PointComparatorNX();

        public static Comparator<Point2D> getInstance() {
            return instance;
        }

        @Override
        public int compare(Point2D p1, Point2D p2) {
            double d = p1.getX() - p2.getX();
            if (d > 0.0) {
                return -1;
            }
            if (d < 0.0) {
                return 1;
            }
            return 0;
        }
    }

    public static final class PointComparatorX
    implements Comparator<Point2D> {
        private static Comparator<Point2D> instance = new PointComparatorX();

        public static Comparator<Point2D> getInstance() {
            return instance;
        }

        @Override
        public int compare(Point2D p1, Point2D p2) {
            double d = p1.getX() - p2.getX();
            if (d > 0.0) {
                return 1;
            }
            if (d < 0.0) {
                return -1;
            }
            return 0;
        }
    }
}

