/*
 * Decompiled with CFR 0.152.
 */
package org.jplot2d.tex;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.util.ArrayList;
import java.util.List;
import org.jplot2d.tex.MathElement;

public abstract class MathLabelComp {
    private static float SUBSUPERSCRIPT_SIZE = 0.583f;
    private static double SUBSCRIPT_POS = 0.333;
    private static double SUPERSCRIPT_POS = 0.333;
    protected MathElement _me;
    protected double _width;
    protected Font _font;
    protected float _ascent;
    protected float _descent;
    protected float _leading;
    protected double boxAscent;
    protected double boxDescent;
    protected double _x;
    protected double _y;

    protected static MathLabelComp getBoxInstance(MathElement me, double x, double y, Font font, boolean wstyle) {
        if (me instanceof MathElement.PToken) {
            return new Ptoken((MathElement.PToken)me, x, y, font, wstyle);
        }
        if (me instanceof MathElement.Msub) {
            return new Msub((MathElement.Msub)me, x, y, font, wstyle);
        }
        if (me instanceof MathElement.Msup) {
            return new Msup((MathElement.Msup)me, x, y, font, wstyle);
        }
        if (me instanceof MathElement.Msubsup) {
            return new Msubsup((MathElement.Msubsup)me, x, y, font, wstyle);
        }
        if (me instanceof MathElement.PContainer) {
            if (me instanceof MathElement.Mstyle) {
                wstyle = true;
                font = MathLabelComp.deriveMathVariantFont(font, ((MathElement.Mstyle)me).getMathVariant());
            }
            return new PContainer((MathElement.PContainer)me, x, y, font, wstyle);
        }
        return null;
    }

    private static Font deriveMathVariantFont(Font font, MathElement.MathVariant mathVariant) {
        switch (mathVariant) {
            case NORMAL: {
                return font.deriveFont(0);
            }
            case ITALIC: {
                return font.deriveFont(font.getStyle() | 2);
            }
            case BOLD: {
                return font.deriveFont(font.getStyle() | 1);
            }
        }
        return font;
    }

    protected MathLabelComp(MathElement me, Font font, double x, double y) {
        this._me = me;
        this._font = font;
        this._x = x;
        this._y = y;
        this.computeFontHeight();
    }

    private void computeFontHeight() {
        FontRenderContext frc = new FontRenderContext(null, false, true);
        LineMetrics lm = this._font.getLineMetrics("Can be any string", frc);
        this._ascent = lm.getAscent();
        this._descent = lm.getDescent();
        this._leading = lm.getLeading();
        this.boxAscent = this._ascent;
        this.boxDescent = this._descent;
    }

    protected void relayout(float fontSize, double x, double y) {
        this._font = this._font.deriveFont(fontSize);
        this._x = x;
        this._y = y;
        this.computeFontHeight();
    }

    protected void pan(double xoff, double yoff) {
        if (xoff != 0.0 || yoff != 0.0) {
            this._x += xoff;
            this._y += yoff;
        }
    }

    protected abstract void draw(Graphics2D var1);

    protected double getWidth() {
        return this._width;
    }

    protected double getAscent() {
        return this.boxAscent;
    }

    protected double getDescent() {
        return this.boxDescent;
    }

    protected double getLeading() {
        return this._leading;
    }

    private static class PContainer
    extends MathLabelComp {
        private List<MathLabelComp> _subEL = new ArrayList<MathLabelComp>();

        private PContainer(MathElement.PContainer me, double x, double y, Font font, boolean wstyle) {
            super(me, font, x, y);
            double nextLocx = this._x;
            for (MathElement.PElement pe : me.getElementList()) {
                MathLabelComp ml = MathLabelComp.getBoxInstance(pe, nextLocx, this._y, this._font, wstyle);
                this._subEL.add(ml);
                nextLocx += ml._width;
                if (this.boxAscent < ml.boxAscent) {
                    this.boxAscent = ml.boxAscent;
                }
                if (!(this.boxDescent < ml.boxDescent)) continue;
                this.boxDescent = ml.boxDescent;
            }
            this._width = nextLocx - this._x;
        }

        @Override
        protected void relayout(float fontSize, double x, double y) {
            super.relayout(fontSize, x, y);
            if (this._subEL.size() == 0) {
                this._width = 0.0;
            } else {
                double w = 0.0;
                for (int i = 0; i < this._subEL.size(); ++i) {
                    MathLabelComp ml = this._subEL.get(i);
                    ml.relayout(fontSize, x + w, y);
                    w += this._subEL.get((int)i)._width;
                    if (this.boxAscent < ml.boxAscent) {
                        this.boxAscent = ml.boxAscent;
                    }
                    if (!(this.boxDescent < ml.boxDescent)) continue;
                    this.boxDescent = ml.boxDescent;
                }
                this._width = w;
            }
        }

        @Override
        protected void pan(double xoff, double yoff) {
            super.pan(xoff, yoff);
            if (xoff != 0.0 || yoff != 0.0) {
                for (MathLabelComp ml : this._subEL) {
                    ml.pan(xoff, yoff);
                }
            }
        }

        @Override
        protected void draw(Graphics2D g2) {
            for (MathLabelComp ml : this._subEL) {
                ml.draw(g2);
            }
        }
    }

    private static class Msubsup
    extends MathLabelComp {
        MathLabelComp _base;
        MathLabelComp _sub;
        MathLabelComp _sup;

        private Msubsup(MathElement.Msubsup me, double x, double y, Font font, boolean wstyle) {
            super(me, font, x, y);
            this._base = MathLabelComp.getBoxInstance(me.base, this._x, this._y, this._font, wstyle);
            Font subsupfont = this._font.deriveFont(this._font.getSize2D() * SUBSUPERSCRIPT_SIZE);
            double subsuplocx = this._x + this._base._width;
            double sublocy = this._y + SUBSCRIPT_POS * (double)(this._ascent + this._descent) - (double)((1.0f - SUBSUPERSCRIPT_SIZE) * (this._ascent - this._descent) / 2.0f);
            double suplocy = this._y - SUPERSCRIPT_POS * (double)(this._ascent + this._descent) - (double)((1.0f - SUBSUPERSCRIPT_SIZE) * (this._ascent - this._descent) / 2.0f);
            this._sub = MathLabelComp.getBoxInstance(((MathElement.Msubsup)this._me).subscript, subsuplocx, sublocy, subsupfont, wstyle);
            this._sup = MathLabelComp.getBoxInstance(((MathElement.Msubsup)this._me).superscript, subsuplocx, suplocy, subsupfont, wstyle);
            double ssw = this._sub._width > this._sup._width ? this._sub._width : this._sup._width;
            this._width = this._base._width + ssw;
            this.boxAscent = y - suplocy + this._sup.getAscent();
            this.boxDescent = sublocy - y + this._sub.getDescent();
        }

        @Override
        protected void relayout(float fontSize, double x, double y) {
            super.relayout(fontSize, x, y);
            this._base.relayout(fontSize, x, y);
            float subsupfont = this._font.getSize2D() * SUBSUPERSCRIPT_SIZE;
            double subsuplocx = this._x + this._base._width;
            double sublocy = this._y + SUBSCRIPT_POS * (double)(this._ascent + this._descent) - (double)((1.0f - SUBSUPERSCRIPT_SIZE) * (this._ascent - this._descent) / 2.0f);
            double suplocy = this._y - SUPERSCRIPT_POS * (double)(this._ascent + this._descent) - (double)((1.0f - SUBSUPERSCRIPT_SIZE) * (this._ascent - this._descent) / 2.0f);
            this._sub.relayout(subsupfont, subsuplocx, sublocy);
            this._sup.relayout(subsupfont, subsuplocx, suplocy);
            double ssw = this._sub._width > this._sup._width ? this._sub._width : this._sup._width;
            this._width = this._base._width + ssw;
            this.boxAscent = y - suplocy + this._sup.getAscent();
            this.boxDescent = sublocy - y + this._sub.getDescent();
        }

        @Override
        protected void pan(double xoff, double yoff) {
            super.pan(xoff, yoff);
            this._base.pan(xoff, yoff);
            this._sub.pan(xoff, yoff);
            this._sup.pan(xoff, yoff);
        }

        @Override
        protected void draw(Graphics2D g2) {
            this._base.draw(g2);
            this._sub.draw(g2);
            this._sup.draw(g2);
        }
    }

    private static class Msup
    extends MathLabelComp {
        MathLabelComp _base;
        MathLabelComp _sup;

        private Msup(MathElement.Msup me, double x, double y, Font font, boolean wstyle) {
            super(me, font, x, y);
            this._base = MathLabelComp.getBoxInstance(me.base, this._x, this._y, this._font, wstyle);
            Font supfont = this._font.deriveFont(this._font.getSize2D() * SUBSUPERSCRIPT_SIZE);
            double suplocx = this._x + this._base._width;
            double suplocy = this._y - SUPERSCRIPT_POS * (double)(this._ascent + this._descent) - (double)((1.0f - SUBSUPERSCRIPT_SIZE) * (this._ascent - this._descent) / 2.0f);
            this._sup = MathLabelComp.getBoxInstance(((MathElement.Msup)this._me).superscript, suplocx, suplocy, supfont, wstyle);
            this._width = this._base._width + this._sup._width;
            this.boxAscent = y - suplocy + this._sup.getAscent();
        }

        @Override
        protected void relayout(float fontSize, double x, double y) {
            super.relayout(fontSize, x, y);
            this._base.relayout(fontSize, x, y);
            float supfont = this._font.getSize2D() * SUBSUPERSCRIPT_SIZE;
            double suplocx = this._x + this._base._width;
            double suplocy = this._y - SUPERSCRIPT_POS * (double)(this._ascent + this._descent) - (double)((1.0f - SUBSUPERSCRIPT_SIZE) * (this._ascent - this._descent) / 2.0f);
            this._sup.relayout(supfont, suplocx, suplocy);
            this._width = this._base._width + this._sup._width;
            this.boxAscent = y - suplocy + this._sup.getAscent();
        }

        @Override
        protected void pan(double xoff, double yoff) {
            super.pan(xoff, yoff);
            this._base.pan(xoff, yoff);
            this._sup.pan(xoff, yoff);
        }

        @Override
        protected void draw(Graphics2D g2) {
            this._base.draw(g2);
            this._sup.draw(g2);
        }
    }

    private static class Msub
    extends MathLabelComp {
        MathLabelComp _base;
        MathLabelComp _sub;

        private Msub(MathElement.Msub me, double x, double y, Font font, boolean wstyle) {
            super(me, font, x, y);
            this._base = MathLabelComp.getBoxInstance(me.base, this._x, this._y, this._font, wstyle);
            Font subfont = this._font.deriveFont(this._font.getSize2D() * SUBSUPERSCRIPT_SIZE);
            double sublocx = this._x + this._base._width;
            double sublocy = this._y + SUBSCRIPT_POS * (double)(this._ascent + this._descent) - (double)((1.0f - SUBSUPERSCRIPT_SIZE) * (this._ascent - this._descent) / 2.0f);
            this._sub = MathLabelComp.getBoxInstance(((MathElement.Msub)this._me).subscript, sublocx, sublocy, subfont, wstyle);
            this._width = this._base._width + this._sub._width;
            this.boxDescent = sublocy - y + this._sub.getDescent();
        }

        @Override
        protected void relayout(float fontSize, double x, double y) {
            super.relayout(fontSize, x, y);
            this._base.relayout(fontSize, x, y);
            float subfont = this._font.getSize2D() * SUBSUPERSCRIPT_SIZE;
            double sublocx = this._x + this._base._width;
            double sublocy = this._y + SUBSCRIPT_POS * (double)(this._ascent + this._descent) - (double)((1.0f - SUBSUPERSCRIPT_SIZE) * (this._ascent - this._descent) / 2.0f);
            this._sub.relayout(subfont, sublocx, sublocy);
            this._width = this._base._width + this._sub._width;
            this.boxDescent = sublocy - y + this._sub.getDescent();
        }

        @Override
        protected void pan(double xoff, double yoff) {
            super.pan(xoff, yoff);
            this._base.pan(xoff, yoff);
            this._sub.pan(xoff, yoff);
        }

        @Override
        protected void draw(Graphics2D g2) {
            this._base.draw(g2);
            this._sub.draw(g2);
        }
    }

    private static class Ptoken
    extends MathLabelComp {
        private String _str;

        private Ptoken(MathElement.PToken me, double x, double y, Font font, boolean wstyle) {
            super(me, font, x, y);
            this._str = me.getToken();
            if (!wstyle && this._me instanceof MathElement.Mi) {
                this._font = this._font.deriveFont(2);
            }
            double lw = this.getStrLogicalWidth();
            if (this._font.getStyle() == 2) {
                lw += (double)((this._ascent + this._descent) * this._font.getItalicAngle());
            }
            this._width = lw;
        }

        @Override
        protected void relayout(float fontSize, double x, double y) {
            super.relayout(fontSize, x, y);
            double lw = this.getStrLogicalWidth();
            if (this._font.getStyle() == 2) {
                lw += (double)((this._ascent + this._descent) * this._font.getItalicAngle());
            }
            this._width = lw;
        }

        @Override
        protected void draw(Graphics2D g2) {
            g2.setFont(this._font);
            g2.drawString(this._str, (float)this._x, (float)this._y);
        }

        private double getStrLogicalWidth() {
            FontRenderContext frc = new FontRenderContext(null, false, true);
            double dwidth = this._font.getStringBounds(this._str, frc).getWidth();
            return dwidth;
        }
    }
}

